/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.orm.stream;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jinq.orm.stream.InQueryStreamSource;
import org.jinq.orm.stream.NonQueryJinqStream;
import org.jinq.tuples.Pair;
import org.jinq.tuples.Tuple3;
import org.jinq.tuples.Tuple4;
import org.jinq.tuples.Tuple5;
import org.jinq.tuples.Tuple6;
import org.jinq.tuples.Tuple7;
import org.jinq.tuples.Tuple8;

public interface JinqStream<T>
extends Stream<T> {
    public <E extends Exception> JinqStream<T> where(Where<T, E> var1);

    public <E extends Exception> JinqStream<T> where(WhereWithSource<T, E> var1);

    public <U> JinqStream<U> select(Select<T, U> var1);

    public <U> JinqStream<U> select(SelectWithSource<T, U> var1);

    public <U> JinqStream<U> selectAll(Join<T, U> var1);

    public <U> JinqStream<U> selectAll(JoinWithSource<T, U> var1);

    public <U> JinqStream<U> selectAllList(JoinToIterable<T, U> var1);

    public <U> JinqStream<Pair<T, U>> join(Join<T, U> var1);

    public <U> JinqStream<Pair<T, U>> join(JoinWithSource<T, U> var1);

    public <U> JinqStream<Pair<T, U>> joinList(JoinToIterable<T, U> var1);

    public <U> JinqStream<Pair<T, U>> leftOuterJoin(Join<T, U> var1);

    public <U> JinqStream<Pair<T, U>> leftOuterJoinList(JoinToIterable<T, U> var1);

    public <U> JinqStream<Pair<T, U>> leftOuterJoin(JoinWithSource<T, U> var1, WhereForOn<T, U> var2);

    public <U> JinqStream<Pair<T, U>> crossJoin(JinqStream<U> var1);

    public <U, V> JinqStream<Pair<U, V>> group(Select<T, U> var1, AggregateGroup<U, T, V> var2);

    public <U, V, W> JinqStream<Tuple3<U, V, W>> group(Select<T, U> var1, AggregateGroup<U, T, V> var2, AggregateGroup<U, T, W> var3);

    public <U, V, W, X> JinqStream<Tuple4<U, V, W, X>> group(Select<T, U> var1, AggregateGroup<U, T, V> var2, AggregateGroup<U, T, W> var3, AggregateGroup<U, T, X> var4);

    public <U, V, W, X, Y> JinqStream<Tuple5<U, V, W, X, Y>> group(Select<T, U> var1, AggregateGroup<U, T, V> var2, AggregateGroup<U, T, W> var3, AggregateGroup<U, T, X> var4, AggregateGroup<U, T, Y> var5);

    public <U, V, W, X, Y, Z> JinqStream<Tuple6<U, V, W, X, Y, Z>> group(Select<T, U> var1, AggregateGroup<U, T, V> var2, AggregateGroup<U, T, W> var3, AggregateGroup<U, T, X> var4, AggregateGroup<U, T, Y> var5, AggregateGroup<U, T, Z> var6);

    public <U, V, W, X, Y, Z, A> JinqStream<Tuple7<U, V, W, X, Y, Z, A>> group(Select<T, U> var1, AggregateGroup<U, T, V> var2, AggregateGroup<U, T, W> var3, AggregateGroup<U, T, X> var4, AggregateGroup<U, T, Y> var5, AggregateGroup<U, T, Z> var6, AggregateGroup<U, T, A> var7);

    public <U, V, W, X, Y, Z, A, B> JinqStream<Tuple8<U, V, W, X, Y, Z, A, B>> group(Select<T, U> var1, AggregateGroup<U, T, V> var2, AggregateGroup<U, T, W> var3, AggregateGroup<U, T, X> var4, AggregateGroup<U, T, Y> var5, AggregateGroup<U, T, Z> var6, AggregateGroup<U, T, A> var7, AggregateGroup<U, T, B> var8);

    public Long sumInteger(CollectInteger<T> var1);

    public Long sumLong(CollectLong<T> var1);

    public Double sumDouble(CollectDouble<T> var1);

    public BigDecimal sumBigDecimal(CollectBigDecimal<T> var1);

    public BigInteger sumBigInteger(CollectBigInteger<T> var1);

    public <V extends Comparable<V>> V max(CollectComparable<T, V> var1);

    public <V extends Comparable<V>> V min(CollectComparable<T, V> var1);

    public <V extends Number> Double avg(CollectNumber<T, V> var1);

    public <U, V> Pair<U, V> aggregate(AggregateSelect<T, U> var1, AggregateSelect<T, V> var2);

    public <U, V, W> Tuple3<U, V, W> aggregate(AggregateSelect<T, U> var1, AggregateSelect<T, V> var2, AggregateSelect<T, W> var3);

    public <U, V, W, X> Tuple4<U, V, W, X> aggregate(AggregateSelect<T, U> var1, AggregateSelect<T, V> var2, AggregateSelect<T, W> var3, AggregateSelect<T, X> var4);

    public <U, V, W, X, Y> Tuple5<U, V, W, X, Y> aggregate(AggregateSelect<T, U> var1, AggregateSelect<T, V> var2, AggregateSelect<T, W> var3, AggregateSelect<T, X> var4, AggregateSelect<T, Y> var5);

    public <V extends Comparable<V>> JinqStream<T> sortedBy(CollectComparable<T, V> var1);

    public <V extends Comparable<V>> JinqStream<T> sortedDescendingBy(CollectComparable<T, V> var1);

    @Override
    public JinqStream<T> skip(long var1);

    @Override
    public JinqStream<T> limit(long var1);

    @Override
    public JinqStream<T> distinct();

    @Override
    public long count();

    public Optional<T> findOne();

    @Override
    default public Optional<T> findFirst() {
        List<T> vals = this.limit(1L).toList();
        if (vals.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(vals.get(0));
    }

    default public boolean exists() {
        return !this.limit(1L).toList().isEmpty();
    }

    public T getOnlyValue();

    @Override
    public List<T> toList();

    public String getDebugQueryString();

    @Deprecated
    public void propagateException(Object var1, Throwable var2);

    @Deprecated
    public Collection<Throwable> getExceptions();

    public JinqStream<T> setHint(String var1, Object var2);

    public static <U> JinqStream<U> from(Collection<U> collection) {
        return new NonQueryJinqStream<U>(collection.stream());
    }

    public static <U> JinqStream<U> of(U value) {
        return new NonQueryJinqStream<U>(Stream.of(value));
    }

    @FunctionalInterface
    public static interface AggregateSelect<U, V>
    extends Serializable {
        public V aggregateSelect(JinqStream<U> var1);
    }

    @FunctionalInterface
    public static interface CollectBigInteger<U>
    extends CollectNumber<U, BigInteger> {
    }

    @FunctionalInterface
    public static interface CollectBigDecimal<U>
    extends CollectNumber<U, BigDecimal> {
    }

    @FunctionalInterface
    public static interface CollectDouble<U>
    extends CollectNumber<U, Double> {
    }

    @FunctionalInterface
    public static interface CollectLong<U>
    extends CollectNumber<U, Long> {
    }

    @FunctionalInterface
    public static interface CollectInteger<U>
    extends CollectNumber<U, Integer> {
    }

    @FunctionalInterface
    public static interface CollectComparable<U, V extends Comparable<V>>
    extends Serializable {
        public V aggregate(U var1);
    }

    @FunctionalInterface
    public static interface CollectNumber<U, V extends Number>
    extends Serializable {
        public V aggregate(U var1);
    }

    @FunctionalInterface
    public static interface AggregateGroup<W, U, V>
    extends Serializable {
        public V aggregateSelect(W var1, JinqStream<U> var2);
    }

    @FunctionalInterface
    public static interface WhereForOn<U, V>
    extends Serializable {
        public boolean where(U var1, V var2);
    }

    @FunctionalInterface
    public static interface JoinToIterable<U, V>
    extends Serializable {
        public Iterable<V> join(U var1);
    }

    @FunctionalInterface
    public static interface JoinWithSource<U, V>
    extends Serializable {
        public JinqStream<V> join(U var1, InQueryStreamSource var2);
    }

    @FunctionalInterface
    public static interface Join<U, V>
    extends Serializable {
        public JinqStream<V> join(U var1);
    }

    @FunctionalInterface
    public static interface SelectWithSource<U, V>
    extends Serializable {
        public V select(U var1, InQueryStreamSource var2);
    }

    @FunctionalInterface
    public static interface Select<U, V>
    extends Serializable {
        public V select(U var1);
    }

    @FunctionalInterface
    public static interface WhereWithSource<U, E extends Exception>
    extends Serializable {
        public boolean where(U var1, InQueryStreamSource var2) throws E;
    }

    @FunctionalInterface
    public static interface Where<U, E extends Exception>
    extends Serializable {
        public boolean where(U var1) throws E;
    }
}

