/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.jpqlquery;

import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.ExpressionVisitor;
import org.jinq.jpa.jpqlquery.OperatorPrecedenceLevel;
import org.jinq.jpa.jpqlquery.QueryGenerationState;

public class BinaryExpression
extends Expression {
    final Expression left;
    final Expression right;
    final String operator;

    public BinaryExpression(String operator, Expression left, Expression right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public void generateQuery(QueryGenerationState queryState, OperatorPrecedenceLevel operatorPrecedenceScope) {
        OperatorPrecedenceLevel precedence = OperatorPrecedenceLevel.forOperator(this.operator);
        if (!precedence.hasPrecedence(operatorPrecedenceScope)) {
            queryState.appendQuery("(");
        }
        this.left.generateQuery(queryState, precedence);
        queryState.appendQuery(" " + this.operator + " ");
        this.right.generateQuery(queryState, precedence.getLevelBelow());
        if (!precedence.hasPrecedence(operatorPrecedenceScope)) {
            queryState.appendQuery(")");
        }
    }

    @Override
    public void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
        this.left.prepareQueryGeneration(preparePhase, queryState);
        this.right.prepareQueryGeneration(preparePhase, queryState);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        BinaryExpression o = (BinaryExpression)obj;
        return this.operator.equals(o.operator) && this.left.equals(o.left) && this.right.equals(o.right);
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        visitor.visitBinary(this);
    }

    @Override
    public BinaryExpression copy() {
        return new BinaryExpression(this.operator, this.left.copy(), this.right.copy());
    }
}

