/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.jpqlquery;

import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.JPQLFragment;
import org.jinq.jpa.jpqlquery.OperatorPrecedenceLevel;
import org.jinq.jpa.jpqlquery.QueryGenerationState;

public abstract class From
implements JPQLFragment {
    abstract void generateFromString(QueryGenerationState var1, String var2, boolean var3);

    public boolean isPrecededByComma() {
        return true;
    }

    protected void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
        if (preparePhase == Expression.QueryGenerationPreparationPhase.FROM) {
            queryState.generateFromAlias(this);
        }
    }

    public static From forEntity(String entityName) {
        FromEntity from = new FromEntity();
        from.entityName = entityName;
        return from;
    }

    public static From forNavigationalLinks(Expression linksExpr) {
        FromNavigationalLinks from = new FromNavigationalLinks();
        from.links = linksExpr;
        return from;
    }

    public static FromLeftOuterJoinSettableOn forLeftOuterJoinOn(From from) {
        if (from instanceof FromEntity) {
            FromEntityLeftOuterJoinOn toReturn = new FromEntityLeftOuterJoinOn();
            toReturn.entityName = ((FromEntity)from).entityName;
            return toReturn;
        }
        if (from instanceof FromNavigationalLinks) {
            FromNavigationalLinksLeftOuterJoinOn toReturn = new FromNavigationalLinksLeftOuterJoinOn();
            toReturn.links = ((FromNavigationalLinks)from).links;
            return toReturn;
        }
        throw new IllegalArgumentException("Creating a LEFT OUTER JOIN using unexpected parameters");
    }

    public static FromNavigationalLinksLeftOuterJoin forNavigationalLinksLeftOuterJoin(FromNavigationalLinks link) {
        FromNavigationalLinksLeftOuterJoin from = new FromNavigationalLinksLeftOuterJoin();
        from.links = link.links;
        return from;
    }

    public static FromNavigationalLinksLeftOuterJoinFetch forNavigationalLinksLeftOuterJoinFetch(FromNavigationalLinks link) {
        FromNavigationalLinksLeftOuterJoinFetch from = new FromNavigationalLinksLeftOuterJoinFetch();
        from.links = link.links;
        return from;
    }

    public static FromNavigationalLinksJoinFetch forNavigationalLinksJoinFetch(FromNavigationalLinks link) {
        FromNavigationalLinksJoinFetch from = new FromNavigationalLinksJoinFetch();
        from.links = link.links;
        return from;
    }

    public static class FromNavigationalLinksJoinFetch
    extends FromNavigationalLinksGeneric {
        @Override
        void generateFromString(QueryGenerationState queryState, String alias, boolean isFirst) {
            if (!isFirst) {
                queryState.queryString = queryState.queryString + " JOIN FETCH ";
            }
            this.links.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
            queryState.queryString = queryState.queryString + " " + alias;
        }

        @Override
        public boolean isPrecededByComma() {
            return false;
        }
    }

    public static class FromNavigationalLinksLeftOuterJoinFetch
    extends FromNavigationalLinksGeneric {
        @Override
        void generateFromString(QueryGenerationState queryState, String alias, boolean isFirst) {
            if (!isFirst) {
                queryState.queryString = queryState.queryString + " LEFT OUTER JOIN FETCH ";
            }
            this.links.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
            queryState.queryString = queryState.queryString + " " + alias;
        }

        @Override
        public boolean isPrecededByComma() {
            return false;
        }
    }

    public static class FromNavigationalLinksLeftOuterJoinOn
    extends FromNavigationalLinksGeneric
    implements FromLeftOuterJoinSettableOn {
        Expression onExpr;

        @Override
        void generateFromString(QueryGenerationState queryState, String alias, boolean isFirst) {
            if (!isFirst) {
                queryState.queryString = queryState.queryString + " LEFT OUTER JOIN ";
            }
            this.links.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
            queryState.queryString = queryState.queryString + " " + alias;
            if (this.onExpr != null) {
                queryState.queryString = queryState.queryString + " ON ";
                this.onExpr.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
            }
        }

        @Override
        public boolean isPrecededByComma() {
            return false;
        }

        @Override
        public void setOn(Expression onExpr) {
            this.onExpr = onExpr;
        }
    }

    public static class FromEntityLeftOuterJoinOn
    extends FromEntity
    implements FromLeftOuterJoinSettableOn {
        Expression onExpr;

        @Override
        void generateFromString(QueryGenerationState queryState, String alias, boolean isFirst) {
            if (!isFirst) {
                queryState.queryString = queryState.queryString + " LEFT OUTER JOIN ";
            }
            queryState.queryString = queryState.queryString + this.entityName;
            queryState.queryString = queryState.queryString + " " + alias;
            if (this.onExpr != null) {
                queryState.queryString = queryState.queryString + " ON ";
                this.onExpr.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
            }
        }

        @Override
        public boolean isPrecededByComma() {
            return false;
        }

        @Override
        public void setOn(Expression onExpr) {
            this.onExpr = onExpr;
        }
    }

    public static interface FromLeftOuterJoinSettableOn {
        public void setOn(Expression var1);
    }

    public static class FromNavigationalLinksLeftOuterJoin
    extends FromNavigationalLinksGeneric {
        @Override
        void generateFromString(QueryGenerationState queryState, String alias, boolean isFirst) {
            if (!isFirst) {
                queryState.queryString = queryState.queryString + " LEFT OUTER JOIN ";
            }
            this.links.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
            queryState.queryString = queryState.queryString + " " + alias;
        }

        @Override
        public boolean isPrecededByComma() {
            return false;
        }
    }

    public static class FromNavigationalLinks
    extends FromNavigationalLinksGeneric {
        @Override
        void generateFromString(QueryGenerationState queryState, String alias, boolean isFirst) {
            if (!isFirst) {
                queryState.queryString = queryState.queryString + " JOIN ";
            }
            this.links.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
            queryState.queryString = queryState.queryString + " " + alias;
        }

        @Override
        public boolean isPrecededByComma() {
            return false;
        }
    }

    public static abstract class FromNavigationalLinksGeneric
    extends From {
        public Expression links;
    }

    public static class FromEntity
    extends From {
        public String entityName;

        @Override
        void generateFromString(QueryGenerationState queryState, String alias, boolean isFirst) {
            queryState.queryString = queryState.queryString + this.entityName;
            queryState.queryString = queryState.queryString + " " + alias;
        }
    }
}

