/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.jinq.jpa.jpqlquery.AggregateFunctionExpression;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.ConstantExpression;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.jpqlquery.SimpleRowReader;
import org.jinq.jpa.transform.JPQLOneLambdaQueryTransform;
import org.jinq.jpa.transform.JPQLQueryTransformConfiguration;
import org.jinq.jpa.transform.LambdaAnalysis;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SelectFromWhereLambdaArgumentHandler;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.jinq.jpa.transform.SymbExToColumns;

public class AggregateTransform
extends JPQLOneLambdaQueryTransform {
    private AggregateType type;

    public AggregateTransform(JPQLQueryTransformConfiguration config, AggregateType type) {
        super(config);
        this.type = type;
    }

    @Override
    public <U, V> JPQLQuery<U> apply(JPQLQuery<V> query, LambdaAnalysis lambda, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.canAggregate()) {
                SelectOnly select = (SelectOnly)query;
                return this.makeAggregate(lambda, parentArgumentScope, select);
            }
            if (query.canUnsortAggregate() && query instanceof SelectFromWhere) {
                SelectFromWhere select = (SelectFromWhere)query.shallowCopy();
                select.sort.clear();
                return this.makeAggregate(lambda, parentArgumentScope, select);
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    private <V, U> JPQLQuery<U> makeAggregate(LambdaAnalysis lambda, SymbExArgumentHandler parentArgumentScope, SelectOnly<V> select) throws TypedValueVisitorException {
        Expression aggregatedExpr = null;
        if (this.type != AggregateType.COUNT) {
            SelectFromWhereLambdaArgumentHandler argumentHandler;
            SymbExToColumns translator;
            if (select.isDistinct && (aggregatedExpr = this.makeSelectExpression(translator = this.config.newSymbExToColumns(argumentHandler = SelectFromWhereLambdaArgumentHandler.forPassthroughTest(lambda, this.config.metamodel, parentArgumentScope, false)), lambda).getOnlyColumn()) != SelectFromWhereLambdaArgumentHandler.passthroughColsForTesting.getOnlyColumn()) {
                throw new TypedValueVisitorException("Applying an aggregation to a distinct stream, but modifying the stream after the distinct but before the aggregation");
            }
            if (select.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)select;
                argumentHandler = SelectFromWhereLambdaArgumentHandler.fromSelectFromWhere(sfw, lambda, this.config.metamodel, parentArgumentScope, false);
            } else {
                argumentHandler = SelectFromWhereLambdaArgumentHandler.fromSelectOnly(select, lambda, this.config.metamodel, parentArgumentScope, false);
            }
            translator = this.config.newSymbExToColumns(argumentHandler);
            aggregatedExpr = this.makeSelectExpression(translator, lambda).getOnlyColumn();
        } else {
            aggregatedExpr = select.cols.isSingleColumn() ? select.cols.getOnlyColumn() : new ConstantExpression("1");
        }
        JPQLQuery toReturn = select.shallowCopy();
        ((SelectOnly)toReturn).isAggregated = true;
        ((SelectOnly)toReturn).cols = ColumnExpressions.singleColumn(new SimpleRowReader(), new AggregateFunctionExpression(aggregatedExpr, this.type.name(), select.isDistinct));
        return toReturn;
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return AggregateTransform.class.getName() + ":" + this.type.name();
    }

    public static enum AggregateType {
        SUM,
        AVG,
        MAX,
        MIN,
        COUNT;

    }
}

