/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jinq.jpa.jpqlquery.JPQLQuery;

public class JPAQueryComposerCache {
    Map<CacheKey, Optional<JPQLQuery<?>>> cachedQueryTransforms = new HashMap();
    Map<String, Optional<JPQLQuery<?>>> cachedFindAllEntities = new HashMap();

    public synchronized Optional<JPQLQuery<?>> findInCache(JPQLQuery<?> base, String transformationType, String[] lambdaSources) {
        return this.cacheQuery(base, transformationType, lambdaSources, null);
    }

    public synchronized Optional<JPQLQuery<?>> findInCache(JPQLQuery<?> base1, JPQLQuery<?> base2, String transformationType, String[] lambdaSources) {
        return this.cacheQuery(base1, base2, transformationType, lambdaSources, null);
    }

    public synchronized Optional<JPQLQuery<?>> cacheQuery(JPQLQuery<?> base, String transformationType, String[] lambdaSources, Optional<JPQLQuery<?>> resultingQuery) {
        return this.cacheQuery(base, null, transformationType, lambdaSources, resultingQuery);
    }

    public synchronized Optional<JPQLQuery<?>> cacheQuery(JPQLQuery<?> base1, JPQLQuery<?> base2, String transformationType, String[] lambdaSources, Optional<JPQLQuery<?>> resultingQuery) {
        CacheKey key = new CacheKey();
        key.transformationType = transformationType;
        key.baseQuery1 = base1;
        key.baseQuery2 = base2;
        if (lambdaSources != null) {
            key.lambdaSources = Arrays.copyOf(lambdaSources, lambdaSources.length);
        }
        if (this.cachedQueryTransforms.containsKey(key)) {
            return this.cachedQueryTransforms.get(key);
        }
        if (resultingQuery != null) {
            this.cachedQueryTransforms.put(key, resultingQuery);
        }
        return resultingQuery;
    }

    public synchronized Optional<JPQLQuery<?>> findCachedFindAllEntities(String entityName) {
        return this.cacheFindAllEntities(entityName, null);
    }

    public synchronized Optional<JPQLQuery<?>> cacheFindAllEntities(String entityName, Optional<JPQLQuery<?>> queryToCache) {
        if (this.cachedFindAllEntities.containsKey(entityName)) {
            return this.cachedFindAllEntities.get(entityName);
        }
        if (queryToCache != null) {
            this.cachedFindAllEntities.put(entityName, queryToCache);
        }
        return queryToCache;
    }

    private static class CacheKey {
        String transformationType;
        JPQLQuery<?> baseQuery1;
        JPQLQuery<?> baseQuery2;
        String[] lambdaSources;

        private CacheKey() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.baseQuery1 == null ? 0 : this.baseQuery1.hashCode());
            result = 31 * result + (this.baseQuery2 == null ? 0 : this.baseQuery2.hashCode());
            result = 31 * result + Arrays.hashCode(this.lambdaSources);
            result = 31 * result + (this.transformationType == null ? 0 : this.transformationType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.baseQuery1 == null ? other.baseQuery1 != null : !this.baseQuery1.equals(other.baseQuery1)) {
                return false;
            }
            if (this.baseQuery2 == null ? other.baseQuery2 != null : !this.baseQuery2.equals(other.baseQuery2)) {
                return false;
            }
            if (!Arrays.equals(this.lambdaSources, other.lambdaSources)) {
                return false;
            }
            return !(this.transformationType == null ? other.transformationType != null : !this.transformationType.equals(other.transformationType));
        }
    }
}

