/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.RowReader;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.jpqlquery.TupleRowReader;
import org.jinq.jpa.transform.AggregateStreamLambdaArgumentHandler;
import org.jinq.jpa.transform.JPQLMultiLambdaQueryTransform;
import org.jinq.jpa.transform.JPQLQueryTransformConfiguration;
import org.jinq.jpa.transform.LambdaAnalysis;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.jinq.jpa.transform.SymbExToColumns;

public class MultiAggregateTransform
extends JPQLMultiLambdaQueryTransform {
    public MultiAggregateTransform(JPQLQueryTransformConfiguration config) {
        super(config);
    }

    @Override
    public <U, V> JPQLQuery<U> apply(JPQLQuery<V> query, LambdaAnalysis[] lambdas, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                SelectOnly streamTee = new SelectOnly();
                streamTee.cols = sfw.cols;
                ColumnExpressions[] aggregatedQueryEntries = new ColumnExpressions[lambdas.length];
                for (int n = 0; n < lambdas.length; ++n) {
                    ColumnExpressions returnQuery;
                    LambdaAnalysis lambda = lambdas[n];
                    SymbExToColumns translator = this.config.newSymbExToColumns(new AggregateStreamLambdaArgumentHandler(streamTee, lambdas[n], this.config.metamodel, parentArgumentScope, false));
                    aggregatedQueryEntries[n] = returnQuery = this.makeSelectExpression(translator, lambda);
                }
                SelectOnly toReturn = sfw.shallowCopy();
                ((SelectFromWhere)toReturn).isAggregated = true;
                RowReader[] readers = new RowReader[aggregatedQueryEntries.length];
                for (int n = 0; n < readers.length; ++n) {
                    readers[n] = aggregatedQueryEntries[n].reader;
                }
                ColumnExpressions<U> cols = new ColumnExpressions<U>(this.createTupleReader(readers));
                for (int n = 0; n < readers.length; ++n) {
                    cols.columns.addAll(aggregatedQueryEntries[n].columns);
                }
                ((SelectFromWhere)toReturn).cols = cols;
                return toReturn;
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    protected <U> RowReader<U> createTupleReader(RowReader<?>[] readers) {
        return TupleRowReader.createReaderForTuple(readers);
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return MultiAggregateTransform.class.getName();
    }
}

