/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa;

import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.Metamodel;
import org.jinq.jpa.JPAJinqStream;
import org.jinq.jpa.JPAQueryComposer;
import org.jinq.jpa.JinqJPAHints;
import org.jinq.jpa.QueryJPAJinqStream;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.transform.JPAQueryComposerCache;
import org.jinq.jpa.transform.JPQLQueryTransformConfigurationFactory;
import org.jinq.jpa.transform.LambdaAnalysisFactory;
import org.jinq.jpa.transform.MetamodelUtil;
import org.jinq.jpa.transform.MetamodelUtilAttribute;
import org.jinq.jpa.transform.MetamodelUtilFromMetamodel;
import org.jinq.orm.stream.InQueryStreamSource;
import org.jinq.orm.stream.JinqStream;
import org.jinq.rebased.org.objectweb.asm.Type;

public class JinqJPAStreamProvider {
    MetamodelUtil metamodel;
    JPAQueryComposerCache cachedQueries = new JPAQueryComposerCache();
    LambdaAnalysisFactory lambdaAnalyzer = new LambdaAnalysisFactory();
    JPQLQueryTransformConfigurationFactory jpqlQueryTransformConfigurationFactory = new JPQLQueryTransformConfigurationFactory();
    JinqJPAHints hints = new JinqJPAHints();

    public JinqJPAStreamProvider(EntityManagerFactory factory) {
        this(factory.getMetamodel());
    }

    public JinqJPAStreamProvider(Metamodel metamodel) {
        this.metamodel = new MetamodelUtilFromMetamodel(metamodel);
    }

    public <U> JPAJinqStream<U> streamAll(final EntityManager em, Class<U> entity) {
        JPQLQuery<Object> query;
        Optional<JPQLQuery<Object>> cachedQuery;
        String entityName = this.metamodel.entityNameFromClass(entity);
        Optional<JPQLQuery<?>> optional = cachedQuery = this.hints.useCaching ? this.cachedQueries.findCachedFindAllEntities(entityName) : null;
        if (cachedQuery == null) {
            query = JPQLQuery.findAllEntities(entityName);
            cachedQuery = Optional.of(query);
            if (this.hints.useCaching) {
                cachedQuery = this.cachedQueries.cacheFindAllEntities(entityName, cachedQuery);
            }
        }
        query = cachedQuery.get();
        return new QueryJPAJinqStream(JPAQueryComposer.findAllEntities(this.metamodel, this.cachedQueries, this.lambdaAnalyzer, this.jpqlQueryTransformConfigurationFactory, em, this.hints, query), new InQueryStreamSource(){

            public <S> JinqStream<S> stream(Class<S> entityClass) {
                return JinqJPAStreamProvider.this.streamAll(em, entityClass);
            }
        });
    }

    public boolean setHint(String name, Object val) {
        return this.hints.setHint(name, val);
    }

    public void registerAssociationAttribute(Method m, String fieldName, boolean isPlural) {
        MetamodelUtilAttribute attrib = new MetamodelUtilAttribute(fieldName, true);
        this.metamodel.insertAssociationAttribute(new MethodSignature(Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor((Method)m)), attrib, isPlural);
    }

    public void registerAssociationAttribute(Method m, Class<?> methodClass, String fieldName, boolean isPlural) {
        MetamodelUtilAttribute attrib = new MetamodelUtilAttribute(fieldName, true);
        this.metamodel.insertAssociationAttribute(new MethodSignature(Type.getInternalName(methodClass), m.getName(), Type.getMethodDescriptor((Method)m)), attrib, isPlural);
    }

    public void registerAttributeConverterType(Class<?> convertedType) {
        this.metamodel.insertConvertedType(convertedType.getName());
    }

    public void registerCustomTupleStaticBuilder(Method m, Method ... tupleIndexReaders) {
        Class<?> returnType = m.getReturnType();
        if (returnType.isPrimitive()) {
            throw new IllegalArgumentException("Builder method for custom tuple must return the custom tuple object");
        }
        this.metamodel.insertCustomTupleBuilder(returnType.getName(), m, tupleIndexReaders);
    }

    public void registerCustomTupleConstructor(Constructor<?> m, Method ... tupleIndexReaders) {
        Class<?> tupleType = m.getDeclaringClass();
        this.metamodel.insertCustomTupleConstructor(tupleType.getName(), m, tupleIndexReaders);
    }

    public void registerCustomSqlFunction(Method m, String sqlFunctionName) {
        Class<?> returnType = m.getReturnType();
        this.metamodel.insertCustomSqlFunction(returnType.getName(), m, sqlFunctionName);
    }
}

