/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.jinq.jpa.transform.CustomTupleInfo;
import org.jinq.jpa.transform.MetamodelUtilAttribute;
import org.jinq.jpa.transform.MethodChecker;
import org.jinq.rebased.org.objectweb.asm.Type;

public abstract class MetamodelUtil {
    private final Set<Class<?>> safeMethodAnnotations;
    protected final Map<MethodSignature, MetamodelUtilAttribute> fieldMethods;
    protected final Map<MethodSignature, MetamodelUtilAttribute> nLinkMethods;
    protected final Set<MethodSignature> safeMethods;
    protected final Set<MethodSignature> safeStaticMethods;
    protected final Map<String, List<Enum<?>>> enums;
    protected final Set<String> convertedTypes;
    protected final Set<String> knownEmbeddedtypes = new HashSet<String>();
    protected final Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> comparisonMethods;
    protected final Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> comparisonMethodsWithObjectEquals;
    protected final Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> comparisonStaticMethods;
    protected final Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> comparisonStaticMethodsWithObjectEquals;
    protected final Map<MethodSignature, CustomTupleInfo> customTupleStaticBuilderMethods;
    protected final Map<MethodSignature, CustomTupleInfo> customTupleConstructorMethods;
    protected final Map<MethodSignature, Integer> customTupleAccessorMethods;
    protected final Map<MethodSignature, String> customSqlFunctionMethods;
    private Set<String> scannedClasses = new HashSet<String>();
    public static final MethodSignature inQueryStream = new MethodSignature("org/jinq/orm/stream/InQueryStreamSource", "stream", "(Ljava/lang/Class;)Lorg/jinq/orm/stream/JinqStream;");
    public static final Map<MethodSignature, Integer> TUPLE_ACCESSORS = new HashMap<MethodSignature, Integer>();

    public MetamodelUtil() {
        this.enums = new HashMap();
        this.convertedTypes = new HashSet<String>();
        this.comparisonMethods = new HashMap<MethodSignature, TypedValue.ComparisonValue.ComparisonOp>();
        this.safeMethodAnnotations = new HashSet();
        this.safeMethodAnnotations.addAll(TransformationClassAnalyzer.SafeMethodAnnotations);
        this.safeMethods = new HashSet<MethodSignature>();
        this.safeMethods.addAll(TransformationClassAnalyzer.KnownSafeMethods);
        this.safeMethods.add(TransformationClassAnalyzer.integerIntValue);
        this.safeMethods.add(TransformationClassAnalyzer.longLongValue);
        this.safeMethods.add(TransformationClassAnalyzer.floatFloatValue);
        this.safeMethods.add(TransformationClassAnalyzer.doubleDoubleValue);
        this.safeMethods.add(TransformationClassAnalyzer.booleanBooleanValue);
        this.safeMethods.add(inQueryStream);
        this.safeStaticMethods = new HashSet<MethodSignature>();
        this.safeStaticMethods.addAll(TransformationClassAnalyzer.KnownSafeStaticMethods);
        this.safeStaticMethods.add(TransformationClassAnalyzer.integerValueOf);
        this.safeStaticMethods.add(TransformationClassAnalyzer.longValueOf);
        this.safeStaticMethods.add(TransformationClassAnalyzer.floatValueOf);
        this.safeStaticMethods.add(TransformationClassAnalyzer.doubleValueOf);
        this.safeStaticMethods.add(TransformationClassAnalyzer.booleanValueOf);
        this.fieldMethods = new HashMap<MethodSignature, MetamodelUtilAttribute>();
        this.nLinkMethods = new HashMap<MethodSignature, MetamodelUtilAttribute>();
        this.comparisonMethodsWithObjectEquals = new HashMap<MethodSignature, TypedValue.ComparisonValue.ComparisonOp>();
        this.comparisonMethodsWithObjectEquals.put(MethodChecker.objectEquals, TypedValue.ComparisonValue.ComparisonOp.eq);
        this.comparisonStaticMethods = new HashMap<MethodSignature, TypedValue.ComparisonValue.ComparisonOp>();
        this.comparisonStaticMethodsWithObjectEquals = new HashMap<MethodSignature, TypedValue.ComparisonValue.ComparisonOp>();
        this.comparisonStaticMethodsWithObjectEquals.put(MethodChecker.guavaObjectsEqual, TypedValue.ComparisonValue.ComparisonOp.eq);
        this.comparisonStaticMethodsWithObjectEquals.put(MethodChecker.objectsEquals, TypedValue.ComparisonValue.ComparisonOp.eq);
        this.customTupleStaticBuilderMethods = new HashMap<MethodSignature, CustomTupleInfo>();
        this.customTupleConstructorMethods = new HashMap<MethodSignature, CustomTupleInfo>();
        this.customTupleAccessorMethods = new HashMap<MethodSignature, Integer>();
        this.customSqlFunctionMethods = new HashMap<MethodSignature, String>();
    }

    public void insertConvertedType(String className) {
        this.convertedTypes.add(className);
    }

    public void insertCustomSqlFunction(String className, Method m, String sqlFunctionName) {
        if (!Modifier.isStatic(m.getModifiers())) {
            throw new IllegalArgumentException("Custom SQL functions must be a static method");
        }
        MethodSignature sig = MethodSignature.fromMethod((Method)m);
        this.safeStaticMethods.add(sig);
        this.customSqlFunctionMethods.put(sig, sqlFunctionName);
    }

    public void insertCustomTupleBuilder(String className, Method builderMethod, Method ... tupleIndexReaders) {
        if (!Modifier.isStatic(builderMethod.getModifiers())) {
            throw new IllegalArgumentException("Builder method for custom tuple must be a static method");
        }
        MethodSignature builderSig = MethodSignature.fromMethod((Method)builderMethod);
        this.safeStaticMethods.add(builderSig);
        this.insertCustomTupleIndexGetters(tupleIndexReaders);
        CustomTupleInfo tupleInfo = new CustomTupleInfo();
        tupleInfo.className = className;
        tupleInfo.staticBuilder = builderMethod;
        tupleInfo.staticBuilderSig = builderSig;
        this.customTupleStaticBuilderMethods.put(builderSig, tupleInfo);
    }

    public void insertCustomTupleConstructor(String className, Constructor<?> constructor, Method ... tupleIndexReaders) {
        MethodSignature constructorSig = MethodSignature.fromConstructor(constructor);
        this.safeMethods.add(constructorSig);
        this.insertCustomTupleIndexGetters(tupleIndexReaders);
        CustomTupleInfo tupleInfo = new CustomTupleInfo();
        tupleInfo.className = className;
        tupleInfo.constructor = constructor;
        tupleInfo.constructorSig = constructorSig;
        this.customTupleConstructorMethods.put(constructorSig, tupleInfo);
    }

    private void insertCustomTupleIndexGetters(Method ... tupleIndexReaders) {
        if (tupleIndexReaders != null) {
            int idx = 1;
            for (Method tupleIndex : tupleIndexReaders) {
                if (Modifier.isStatic(tupleIndex.getModifiers())) {
                    throw new IllegalArgumentException("Method for reading a value from a custom tuple must be a virtual method declared on the custom tuple class");
                }
                if (tupleIndex.getParameterCount() != 0) {
                    throw new IllegalArgumentException("Method for reading a value from a custom tuple must not take any arguments");
                }
                MethodSignature sig = new MethodSignature(Type.getInternalName(tupleIndex.getDeclaringClass()), tupleIndex.getName(), Type.getMethodDescriptor((Method)tupleIndex));
                this.customTupleAccessorMethods.put(sig, idx);
                this.safeMethods.add(sig);
                ++idx;
            }
        }
    }

    public void insertAssociationAttribute(MethodSignature sig, MetamodelUtilAttribute attribute, boolean isPlural) {
        if (isPlural) {
            this.nLinkMethods.put(sig, attribute);
        } else {
            this.fieldMethods.put(sig, attribute);
        }
        this.safeMethods.add(sig);
    }

    private void insertFieldMethod(String className, String methodName, String altMethodName, String returnType, MetamodelUtilAttribute fieldAttribute) {
        MethodSignature methodSig = new MethodSignature(className, methodName, returnType);
        this.fieldMethods.put(methodSig, fieldAttribute);
        if (altMethodName != null) {
            MethodSignature altMethodSig = new MethodSignature(className, altMethodName, returnType);
            this.fieldMethods.put(altMethodSig, fieldAttribute);
        }
    }

    private void insertNLinkMethod(String className, String methodName, String returnType, MetamodelUtilAttribute pluralAttribute) {
        MethodSignature methodSig = new MethodSignature(className, methodName, returnType);
        this.nLinkMethods.put(methodSig, pluralAttribute);
    }

    protected void findMetamodelEntityGetters(ManagedType<?> entity) {
        if (entity.getJavaType() == null) {
            return;
        }
        if (this.scannedClasses.contains(entity.getJavaType().getName())) {
            return;
        }
        this.scannedClasses.add(entity.getJavaType().getName());
        this.findMetamodelEntityGetters(entity, new ArrayList<String>());
    }

    private void findMetamodelEntityGetters(ManagedType<?> entity, Collection<String> subclassNames) {
        IdentifiableType idEntity;
        for (SingularAttribute singularAttrib : entity.getDeclaredSingularAttributes()) {
            Class fieldJavaType = singularAttrib.getJavaType();
            Member javaMember = singularAttrib.getJavaMember();
            String name = javaMember.getName();
            String altName = null;
            if (name.startsWith("_persistence_get_") && name.endsWith("_vh") && javaMember instanceof Method && ((Method)javaMember).getReturnType().getName().equals("org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface")) {
                name = singularAttrib.getName();
                if (fieldJavaType == Boolean.TYPE || "java.lang.Boolean".equals(fieldJavaType.getName())) {
                    altName = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
                }
                name = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
            }
            if (javaMember instanceof Field) {
                if (fieldJavaType == Boolean.TYPE || "java.lang.Boolean".equals(fieldJavaType.getName())) {
                    altName = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
                }
                name = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
            }
            if (fieldJavaType.isEnum()) {
                this.registerEnum(fieldJavaType);
            }
            String returnType = Type.getMethodDescriptor((Type)Type.getType((Class)fieldJavaType), (Type[])new Type[0]);
            String alternateReturnType = null;
            if (javaMember instanceof Field) {
                alternateReturnType = Type.getMethodDescriptor((Type)Type.getType(((Field)javaMember).getType()), (Type[])new Type[0]);
                if (returnType.equals(alternateReturnType)) {
                    alternateReturnType = null;
                }
            } else if (javaMember instanceof Method && returnType.equals(alternateReturnType = Type.getMethodDescriptor((Type)Type.getType(((Method)javaMember).getReturnType()), (Type[])new Type[0]))) {
                alternateReturnType = null;
            }
            String declaredClassName = Type.getInternalName(javaMember.getDeclaringClass());
            String entityClassName = Type.getInternalName((Class)entity.getJavaType());
            if (entityClassName.equals(declaredClassName)) {
                entityClassName = null;
            }
            MetamodelUtilAttribute fieldAttribute = new MetamodelUtilAttribute((Attribute<?, ?>)singularAttrib);
            this.insertFieldMethod(declaredClassName, name, altName, returnType, fieldAttribute);
            if (entityClassName != null) {
                this.insertFieldMethod(entityClassName, name, altName, returnType, fieldAttribute);
            }
            if (alternateReturnType != null) {
                this.insertFieldMethod(declaredClassName, name, altName, alternateReturnType, fieldAttribute);
            }
            if (alternateReturnType != null && entityClassName != null) {
                this.insertFieldMethod(entityClassName, name, altName, alternateReturnType, fieldAttribute);
            }
            for (String className : subclassNames) {
                this.insertFieldMethod(className, name, altName, returnType, fieldAttribute);
                if (alternateReturnType == null) continue;
                this.insertFieldMethod(className, name, altName, alternateReturnType, fieldAttribute);
            }
            if (!(singularAttrib.getType() instanceof EmbeddableType)) continue;
            EmbeddableType embed = (EmbeddableType)singularAttrib.getType();
            this.knownEmbeddedtypes.add(embed.getJavaType().getName());
            this.findMetamodelEntityGetters((ManagedType<?>)embed);
        }
        for (PluralAttribute pluralAttrib : entity.getDeclaredPluralAttributes()) {
            Member javaMember = pluralAttrib.getJavaMember();
            String name = javaMember.getName();
            if (javaMember instanceof Field) {
                name = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
            }
            String returnType = Type.getMethodDescriptor((Type)Type.getType((Class)pluralAttrib.getJavaType()), (Type[])new Type[0]);
            String declaredClassName = Type.getInternalName(javaMember.getDeclaringClass());
            String entityClassName = Type.getInternalName((Class)entity.getJavaType());
            if (entityClassName.equals(declaredClassName)) {
                entityClassName = null;
            }
            MetamodelUtilAttribute nLinkAttrib = new MetamodelUtilAttribute((Attribute<?, ?>)pluralAttrib);
            this.insertNLinkMethod(declaredClassName, name, returnType, nLinkAttrib);
            if (entityClassName != null) {
                this.insertNLinkMethod(entityClassName, name, returnType, nLinkAttrib);
            }
            for (String className : subclassNames) {
                this.insertNLinkMethod(className, name, returnType, nLinkAttrib);
            }
        }
        if (entity instanceof IdentifiableType && (idEntity = (IdentifiableType)entity).getSupertype() != null) {
            IdentifiableType jpaObject = idEntity.getSupertype();
            String className = Type.getInternalName((Class)entity.getJavaType());
            ArrayList<String> newSubclasses = new ArrayList<String>(subclassNames);
            newSubclasses.add(className);
            this.findMetamodelEntityGetters((ManagedType<?>)jpaObject, (Collection<String>)newSubclasses);
        }
    }

    protected void registerEnum(Class<?> fieldJavaType) {
        String enumTypeName = Type.getInternalName(fieldJavaType);
        this.enums.put(enumTypeName, Arrays.asList(fieldJavaType.getEnumConstants()));
        MethodSignature eqMethod = new MethodSignature(enumTypeName, "equals", "(Ljava/lang/Object;)Z");
        this.comparisonMethods.put(eqMethod, TypedValue.ComparisonValue.ComparisonOp.eq);
        this.comparisonMethodsWithObjectEquals.put(eqMethod, TypedValue.ComparisonValue.ComparisonOp.eq);
        this.safeMethods.add(eqMethod);
    }

    public <U> boolean isKnownManagedType(String entityClassName) {
        return this.entityNameFromClassName(entityClassName) != null || this.knownEmbeddedtypes.contains(entityClassName);
    }

    public abstract <U> String entityNameFromClass(Class<U> var1);

    public abstract String entityNameFromClassName(String var1);

    public boolean isSingularAttributeFieldMethod(MethodSignature sig) {
        return this.fieldMethods.containsKey(sig);
    }

    public String fieldMethodToFieldName(MethodSignature sig) {
        return this.fieldMethods.get(sig).getName();
    }

    public boolean isFieldMethodAssociationType(MethodSignature sig) {
        return this.fieldMethods.get(sig).isAssociation();
    }

    public boolean isPluralAttributeLinkMethod(MethodSignature sig) {
        return this.nLinkMethods.containsKey(sig);
    }

    public String nLinkMethodToLinkName(MethodSignature sig) {
        return this.nLinkMethods.get(sig).getName();
    }

    public boolean isKnownEnumType(String className) {
        return this.enums.containsKey(className);
    }

    public boolean isKnownConvertedType(String className) {
        return this.convertedTypes.contains(className);
    }

    public String getFullEnumConstantName(String className, String name) {
        List<Enum<?>> enumConstants = this.enums.get(className);
        if (enumConstants == null) {
            return null;
        }
        for (Enum<?> e : enumConstants) {
            if (!e.name().equals(name)) continue;
            return className.replace("/", ".") + "." + name;
        }
        return null;
    }

    public Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> getComparisonMethods(boolean withObjectEquals) {
        if (withObjectEquals) {
            return this.comparisonMethodsWithObjectEquals;
        }
        return this.comparisonMethods;
    }

    public Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> getComparisonStaticMethods(boolean withObjectEquals) {
        if (withObjectEquals) {
            return this.comparisonStaticMethodsWithObjectEquals;
        }
        return this.comparisonStaticMethods;
    }

    public Set<Class<?>> getSafeMethodAnnotations() {
        return this.safeMethodAnnotations;
    }

    public Set<MethodSignature> getSafeMethods() {
        return this.safeMethods;
    }

    public Set<MethodSignature> getSafeStaticMethods() {
        return this.safeStaticMethods;
    }

    public MethodChecker getMethodChecker(boolean isObjectEqualsSafe, boolean isAllEqualsSafe, boolean isCollectionContainsSafe) {
        return new MethodChecker(this.getSafeMethodAnnotations(), this.getSafeMethods(), this.getSafeStaticMethods(), isObjectEqualsSafe, isAllEqualsSafe, isCollectionContainsSafe);
    }

    static {
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.pairGetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.pairGetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple3GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple3GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple3GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetFive, 5);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetFive, 5);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetSix, 6);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetFive, 5);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetSix, 6);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetSeven, 7);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetFive, 5);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetSix, 6);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetSeven, 7);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetEight, 8);
    }
}

