/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jinq.jpa.JPAJinqStream;
import org.jinq.jpa.JinqJPAHints;
import org.jinq.jpa.QueryJPAJinqStream;
import org.jinq.jpa.jpqlquery.GeneratedQueryParameter;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.RowReader;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.transform.AggregateTransform;
import org.jinq.jpa.transform.CountTransform;
import org.jinq.jpa.transform.CrossJoinTransform;
import org.jinq.jpa.transform.DistinctTransform;
import org.jinq.jpa.transform.GroupingTransform;
import org.jinq.jpa.transform.JPAQueryComposerCache;
import org.jinq.jpa.transform.JPQLMultiLambdaQueryTransform;
import org.jinq.jpa.transform.JPQLNoLambdaQueryTransform;
import org.jinq.jpa.transform.JPQLOneLambdaQueryTransform;
import org.jinq.jpa.transform.JPQLQueryTransformConfiguration;
import org.jinq.jpa.transform.JPQLQueryTransformConfigurationFactory;
import org.jinq.jpa.transform.JPQLTwoQueryMergeQueryTransform;
import org.jinq.jpa.transform.JoinFetchTransform;
import org.jinq.jpa.transform.JoinTransform;
import org.jinq.jpa.transform.LambdaAnalysis;
import org.jinq.jpa.transform.LambdaAnalysisFactory;
import org.jinq.jpa.transform.LambdaInfo;
import org.jinq.jpa.transform.LimitSkipTransform;
import org.jinq.jpa.transform.MetamodelUtil;
import org.jinq.jpa.transform.MultiAggregateTransform;
import org.jinq.jpa.transform.OuterJoinOnTransform;
import org.jinq.jpa.transform.OuterJoinTransform;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SelectTransform;
import org.jinq.jpa.transform.SetOperationEmulationTransform;
import org.jinq.jpa.transform.SortingTransform;
import org.jinq.jpa.transform.WhereTransform;
import org.jinq.orm.internal.QueryComposer;
import org.jinq.orm.stream.JinqStream;
import org.jinq.orm.stream.NextOnlyIterator;
import org.jinq.tuples.Pair;
import org.jinq.tuples.Tuple;

class JPAQueryComposer<T>
implements QueryComposer<T> {
    final MetamodelUtil metamodel;
    final JPAQueryComposerCache cachedQueries;
    final JPQLQueryTransformConfigurationFactory jpqlQueryTransformConfigurationFactory;
    final EntityManager em;
    final JPQLQuery<T> query;
    final JinqJPAHints hints;
    final LambdaAnalysisFactory lambdaAnalyzer;
    List<LambdaInfo> lambdas = new ArrayList<LambdaInfo>();
    private JPQLQueryTransformConfiguration transformationConfig = null;

    private JPAQueryComposer(JPAQueryComposer<?> base, JPQLQuery<T> query, List<LambdaInfo> chainedLambdas, LambdaInfo ... additionalLambdas) {
        this(base.metamodel, base.cachedQueries, base.lambdaAnalyzer, base.jpqlQueryTransformConfigurationFactory, base.em, base.hints, query, chainedLambdas, additionalLambdas);
    }

    private JPAQueryComposer(MetamodelUtil metamodel, JPAQueryComposerCache cachedQueries, LambdaAnalysisFactory lambdaAnalyzer, JPQLQueryTransformConfigurationFactory jpqlQueryTransformConfigurationFactory, EntityManager em, JinqJPAHints hints, JPQLQuery<T> query, List<LambdaInfo> chainedLambdas, LambdaInfo ... additionalLambdas) {
        this.metamodel = metamodel;
        this.cachedQueries = cachedQueries;
        this.lambdaAnalyzer = lambdaAnalyzer;
        this.jpqlQueryTransformConfigurationFactory = jpqlQueryTransformConfigurationFactory;
        this.em = em;
        this.query = query;
        this.lambdas.addAll(chainedLambdas);
        for (LambdaInfo newLambda : additionalLambdas) {
            this.lambdas.add(newLambda);
        }
        this.hints = new JinqJPAHints(hints);
    }

    public static <U> JPAQueryComposer<U> findAllEntities(MetamodelUtil metamodel, JPAQueryComposerCache cachedQueries, LambdaAnalysisFactory lambdaAnalyzer, JPQLQueryTransformConfigurationFactory jpqlQueryTransformConfigurationFactory, EntityManager em, JinqJPAHints hints, JPQLQuery<U> findAllQuery) {
        return new JPAQueryComposer<U>(metamodel, cachedQueries, lambdaAnalyzer, jpqlQueryTransformConfigurationFactory, em, hints, findAllQuery, new ArrayList<LambdaInfo>(), new LambdaInfo[0]);
    }

    public String getDebugQueryString() {
        return this.query.getQueryString();
    }

    private void translationFail() {
        if (this.hints.dieOnError) {
            throw new IllegalArgumentException("Could not translate code to a query");
        }
    }

    private void translationFail(Throwable e) {
        if (this.hints.dieOnError) {
            throw new IllegalArgumentException("Could not translate code to a query", e);
        }
    }

    private void fillQueryParameters(Query q, List<GeneratedQueryParameter> parameters) {
        for (GeneratedQueryParameter param : parameters) {
            if (param.fieldName == null) {
                q.setParameter(param.paramName, this.lambdas.get(param.lambdaIndex).getCapturedArg(param.argIndex));
                continue;
            }
            q.setParameter(param.paramName, this.lambdas.get(param.lambdaIndex).getField(param.fieldName));
        }
    }

    private void logQuery(String queryString, Query q) {
        if (this.hints.queryLogger == null) {
            return;
        }
        HashMap<Integer, Object> positionParams = new HashMap<Integer, Object>();
        HashMap<String, Object> namedParams = new HashMap<String, Object>();
        for (Parameter param : q.getParameters()) {
            if (param.getName() != null) {
                namedParams.put(param.getName(), q.getParameterValue(param));
            }
            if (param.getPosition() == null) continue;
            positionParams.put(param.getPosition(), q.getParameterValue(param));
        }
        this.hints.queryLogger.logQuery(queryString, positionParams, namedParams);
    }

    public T executeAndGetSingleResult() {
        String queryString = this.query.getQueryString();
        Query q = this.em.createQuery(queryString);
        this.fillQueryParameters(q, this.query.getQueryParameters());
        RowReader reader = this.query.getRowReader();
        this.logQuery(queryString, q);
        if (this.hints.jakartaPersistenceFetchgraph != null) {
            q.setHint("jakarta.persistence.fetchgraph", this.hints.jakartaPersistenceFetchgraph);
        }
        return (T)reader.readResult(q.getSingleResult());
    }

    public Iterator<T> executeAndReturnResultIterator(Consumer<Throwable> exceptionReporter) {
        final String queryString = this.query.getQueryString();
        final Query q = this.em.createQuery(queryString);
        this.fillQueryParameters(q, this.query.getQueryParameters());
        final RowReader reader = this.query.getRowReader();
        long skip = 0L;
        long limit = Long.MAX_VALUE;
        if (this.query instanceof SelectFromWhere) {
            SelectFromWhere sfw = (SelectFromWhere)this.query;
            if (sfw.limit >= 0L) {
                limit = sfw.limit;
            }
            if (sfw.skip >= 0L) {
                skip = sfw.skip;
            }
        }
        final long initialOffset = skip;
        final long maxTotalResults = limit;
        if (this.hints.jakartaPersistenceFetchgraph != null) {
            q.setHint("jakarta.persistence.fetchgraph", this.hints.jakartaPersistenceFetchgraph);
        }
        return new NextOnlyIterator<T>(){
            boolean hasNextPage = false;
            Iterator<Object> resultIterator;
            int offset = (int)initialOffset;
            long totalRead = 0L;

            protected void generateNext() {
                if (this.resultIterator == null) {
                    if (this.offset > 0) {
                        q.setFirstResult(this.offset);
                    }
                    long pageSize = Long.MAX_VALUE;
                    if (JPAQueryComposer.this.hints.automaticResultsPagingSize > 0) {
                        pageSize = JPAQueryComposer.this.hints.automaticResultsPagingSize + 1;
                    }
                    if (maxTotalResults != Long.MAX_VALUE) {
                        pageSize = Math.min(pageSize, maxTotalResults - this.totalRead);
                    }
                    if (pageSize != Long.MAX_VALUE) {
                        q.setMaxResults((int)pageSize);
                    }
                    if (JPAQueryComposer.this.hints.automaticResultsPagingSize > 0) {
                        JPAQueryComposer.this.logQuery(queryString, q);
                        List results = q.getResultList();
                        if (results.size() > JPAQueryComposer.this.hints.automaticResultsPagingSize) {
                            this.hasNextPage = true;
                            this.offset += JPAQueryComposer.this.hints.automaticResultsPagingSize;
                            results.remove(JPAQueryComposer.this.hints.automaticResultsPagingSize);
                        }
                        this.totalRead += (long)results.size();
                        this.resultIterator = results.iterator();
                    } else {
                        JPAQueryComposer.this.logQuery(queryString, q);
                        List results = q.getResultList();
                        this.resultIterator = results.iterator();
                    }
                }
                if (this.resultIterator.hasNext()) {
                    this.nextElement(reader.readResult(this.resultIterator.next()));
                } else if (this.hasNextPage) {
                    this.hasNextPage = false;
                    this.resultIterator = null;
                    this.generateNext();
                } else {
                    this.noMoreElements();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private <U> JPAQueryComposer<U> applyTransformWithLambda(JPQLNoLambdaQueryTransform transform) {
        v0 = cachedQuery = this.hints.useCaching != false ? this.cachedQueries.findInCache(this.query, transform.getTransformationTypeCachingTag(), null) : null;
        if (cachedQuery == null) {
            cachedQuery = Optional.empty();
            newQuery = null;
            try {
                newQuery = transform.apply(this.query, null);
            }
            catch (QueryTransformException e) {
                try {
                    this.translationFail(e);
                }
                catch (Throwable var5_5) {
                    cachedQuery = Optional.ofNullable(newQuery);
                    if (this.hints.useCaching) {
                        cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), null, cachedQuery);
                    }
                    throw var5_5;
                }
                cachedQuery = Optional.ofNullable(newQuery);
                if (this.hints.useCaching) {
                    cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), null, cachedQuery);
                } else {
                    ** GOTO lbl23
                }
            }
            cachedQuery = Optional.ofNullable(newQuery);
            if (this.hints.useCaching) {
                cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), null, cachedQuery);
            }
        }
        if (!cachedQuery.isPresent()) {
            this.translationFail();
            return null;
        }
        return new JPAQueryComposer<T>(this, (JPQLQuery)cachedQuery.get(), this.lambdas, new LambdaInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <U> JPAQueryComposer<U> applyTransformWithLambda(JPQLOneLambdaQueryTransform transform, Object lambda) {
        lambdaInfo = this.lambdaAnalyzer.extractSurfaceInfo(lambda, this.lambdas.size(), this.hints.dieOnError);
        if (lambdaInfo == null) {
            this.translationFail();
            return null;
        }
        v0 = cachedQuery = this.hints.useCaching != false ? this.cachedQueries.findInCache(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo.getLambdaSourceString()}) : null;
        if (cachedQuery == null) {
            block12: {
                cachedQuery = Optional.empty();
                newQuery = null;
                lambdaAnalysis = lambdaInfo.fullyAnalyze(this.metamodel, this.hints.lambdaClassLoader, this.hints.isObjectEqualsSafe, this.hints.isAllEqualsSafe, this.hints.isCollectionContainsSafe, this.hints.dieOnError);
                if (lambdaAnalysis != null) break block12;
                this.translationFail();
                var7_8 = null;
                cachedQuery = Optional.ofNullable(newQuery);
                if (this.hints.useCaching) {
                    cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo.getLambdaSourceString()}, cachedQuery);
                }
                return var7_8;
            }
            try {
                this.getConfig().checkLambdaSideEffects(lambdaAnalysis);
                newQuery = transform.apply(this.query, lambdaAnalysis, null);
            }
            catch (QueryTransformException e) {
                try {
                    this.translationFail(e);
                }
                catch (Throwable var8_9) {
                    cachedQuery = Optional.ofNullable(newQuery);
                    if (this.hints.useCaching) {
                        cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo.getLambdaSourceString()}, cachedQuery);
                    }
                    throw var8_9;
                }
                cachedQuery = Optional.ofNullable(newQuery);
                if (this.hints.useCaching) {
                    cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo.getLambdaSourceString()}, cachedQuery);
                } else {
                    ** GOTO lbl38
                }
            }
            cachedQuery = Optional.ofNullable(newQuery);
            if (this.hints.useCaching) {
                cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo.getLambdaSourceString()}, cachedQuery);
            }
        }
        if (!cachedQuery.isPresent()) {
            this.translationFail();
            return null;
        }
        return new JPAQueryComposer<T>(this, (JPQLQuery)cachedQuery.get(), this.lambdas, new LambdaInfo[]{lambdaInfo});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <U> JPAQueryComposer<U> applyTransformWithTwoLambdas(OuterJoinOnTransform transform, Object lambda1, Object lambda2) {
        lambdaInfo1 = this.lambdaAnalyzer.extractSurfaceInfo(lambda1, this.lambdas.size(), this.hints.dieOnError);
        if (lambdaInfo1 == null) {
            this.translationFail();
            return null;
        }
        lambdaInfo2 = this.lambdaAnalyzer.extractSurfaceInfo(lambda2, this.lambdas.size() + 1, this.hints.dieOnError);
        if (lambdaInfo2 == null) {
            this.translationFail();
            return null;
        }
        v0 = cachedQuery = this.hints.useCaching != false ? this.cachedQueries.findInCache(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo1.getLambdaSourceString(), lambdaInfo2.getLambdaSourceString()}) : null;
        if (cachedQuery == null) {
            block16: {
                block15: {
                    cachedQuery = Optional.empty();
                    newQuery = null;
                    lambdaAnalysis1 = lambdaInfo1.fullyAnalyze(this.metamodel, this.hints.lambdaClassLoader, this.hints.isObjectEqualsSafe, this.hints.isAllEqualsSafe, this.hints.isCollectionContainsSafe, this.hints.dieOnError);
                    if (lambdaAnalysis1 != null) break block15;
                    this.translationFail();
                    var9_10 = null;
                    cachedQuery = Optional.ofNullable(newQuery);
                    if (this.hints.useCaching) {
                        cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo1.getLambdaSourceString(), lambdaInfo2.getLambdaSourceString()}, cachedQuery);
                    }
                    return var9_10;
                }
                lambdaAnalysis2 = lambdaInfo2.fullyAnalyze(this.metamodel, this.hints.lambdaClassLoader, this.hints.isObjectEqualsSafe, this.hints.isAllEqualsSafe, this.hints.isCollectionContainsSafe, this.hints.dieOnError);
                if (lambdaAnalysis2 != null) break block16;
                this.translationFail();
                var10_12 = null;
                cachedQuery = Optional.ofNullable(newQuery);
                if (this.hints.useCaching) {
                    cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo1.getLambdaSourceString(), lambdaInfo2.getLambdaSourceString()}, cachedQuery);
                }
                return var10_12;
            }
            try {
                this.getConfig().checkLambdaSideEffects(lambdaAnalysis1);
                this.getConfig().checkLambdaSideEffects(lambdaAnalysis1);
                newQuery = transform.apply(this.query, lambdaAnalysis1, lambdaAnalysis2, null);
            }
            catch (QueryTransformException e) {
                try {
                    this.translationFail(e);
                }
                catch (Throwable var11_13) {
                    cachedQuery = Optional.ofNullable(newQuery);
                    if (this.hints.useCaching) {
                        cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo1.getLambdaSourceString(), lambdaInfo2.getLambdaSourceString()}, cachedQuery);
                    }
                    throw var11_13;
                }
                cachedQuery = Optional.ofNullable(newQuery);
                if (this.hints.useCaching) {
                    cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo1.getLambdaSourceString(), lambdaInfo2.getLambdaSourceString()}, cachedQuery);
                } else {
                    ** GOTO lbl53
                }
            }
            cachedQuery = Optional.ofNullable(newQuery);
            if (this.hints.useCaching) {
                cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo1.getLambdaSourceString(), lambdaInfo2.getLambdaSourceString()}, cachedQuery);
            }
        }
        if (!cachedQuery.isPresent()) {
            this.translationFail();
            return null;
        }
        return new JPAQueryComposer<T>(this, (JPQLQuery)cachedQuery.get(), this.lambdas, new LambdaInfo[]{lambdaInfo1, lambdaInfo2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> JPAQueryComposer<U> applyTransformWithLambdas(JPQLMultiLambdaQueryTransform transform, Object[] groupingLambdas) {
        Optional<Object> cachedQuery;
        LambdaInfo[] lambdaInfos = new LambdaInfo[groupingLambdas.length];
        String[] lambdaSources = new String[lambdaInfos.length];
        for (int n = 0; n < groupingLambdas.length; ++n) {
            lambdaInfos[n] = this.lambdaAnalyzer.extractSurfaceInfo(groupingLambdas[n], this.lambdas.size() + n, this.hints.dieOnError);
            if (lambdaInfos[n] == null) {
                this.translationFail();
                return null;
            }
            lambdaSources[n] = lambdaInfos[n].getLambdaSourceString();
        }
        Optional<Object> optional = cachedQuery = this.hints.useCaching ? this.cachedQueries.findInCache(this.query, transform.getTransformationTypeCachingTag(), lambdaSources) : null;
        if (cachedQuery == null) {
            cachedQuery = Optional.empty();
            JPQLQuery newQuery = null;
            try {
                LambdaAnalysis[] lambdaAnalyses = new LambdaAnalysis[lambdaInfos.length];
                for (int n = 0; n < lambdaInfos.length; ++n) {
                    lambdaAnalyses[n] = lambdaInfos[n].fullyAnalyze(this.metamodel, this.hints.lambdaClassLoader, this.hints.isObjectEqualsSafe, this.hints.isAllEqualsSafe, this.hints.isCollectionContainsSafe, this.hints.dieOnError);
                    if (lambdaAnalyses[n] == null) {
                        this.translationFail();
                        JPAQueryComposer<U> jPAQueryComposer = null;
                        return jPAQueryComposer;
                    }
                    this.getConfig().checkLambdaSideEffects(lambdaAnalyses[n]);
                }
                newQuery = transform.apply(this.query, lambdaAnalyses, null);
            }
            catch (QueryTransformException e) {
                this.translationFail(e);
            }
            finally {
                cachedQuery = Optional.ofNullable(newQuery);
                if (this.hints.useCaching) {
                    this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), lambdaSources, cachedQuery);
                }
            }
        }
        if (!cachedQuery.isPresent()) {
            this.translationFail();
            return null;
        }
        return new JPAQueryComposer<T>(this, (JPQLQuery)cachedQuery.get(), this.lambdas, lambdaInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <U, V> JPAQueryComposer<V> applyTransformWithTwoQueryMerge(JPQLTwoQueryMergeQueryTransform transform, JinqStream<U> otherSet) {
        Optional<Object> cachedQuery;
        if (!(otherSet instanceof QueryJPAJinqStream)) {
            this.translationFail(new IllegalArgumentException("The other stream must be a query"));
            return null;
        }
        JPAQueryComposer otherComposer = ((QueryJPAJinqStream)otherSet).jpaComposer;
        if (otherComposer.em != this.em) {
            this.translationFail(new IllegalArgumentException("Both queries need to come from the same entity manager"));
            return null;
        }
        JPQLQuery<T> otherQuery = otherComposer.query;
        Optional<Object> optional = cachedQuery = this.hints.useCaching ? this.cachedQueries.findInCache(this.query, otherQuery, transform.getTransformationTypeCachingTag(), null) : null;
        if (cachedQuery == null) {
            cachedQuery = Optional.empty();
            JPQLQuery newQuery = null;
            try {
                newQuery = transform.apply(this.query, otherQuery, this.lambdas.size());
            }
            catch (QueryTransformException e) {
                this.translationFail(e);
            }
            finally {
                cachedQuery = Optional.ofNullable(newQuery);
                if (this.hints.useCaching) {
                    this.cachedQueries.cacheQuery(this.query, otherQuery, transform.getTransformationTypeCachingTag(), null, cachedQuery);
                }
            }
        }
        if (!cachedQuery.isPresent()) {
            this.translationFail();
            return null;
        }
        return new JPAQueryComposer<T>(this, (JPQLQuery)cachedQuery.get(), this.lambdas, otherComposer.lambdas.toArray(new LambdaInfo[0]));
    }

    public JPQLQueryTransformConfiguration getConfig() {
        if (this.transformationConfig == null) {
            this.transformationConfig = this.jpqlQueryTransformConfigurationFactory.createConfig();
            this.transformationConfig.metamodel = this.metamodel;
            this.transformationConfig.alternateClassLoader = this.hints.lambdaClassLoader;
            this.transformationConfig.isObjectEqualsSafe = this.hints.isObjectEqualsSafe;
            this.transformationConfig.isAllEqualsSafe = this.hints.isAllEqualsSafe;
            this.transformationConfig.isCollectionContainsSafe = this.hints.isCollectionContainsSafe;
        }
        return this.transformationConfig;
    }

    public <E extends Exception> JPAQueryComposer<T> where(Object testLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new WhereTransform(this.getConfig(), false), testLambda);
    }

    public <E extends Exception> JPAQueryComposer<T> whereWithSource(Object test) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new WhereTransform(this.getConfig(), true), test);
    }

    public <V extends Comparable<V>> JPAQueryComposer<T> sortedBy(Object sorter, boolean isAscending) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new SortingTransform(this.getConfig(), isAscending), sorter);
    }

    public JPAQueryComposer<T> limit(long n) {
        return this.applyTransformWithLambda((JPQLNoLambdaQueryTransform)new LimitSkipTransform(this.getConfig(), true, n));
    }

    public JPAQueryComposer<T> skip(long n) {
        return this.applyTransformWithLambda((JPQLNoLambdaQueryTransform)new LimitSkipTransform(this.getConfig(), false, n));
    }

    public JPAQueryComposer<T> distinct() {
        return this.applyTransformWithLambda((JPQLNoLambdaQueryTransform)new DistinctTransform(this.getConfig()));
    }

    public <U> JPAQueryComposer<U> select(Object selectLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new SelectTransform(this.getConfig(), false), selectLambda);
    }

    public <U> JPAQueryComposer<U> selectWithSource(Object selectLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new SelectTransform(this.getConfig(), true), selectLambda);
    }

    public <U> QueryComposer<U> selectAll(Object selectLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new JoinTransform(this.getConfig()).setWithSource(false).setJoinAsPairs(false).setIsExpectingStream(true), selectLambda);
    }

    public <U> QueryComposer<U> selectAllWithSource(Object selectLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new JoinTransform(this.getConfig()).setWithSource(true).setJoinAsPairs(false).setIsExpectingStream(true), selectLambda);
    }

    public <U> QueryComposer<U> selectAllIterable(Object selectLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new JoinTransform(this.getConfig()).setWithSource(false).setJoinAsPairs(false).setIsExpectingStream(false), selectLambda);
    }

    public <U> JPAQueryComposer<Pair<T, U>> join(JinqStream.Join<T, U> joinLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new JoinTransform(this.getConfig()).setWithSource(false).setJoinAsPairs(true).setIsExpectingStream(true), joinLambda);
    }

    public <U> JPAQueryComposer<Pair<T, U>> joinWithSource(JinqStream.JoinWithSource<T, U> joinLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new JoinTransform(this.getConfig()).setWithSource(true).setJoinAsPairs(true).setIsExpectingStream(true), joinLambda);
    }

    public <U> QueryComposer<Pair<T, U>> joinIterable(JinqStream.JoinToIterable<T, U> joinLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new JoinTransform(this.getConfig()).setWithSource(false).setJoinAsPairs(true).setIsExpectingStream(false), joinLambda);
    }

    public <U> JPAQueryComposer<T> joinFetch(JinqStream.Join<T, U> joinLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new JoinFetchTransform(this.getConfig()).setIsExpectingStream(true).setIsOuterJoinFetch(false), joinLambda);
    }

    public <U> QueryComposer<T> joinFetchIterable(JinqStream.JoinToIterable<T, U> joinLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new JoinFetchTransform(this.getConfig()).setIsExpectingStream(false).setIsOuterJoinFetch(false), joinLambda);
    }

    public <U> JPAQueryComposer<Pair<T, U>> leftOuterJoin(JinqStream.Join<T, U> joinLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new OuterJoinTransform(this.getConfig()), joinLambda);
    }

    public <U> QueryComposer<Pair<T, U>> leftOuterJoinIterable(JinqStream.JoinToIterable<T, U> joinLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new OuterJoinTransform(this.getConfig()).setIsExpectingStream(false), joinLambda);
    }

    public <U> QueryComposer<Pair<T, U>> leftOuterJoinWithSource(JinqStream.JoinWithSource<T, U> join, JinqStream.WhereForOn<T, U> on) {
        return this.applyTransformWithTwoLambdas(new OuterJoinOnTransform(this.getConfig()).setIsExpectingStream(true), join, on);
    }

    public <U> JPAQueryComposer<T> leftOuterJoinFetch(JinqStream.Join<T, U> joinLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new JoinFetchTransform(this.getConfig()).setIsOuterJoinFetch(true), joinLambda);
    }

    public <U> QueryComposer<T> leftOuterJoinFetchIterable(JinqStream.JoinToIterable<T, U> joinLambda) {
        return this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new JoinFetchTransform(this.getConfig()).setIsExpectingStream(false).setIsOuterJoinFetch(true), joinLambda);
    }

    public <U> QueryComposer<Pair<T, U>> crossJoin(JinqStream<U> join) {
        return this.applyTransformWithTwoQueryMerge((JPQLTwoQueryMergeQueryTransform)new CrossJoinTransform(this.getConfig()), join);
    }

    public QueryComposer<T> orUnion(JPAJinqStream<T> otherSet) {
        return this.applyTransformWithTwoQueryMerge((JPQLTwoQueryMergeQueryTransform)new SetOperationEmulationTransform(this.getConfig(), SetOperationEmulationTransform.SetOperationType.OR_UNION), otherSet);
    }

    public QueryComposer<T> andIntersect(JPAJinqStream<T> otherSet) {
        return this.applyTransformWithTwoQueryMerge((JPQLTwoQueryMergeQueryTransform)new SetOperationEmulationTransform(this.getConfig(), SetOperationEmulationTransform.SetOperationType.AND_INTERSECT), otherSet);
    }

    public QueryComposer<T> andNotExcept(JPAJinqStream<T> otherSet) {
        return this.applyTransformWithTwoQueryMerge((JPQLTwoQueryMergeQueryTransform)new SetOperationEmulationTransform(this.getConfig(), SetOperationEmulationTransform.SetOperationType.AND_NOT_EXCEPT), otherSet);
    }

    public Long count() {
        JPAQueryComposer result = this.applyTransformWithLambda((JPQLNoLambdaQueryTransform)new CountTransform(this.getConfig()));
        if (result != null) {
            return (Long)result.executeAndGetSingleResult();
        }
        this.translationFail();
        return null;
    }

    public <V extends Number> Number sum(Object aggregate, Class<V> collectClass) {
        JPAQueryComposer result = this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new AggregateTransform(this.getConfig(), AggregateTransform.AggregateType.SUM), aggregate);
        if (result != null) {
            return (Number)result.executeAndGetSingleResult();
        }
        this.translationFail();
        return null;
    }

    public <V extends Comparable<V>> V max(Object aggregate) {
        JPAQueryComposer result = this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new AggregateTransform(this.getConfig(), AggregateTransform.AggregateType.MAX), aggregate);
        if (result != null) {
            return (V)((Comparable)result.executeAndGetSingleResult());
        }
        this.translationFail();
        return null;
    }

    public <V extends Comparable<V>> V min(Object aggregate) {
        JPAQueryComposer result = this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new AggregateTransform(this.getConfig(), AggregateTransform.AggregateType.MIN), aggregate);
        if (result != null) {
            return (V)((Comparable)result.executeAndGetSingleResult());
        }
        this.translationFail();
        return null;
    }

    public <V extends Number> Double avg(Object aggregate) {
        JPAQueryComposer result = this.applyTransformWithLambda((JPQLOneLambdaQueryTransform)new AggregateTransform(this.getConfig(), AggregateTransform.AggregateType.AVG), aggregate);
        if (result != null) {
            return (Double)result.executeAndGetSingleResult();
        }
        this.translationFail();
        return null;
    }

    public <U extends Tuple> U multiaggregate(JinqStream.AggregateSelect<T, ?>[] aggregates) {
        Object[] groupingLambdas = new Object[aggregates.length];
        System.arraycopy(aggregates, 0, groupingLambdas, 0, aggregates.length);
        JPAQueryComposer<U> result = this.applyTransformWithLambdas((JPQLMultiLambdaQueryTransform)new MultiAggregateTransform(this.getConfig()), groupingLambdas);
        if (result != null) {
            return (U)((Tuple)result.executeAndGetSingleResult());
        }
        this.translationFail();
        return null;
    }

    public <U, W extends Tuple> JPAQueryComposer<W> groupToTuple(JinqStream.Select<T, U> select, JinqStream.AggregateGroup<U, T, ?>[] aggregates) {
        Object[] groupingLambdas = new Object[aggregates.length + 1];
        groupingLambdas[0] = select;
        System.arraycopy(aggregates, 0, groupingLambdas, 1, aggregates.length);
        return this.applyTransformWithLambdas((JPQLMultiLambdaQueryTransform)new GroupingTransform(this.getConfig()), groupingLambdas);
    }

    public boolean setHint(String name, Object val) {
        return this.hints.setHint(name, val);
    }
}

