/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dnssec;

import java.util.Iterator;
import org.jitsi.dnssec.SecurityStatus;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;

public class SRRset
extends RRset {
    private SecurityStatus securityStatus = SecurityStatus.UNCHECKED;
    private Name ownerName;

    public SRRset() {
    }

    public SRRset(RRset r) {
        this();
        Iterator i = r.rrs();
        while (i.hasNext()) {
            this.addRR((Record)i.next());
        }
        i = r.sigs();
        while (i.hasNext()) {
            this.addRR((Record)i.next());
        }
    }

    public SecurityStatus getSecurityStatus() {
        return this.securityStatus;
    }

    public void setSecurityStatus(SecurityStatus status) {
        this.securityStatus = status;
    }

    public Name getSignerName() {
        Iterator sigs = this.sigs();
        if (sigs.hasNext()) {
            return ((RRSIGRecord)sigs.next()).getSigner();
        }
        return null;
    }

    public Name getName() {
        return this.ownerName == null ? super.getName() : this.ownerName;
    }

    public void setName(Name ownerName) {
        this.ownerName = ownerName;
    }
}

