/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dnssec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jitsi.dnssec.SRRset;
import org.jitsi.dnssec.SecurityStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Flags;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;

public class SMessage {
    private static final Logger logger = LoggerFactory.getLogger(SMessage.class);
    private static final int NUM_SECTIONS = 3;
    private static final int MAX_FLAGS = 16;
    private static final int EXTENDED_FLAGS_BIT_OFFSET = 4;
    private Header header;
    private Record question;
    private OPTRecord oPTRecord;
    private List<SRRset>[] sections = new List[3];
    private SecurityStatus securityStatus;
    private String bogusReason;

    public SMessage(Header h) {
        this.header = h;
        this.securityStatus = SecurityStatus.UNCHECKED;
    }

    public SMessage(int id, Record question) {
        this(new Header(id));
        this.question = question;
    }

    public SMessage(Message m) {
        this(m.getHeader());
        this.question = m.getQuestion();
        this.oPTRecord = m.getOPT();
        for (int i = 1; i <= 3; ++i) {
            for (RRset rrset : m.getSectionRRsets(i)) {
                this.addRRset(new SRRset(rrset), i);
            }
        }
    }

    public Header getHeader() {
        return this.header;
    }

    public Record getQuestion() {
        return this.question;
    }

    public List<SRRset> getSectionRRsets(int section) {
        this.checkSectionValidity(section);
        if (this.sections[section - 1] == null) {
            this.sections[section - 1] = new LinkedList<SRRset>();
        }
        return this.sections[section - 1];
    }

    private void addRRset(SRRset srrset, int section) {
        this.checkSectionValidity(section);
        if (srrset.getType() == 41) {
            this.oPTRecord = (OPTRecord)srrset.first();
            return;
        }
        List<SRRset> sectionList = this.getSectionRRsets(section);
        sectionList.add(srrset);
    }

    private void checkSectionValidity(int section) {
        if (section <= 0 || section > 3) {
            throw new IllegalArgumentException("Invalid section");
        }
    }

    public List<SRRset> getSectionRRsets(int section, int qtype) {
        List<SRRset> slist = this.getSectionRRsets(section);
        if (slist.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SRRset> result = new ArrayList<SRRset>(slist.size());
        for (SRRset rrset : slist) {
            if (rrset.getType() != qtype) continue;
            result.add(rrset);
        }
        return result;
    }

    public int getRcode() {
        int rcode = this.header.getRcode();
        if (this.oPTRecord != null) {
            rcode += this.oPTRecord.getExtendedRcode() << 4;
        }
        return rcode;
    }

    public SecurityStatus getStatus() {
        return this.securityStatus;
    }

    public void setStatus(SecurityStatus status) {
        this.securityStatus = status;
    }

    public void setStatus(SecurityStatus status, String reason) {
        this.securityStatus = status;
        this.bogusReason = reason;
        logger.debug(this.bogusReason);
    }

    public String getBogusReason() {
        return this.bogusReason;
    }

    public void setBogus(String reason) {
        this.setStatus(SecurityStatus.BOGUS);
        this.bogusReason = reason;
        logger.debug(this.bogusReason);
    }

    public Message getMessage() {
        Message m = new Message(this.header.getID());
        Header h = m.getHeader();
        h.setOpcode(this.header.getOpcode());
        h.setRcode(this.header.getRcode());
        for (int i = 0; i < 16; ++i) {
            if (!Flags.isFlag((int)i) || !this.header.getFlag(i)) continue;
            h.setFlag(i);
        }
        if (this.question != null) {
            m.addRecord(this.question, 0);
        }
        for (int sec = 1; sec <= 3; ++sec) {
            List<SRRset> slist = this.getSectionRRsets(sec);
            for (SRRset rrset : slist) {
                for (Record j : rrset.rrs()) {
                    m.addRecord(j, sec);
                }
                for (Record j : rrset.sigs()) {
                    m.addRecord(j, sec);
                }
            }
        }
        if (this.oPTRecord != null) {
            m.addRecord((Record)this.oPTRecord, 3);
        }
        return m;
    }

    public int getCount(int section) {
        if (section == 0) {
            return 1;
        }
        List<SRRset> sectionList = this.getSectionRRsets(section);
        if (sectionList.size() == 0) {
            return 0;
        }
        int count = 0;
        for (SRRset sr : sectionList) {
            count += sr.size();
        }
        return count;
    }

    public SRRset findRRset(Name name, int type, int dclass, int section) {
        this.checkSectionValidity(section);
        for (SRRset set : this.getSectionRRsets(section)) {
            if (!set.getName().equals((Object)name) || set.getType() != type || set.getDClass() != dclass) continue;
            return set;
        }
        return null;
    }

    public SRRset findAnswerRRset(Name qname, int qtype, int qclass) {
        return this.findRRset(qname, qtype, qclass, 1);
    }
}

