/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dnssec;

import java.util.List;
import org.jitsi.dnssec.SecurityStatus;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;

public class SRRset
extends RRset {
    private SecurityStatus securityStatus;
    private Name ownerName;

    public SRRset() {
        this.securityStatus = SecurityStatus.UNCHECKED;
    }

    public SRRset(Record r) {
        super(r);
        this.securityStatus = SecurityStatus.UNCHECKED;
    }

    public SRRset(RRset r) {
        super(r);
        this.securityStatus = SecurityStatus.UNCHECKED;
    }

    public SRRset(SRRset r) {
        super((RRset)r);
        this.securityStatus = r.securityStatus;
        this.ownerName = r.ownerName;
    }

    public SecurityStatus getSecurityStatus() {
        return this.securityStatus;
    }

    public void setSecurityStatus(SecurityStatus status) {
        this.securityStatus = status;
    }

    public Name getSignerName() {
        List sigs = this.sigs();
        if (!sigs.isEmpty()) {
            return ((RRSIGRecord)sigs.get(0)).getSigner();
        }
        return null;
    }

    public Name getName() {
        return this.ownerName == null ? super.getName() : this.ownerName;
    }

    public void setName(Name ownerName) {
        this.ownerName = ownerName;
    }
}

