/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dnssec.validator;

import org.jitsi.dnssec.R;
import org.jitsi.dnssec.SRRset;
import org.jitsi.dnssec.SecurityStatus;
import org.jitsi.dnssec.validator.JustifiedSecStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

public final class KeyEntry
extends SRRset {
    private static final Logger logger = LoggerFactory.getLogger(KeyEntry.class);
    private String badReason;
    private boolean isEmpty;

    private KeyEntry(SRRset rrset) {
        super(rrset);
    }

    private KeyEntry(Name name, int dclass, long ttl, boolean isBad) {
        super(new SRRset(Record.newRecord((Name)name, (int)48, (int)dclass, (long)ttl)));
        this.isEmpty = true;
        if (isBad) {
            this.setSecurityStatus(SecurityStatus.BOGUS);
        }
    }

    public static KeyEntry newKeyEntry(SRRset rrset) {
        return new KeyEntry(rrset);
    }

    public static KeyEntry newNullKeyEntry(Name n, int dclass, long ttl) {
        return new KeyEntry(n, dclass, ttl, false);
    }

    public static KeyEntry newBadKeyEntry(Name n, int dclass, long ttl) {
        return new KeyEntry(n, dclass, ttl, true);
    }

    public boolean isNull() {
        return this.isEmpty && this.getSecurityStatus() == SecurityStatus.UNCHECKED;
    }

    public boolean isBad() {
        return this.isEmpty && this.getSecurityStatus() == SecurityStatus.BOGUS;
    }

    public boolean isGood() {
        return !this.isEmpty && this.getSecurityStatus() == SecurityStatus.SECURE;
    }

    public void setBadReason(String reason) {
        this.badReason = reason;
        logger.debug(this.badReason);
    }

    JustifiedSecStatus validateKeyFor(Name signerName) {
        if (signerName == null) {
            logger.debug("no signerName");
            if (this.isNull()) {
                String reason = this.badReason;
                if (reason == null) {
                    reason = R.get("validate.insecure_unsigned", new Object[0]);
                }
                return new JustifiedSecStatus(SecurityStatus.INSECURE, reason);
            }
            if (this.isGood()) {
                return new JustifiedSecStatus(SecurityStatus.BOGUS, R.get("validate.bogus.missingsig", new Object[0]));
            }
            return new JustifiedSecStatus(SecurityStatus.BOGUS, R.get("validate.bogus", this.badReason));
        }
        if (this.isBad()) {
            return new JustifiedSecStatus(SecurityStatus.BOGUS, R.get("validate.bogus.badkey", this.getName(), this.badReason));
        }
        if (this.isNull()) {
            String reason = this.badReason;
            if (reason == null) {
                reason = R.get("validate.insecure", new Object[0]);
            }
            return new JustifiedSecStatus(SecurityStatus.INSECURE, reason);
        }
        return null;
    }
}

