/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dnssec.validator;

import java.util.HashMap;
import java.util.Map;
import org.jitsi.dnssec.SRRset;
import org.jitsi.dnssec.SecurityStatus;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.DSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

public class TrustAnchorStore {
    private Map<String, SRRset> map = new HashMap<String, SRRset>();

    public void store(SRRset rrset) {
        if (rrset.getType() != 43 && rrset.getType() != 48) {
            throw new IllegalArgumentException("Trust anchors can only be DS or DNSKEY records");
        }
        if (rrset.getType() == 48) {
            SRRset temp = new SRRset();
            for (Record r : rrset.rrs()) {
                DNSKEYRecord key = (DNSKEYRecord)r;
                DSRecord ds = new DSRecord(key.getName(), key.getDClass(), key.getTTL(), 4, key);
                temp.addRR((Record)ds);
            }
            rrset = temp;
        }
        String k = this.key(rrset.getName(), rrset.getDClass());
        rrset.setSecurityStatus(SecurityStatus.SECURE);
        SRRset previous = this.map.put(k, rrset);
        if (previous != null) {
            previous.rrs().forEach(arg_0 -> ((SRRset)rrset).addRR(arg_0));
        }
    }

    public SRRset find(Name name, int dclass) {
        while (name.labels() > 0) {
            String k = this.key(name, dclass);
            SRRset r = this.lookup(k);
            if (r != null) {
                return r;
            }
            name = new Name(name, 1);
        }
        return null;
    }

    public void clear() {
        this.map.clear();
    }

    private SRRset lookup(String key) {
        return this.map.get(key);
    }

    private String key(Name n, int dclass) {
        return "T" + dclass + "/" + n;
    }
}

