/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dnssec.validator;

import java.security.Security;
import java.time.Instant;
import java.util.List;
import java.util.Properties;
import org.jitsi.dnssec.R;
import org.jitsi.dnssec.SMessage;
import org.jitsi.dnssec.SRRset;
import org.jitsi.dnssec.SecurityStatus;
import org.jitsi.dnssec.validator.DnsSecVerifier;
import org.jitsi.dnssec.validator.JustifiedSecStatus;
import org.jitsi.dnssec.validator.KeyEntry;
import org.jitsi.dnssec.validator.ResponseClassification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.DSRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.NSECRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;

public class ValUtils {
    public static final String DIGEST_PREFERENCE = "org.jitsi.dnssec.digest_preference";
    public static final String DIGEST_ENABLED = "org.jitsi.dnssec.digest";
    public static final String DIGEST_HARDEN_DOWNGRADE = "org.jitsi.dnssec.harden_algo_downgrade";
    public static final String ALGORITHM_ENABLED = "org.jitsi.dnssec.algorithm";
    private static final Logger logger = LoggerFactory.getLogger(ValUtils.class);
    private static final Name WILDCARD = Name.fromConstantString((String)"*");
    private DnsSecVerifier verifier = new DnsSecVerifier();
    private int[] digestPreference = null;
    private Properties config = null;
    private boolean digestHardenDowngrade = true;
    private boolean hasGost = Security.getProviders("MessageDigest.GOST3411") != null;
    private boolean hasEd25519 = Security.getProviders("KeyFactory.Ed25519") != null;
    private boolean hasEd448 = Security.getProviders("KeyFactory.Ed448") != null;

    public static void setCanonicalNsecOwner(SRRset set, RRSIGRecord sig) {
        if (set.getType() != 47) {
            return;
        }
        Record nsec = set.first();
        int fqdnLabelCount = nsec.getName().labels() - 1;
        if (nsec.getName().isWild()) {
            --fqdnLabelCount;
        }
        if (sig.getLabels() == fqdnLabelCount) {
            set.setName(nsec.getName());
        } else if (sig.getLabels() < fqdnLabelCount) {
            set.setName(nsec.getName().wild(sig.getSigner().labels() - sig.getLabels()));
        } else {
            throw new IllegalArgumentException("invalid nsec record");
        }
    }

    public void init(Properties config) {
        this.hasGost = Security.getProviders("MessageDigest.GOST3411") != null;
        this.hasEd25519 = Security.getProviders("KeyFactory.Ed25519") != null;
        this.hasEd448 = Security.getProviders("KeyFactory.Ed448") != null;
        this.config = config;
        String dp = config.getProperty(DIGEST_PREFERENCE);
        if (dp != null) {
            String[] dpdata = dp.split(",");
            this.digestPreference = new int[dpdata.length];
            for (int i = 0; i < dpdata.length; ++i) {
                this.digestPreference[i] = Integer.parseInt(dpdata[i]);
                if (this.isDigestSupported(this.digestPreference[i])) continue;
                throw new IllegalArgumentException("Unsupported or disabled digest ID in digest preferences");
            }
        }
        this.digestHardenDowngrade = Boolean.parseBoolean(config.getProperty(DIGEST_HARDEN_DOWNGRADE));
    }

    public static ResponseClassification classifyResponse(Message request, SMessage m) {
        if (m.getRcode() == 3 && m.getCount(1) == 0) {
            return ResponseClassification.NAMEERROR;
        }
        if (m.getCount(1) == 0 && m.getRcode() != 0) {
            boolean sawNs = false;
            for (RRset rRset : m.getSectionRRsets(2)) {
                if (rRset.getType() == 6) {
                    return ResponseClassification.NODATA;
                }
                if (rRset.getType() == 43) {
                    return ResponseClassification.REFERRAL;
                }
                if (rRset.getType() != 2) continue;
                sawNs = true;
            }
            return sawNs ? ResponseClassification.REFERRAL : ResponseClassification.NODATA;
        }
        if (m.getSectionRRsets(2).size() == 0 && m.getSectionRRsets(1).size() == 1 && m.getRcode() == 0 && m.getSectionRRsets(1).get(0).getType() == 2 && !m.getSectionRRsets(1).get(0).getName().equals((Object)request.getQuestion().getName())) {
            return ResponseClassification.REFERRAL;
        }
        if (m.getRcode() != 0 && m.getRcode() != 3) {
            return ResponseClassification.UNKNOWN;
        }
        if (m.getCount(1) == 0) {
            return ResponseClassification.NODATA;
        }
        int qtype = m.getQuestion().getType();
        if (qtype == 255) {
            return ResponseClassification.ANY;
        }
        boolean hadCname = false;
        for (RRset rRset : m.getSectionRRsets(1)) {
            if (rRset.getType() == qtype) {
                return ResponseClassification.POSITIVE;
            }
            if (rRset.getType() != 5 && rRset.getType() != 39) continue;
            hadCname = true;
            if (qtype != 43) continue;
            return ResponseClassification.CNAME;
        }
        if (hadCname) {
            if (m.getRcode() == 3) {
                return ResponseClassification.CNAME_NAMEERROR;
            }
            return ResponseClassification.CNAME_NODATA;
        }
        logger.warn("Failed to classify response message:\n" + m);
        return ResponseClassification.UNKNOWN;
    }

    public KeyEntry verifyNewDNSKEYs(SRRset dnskeyRrset, SRRset dsRrset, long badKeyTTL, Instant date) {
        if (!this.atLeastOneDigestSupported(dsRrset)) {
            KeyEntry ke = KeyEntry.newNullKeyEntry(dsRrset.getName(), dsRrset.getDClass(), dsRrset.getTTL());
            ke.setBadReason(R.get("failed.ds.nodigest", dsRrset.getName()));
            return ke;
        }
        if (!this.atLeastOneSupportedAlgorithm(dsRrset)) {
            KeyEntry ke = KeyEntry.newNullKeyEntry(dsRrset.getName(), dsRrset.getDClass(), dsRrset.getTTL());
            ke.setBadReason(R.get("failed.ds.noalg", dsRrset.getName()));
            return ke;
        }
        int favoriteDigestID = this.favoriteDSDigestID(dsRrset);
        for (Record dsr : dsRrset.rrs()) {
            DSRecord ds = (DSRecord)dsr;
            if (this.digestHardenDowngrade && ds.getDigestID() != favoriteDigestID) continue;
            block1: for (Record dsnkeyr : dnskeyRrset.rrs()) {
                byte[] dsHash;
                DSRecord keyDigest;
                byte[] keyHash;
                DNSKEYRecord dnskey = (DNSKEYRecord)dsnkeyr;
                if (ds.getFootprint() != dnskey.getFootprint() || ds.getAlgorithm() != dnskey.getAlgorithm() || (keyHash = (keyDigest = new DSRecord(Name.root, ds.getDClass(), 0L, ds.getDigestID(), dnskey)).getDigest()).length != (dsHash = ds.getDigest()).length) continue;
                for (int k = 0; k < keyHash.length; ++k) {
                    if (keyHash[k] != dsHash[k]) continue block1;
                }
                SecurityStatus res = this.verifier.verify((RRset)dnskeyRrset, dnskey, date);
                if (res != SecurityStatus.SECURE) continue;
                logger.trace("DS matched DNSKEY.");
                dnskeyRrset.setSecurityStatus(SecurityStatus.SECURE);
                return KeyEntry.newKeyEntry(dnskeyRrset);
            }
        }
        KeyEntry badKey = KeyEntry.newBadKeyEntry(dsRrset.getName(), dsRrset.getDClass(), badKeyTTL);
        badKey.setBadReason(R.get("dnskey.no_ds_match", new Object[0]));
        return badKey;
    }

    int favoriteDSDigestID(SRRset dsset) {
        if (this.digestPreference == null) {
            int max = 0;
            for (Record r : dsset.rrs()) {
                DSRecord ds = (DSRecord)r;
                if (ds.getDigestID() <= max || !this.isDigestSupported(ds.getDigestID()) || !this.isAlgorithmSupported(ds.getAlgorithm())) continue;
                max = ds.getDigestID();
            }
            return max;
        }
        for (int preference : this.digestPreference) {
            for (Record r : dsset.rrs()) {
                DSRecord ds = (DSRecord)r;
                if (ds.getDigestID() != preference) continue;
                return ds.getDigestID();
            }
        }
        return 0;
    }

    public SecurityStatus verifySRRset(SRRset rrset, SRRset keyRrset, Instant date) {
        String rrsetName = rrset.getName() + "/" + Type.string((int)rrset.getType()) + "/" + DClass.string((int)rrset.getDClass());
        if (rrset.getSecurityStatus() == SecurityStatus.SECURE) {
            logger.trace("verifySRRset: rrset <" + rrsetName + "> previously found to be SECURE");
            return SecurityStatus.SECURE;
        }
        SecurityStatus status = this.verifier.verify(rrset, keyRrset, date);
        if (status != SecurityStatus.SECURE) {
            logger.debug("verifySRRset: rrset <" + rrsetName + "> found to be BAD");
            status = SecurityStatus.BOGUS;
        } else {
            logger.trace("verifySRRset: rrset <" + rrsetName + "> found to be SECURE");
        }
        rrset.setSecurityStatus(status);
        return status;
    }

    public static Name rrsetWildcard(RRset rrset) {
        int labelDiff;
        List sigs = rrset.sigs();
        RRSIGRecord firstSig = (RRSIGRecord)sigs.get(0);
        for (int i = 1; i < sigs.size(); ++i) {
            if (((RRSIGRecord)sigs.get(i)).getLabels() == firstSig.getLabels()) continue;
            throw new RuntimeException("failed.wildcard.label_count_mismatch");
        }
        Name wn = rrset.getName();
        if (rrset.getName().isWild()) {
            wn = new Name(wn, 1);
        }
        if ((labelDiff = wn.labels() - 1 - firstSig.getLabels()) > 0) {
            return wn.wild(labelDiff);
        }
        return null;
    }

    public static Name longestCommonName(Name domain1, Name domain2) {
        int l = Math.min(domain1.labels(), domain2.labels());
        domain1 = new Name(domain1, domain1.labels() - l);
        domain2 = new Name(domain2, domain2.labels() - l);
        for (int i = 0; i < l - 1; ++i) {
            Name ns1 = new Name(domain1, i);
            if (!ns1.equals((Object)new Name(domain2, i))) continue;
            return ns1;
        }
        return Name.root;
    }

    public static boolean strictSubdomain(Name domain1, Name domain2) {
        if (domain1.labels() <= domain2.labels()) {
            return false;
        }
        return new Name(domain1, domain1.labels() - domain2.labels()).equals((Object)domain2);
    }

    public static Name closestEncloser(Name domain, Name owner, Name next) {
        Name n1 = ValUtils.longestCommonName(domain, owner);
        Name n2 = ValUtils.longestCommonName(domain, next);
        return n1.labels() > n2.labels() ? n1 : n2;
    }

    public static Name nsecWildcard(Name domain, SRRset set, NSECRecord nsec) throws NameTooLongException {
        Name origin = ValUtils.closestEncloser(domain, set.getName(), nsec.getNext());
        return Name.concatenate((Name)WILDCARD, (Name)origin);
    }

    public static boolean nsecProvesNameError(SRRset set, NSECRecord nsec, Name qname) {
        Name owner = set.getName();
        Name next = nsec.getNext();
        if (qname.equals((Object)owner)) {
            return false;
        }
        if (!next.subdomain(set.getSignerName())) {
            return false;
        }
        if (qname.subdomain(owner)) {
            if (nsec.hasType(39)) {
                return false;
            }
            if (nsec.hasType(2) && !nsec.hasType(6)) {
                return false;
            }
        }
        return owner.equals((Object)next) ? ValUtils.strictSubdomain(qname, next) : (owner.compareTo(next) > 0 ? owner.compareTo(qname) < 0 && ValUtils.strictSubdomain(qname, next) : owner.compareTo(qname) < 0 && qname.compareTo(next) < 0);
    }

    public static boolean nsecProvesNoWC(SRRset set, NSECRecord nsec, Name qname) {
        Name ce = ValUtils.closestEncloser(qname, set.getName(), nsec.getNext());
        int labelsToStrip = qname.labels() - ce.labels();
        if (labelsToStrip > 0) {
            Name wcName = qname.wild(labelsToStrip);
            return ValUtils.nsecProvesNameError(set, nsec, wcName);
        }
        return false;
    }

    public static NsecProvesNodataResponse nsecProvesNodata(SRRset set, NSECRecord nsec, Name qname, int qtype) {
        NsecProvesNodataResponse result = new NsecProvesNodataResponse();
        if (!set.getName().equals((Object)qname)) {
            if (ValUtils.strictSubdomain(nsec.getNext(), qname) && set.getName().compareTo(qname) < 0) {
                result.result = true;
                return result;
            }
            if (set.getName().isWild()) {
                Name ce = new Name(set.getName(), 1);
                if (ValUtils.strictSubdomain(qname, ce)) {
                    if (nsec.hasType(5)) {
                        result.result = false;
                        return result;
                    }
                    if (nsec.hasType(2) && !nsec.hasType(6)) {
                        result.result = false;
                        return result;
                    }
                    if (nsec.hasType(qtype)) {
                        result.result = false;
                        return result;
                    }
                }
                result.wc = ce;
                result.result = true;
                return result;
            }
            result.result = false;
            return result;
        }
        if (nsec.hasType(qtype)) {
            result.result = false;
            return result;
        }
        if (nsec.hasType(5)) {
            result.result = false;
            return result;
        }
        if (qtype != 43 && nsec.hasType(2) && !nsec.hasType(6)) {
            result.result = false;
            return result;
        }
        if (qtype == 43 && nsec.hasType(6) && !Name.root.equals((Object)qname)) {
            result.result = false;
            return result;
        }
        result.result = true;
        return result;
    }

    public JustifiedSecStatus nsecProvesNodataDsReply(Message request, SMessage response, SRRset keyRrset, Instant date) {
        int qclass;
        Name qname = request.getQuestion().getName();
        SRRset nsecRrset = response.findRRset(qname, 47, qclass = request.getQuestion().getDClass(), 2);
        if (nsecRrset != null) {
            SecurityStatus status = this.verifySRRset(nsecRrset, keyRrset, date);
            if (status != SecurityStatus.SECURE) {
                return new JustifiedSecStatus(SecurityStatus.BOGUS, R.get("failed.ds.nsec", new Object[0]));
            }
            NSECRecord nsec = (NSECRecord)nsecRrset.first();
            status = ValUtils.nsecProvesNoDS(nsec, qname);
            switch (status) {
                case INSECURE: {
                    return new JustifiedSecStatus(status, R.get("failed.ds.nodelegation", new Object[0]));
                }
                case SECURE: {
                    return new JustifiedSecStatus(status, R.get("insecure.ds.nsec", new Object[0]));
                }
            }
            return new JustifiedSecStatus(status, R.get("failed.ds.nsec.hasdata", new Object[0]));
        }
        NsecProvesNodataResponse ndp = new NsecProvesNodataResponse();
        Name ce = null;
        boolean hasValidNSEC = false;
        NSECRecord wcNsec = null;
        for (SRRset set : response.getSectionRRsets(2, 47)) {
            SecurityStatus status = this.verifySRRset(set, keyRrset, date);
            if (status != SecurityStatus.SECURE) {
                return new JustifiedSecStatus(status, R.get("failed.ds.nsec.ent", new Object[0]));
            }
            NSECRecord nsec = (NSECRecord)set.rrs().get(0);
            ndp = ValUtils.nsecProvesNodata(set, nsec, qname, 43);
            if (ndp.result) {
                hasValidNSEC = true;
                if (ndp.wc != null && nsec.getName().isWild()) {
                    wcNsec = nsec;
                }
            }
            if (!ValUtils.nsecProvesNameError(set, nsec, qname)) continue;
            ce = ValUtils.closestEncloser(qname, set.getName(), nsec.getNext());
        }
        if (!(ndp.wc == null || ce != null && ce.equals((Object)ndp.wc))) {
            hasValidNSEC = false;
        }
        if (hasValidNSEC) {
            if (ndp.wc != null) {
                SecurityStatus status = ValUtils.nsecProvesNoDS(wcNsec, qname);
                return new JustifiedSecStatus(status, R.get("failed.ds.nowildcardproof", new Object[0]));
            }
            return new JustifiedSecStatus(SecurityStatus.INSECURE, R.get("insecure.ds.nsec.ent", new Object[0]));
        }
        return new JustifiedSecStatus(SecurityStatus.UNCHECKED, R.get("failed.ds.nonconclusive", new Object[0]));
    }

    public boolean hasSignedNsecs(SMessage message) {
        for (SRRset set : message.getSectionRRsets(2)) {
            if (set.getType() != 47 && set.getType() != 50 || set.sigs().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static SecurityStatus nsecProvesNoDS(NSECRecord nsec, Name qname) {
        if (nsec.hasType(6) && !Name.root.equals((Object)qname) || nsec.hasType(43)) {
            return SecurityStatus.BOGUS;
        }
        if (!nsec.hasType(2)) {
            return SecurityStatus.INSECURE;
        }
        return SecurityStatus.SECURE;
    }

    boolean atLeastOneSupportedAlgorithm(RRset dsRRset) {
        for (Record r : dsRRset.rrs()) {
            if (!this.isAlgorithmSupported(((DSRecord)r).getAlgorithm())) continue;
            return true;
        }
        return false;
    }

    boolean isAlgorithmSupported(int alg) {
        String configKey = "org.jitsi.dnssec.algorithm." + alg;
        switch (alg) {
            case 1: {
                return false;
            }
            case 3: 
            case 6: {
                if (this.config == null) {
                    return false;
                }
                return Boolean.parseBoolean(this.config.getProperty(configKey, Boolean.FALSE.toString()));
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: {
                return this.propertyOrTrueWithPrecondition(configKey, true);
            }
            case 12: {
                return this.propertyOrTrueWithPrecondition(configKey, this.hasGost);
            }
            case 15: {
                return this.propertyOrTrueWithPrecondition(configKey, this.hasEd25519);
            }
            case 16: {
                return this.propertyOrTrueWithPrecondition(configKey, this.hasEd448);
            }
        }
        return false;
    }

    boolean atLeastOneDigestSupported(RRset dsRRset) {
        for (Record r : dsRRset.rrs()) {
            if (!this.isDigestSupported(((DSRecord)r).getDigestID())) continue;
            return true;
        }
        return false;
    }

    boolean isDigestSupported(int digestID) {
        String configKey = "org.jitsi.dnssec.digest." + digestID;
        switch (digestID) {
            case 1: 
            case 2: 
            case 4: {
                if (this.config == null) {
                    return true;
                }
                return Boolean.parseBoolean(this.config.getProperty(configKey, Boolean.TRUE.toString()));
            }
            case 3: {
                return this.propertyOrTrueWithPrecondition(configKey, this.hasGost);
            }
        }
        return false;
    }

    private boolean propertyOrTrueWithPrecondition(String configKey, boolean precondition) {
        if (!precondition) {
            return false;
        }
        if (this.config == null) {
            return true;
        }
        return Boolean.parseBoolean(this.config.getProperty(configKey, Boolean.TRUE.toString()));
    }

    public static class NsecProvesNodataResponse {
        boolean result;
        Name wc;
    }
}

