/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dnssec.validator;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.jitsi.dnssec.R;
import org.jitsi.dnssec.SMessage;
import org.jitsi.dnssec.SRRset;
import org.jitsi.dnssec.SecurityStatus;
import org.jitsi.dnssec.validator.FindKeyState;
import org.jitsi.dnssec.validator.JustifiedSecStatus;
import org.jitsi.dnssec.validator.KeyCache;
import org.jitsi.dnssec.validator.KeyEntry;
import org.jitsi.dnssec.validator.NSEC3ValUtils;
import org.jitsi.dnssec.validator.ResponseClassification;
import org.jitsi.dnssec.validator.TrustAnchorStore;
import org.jitsi.dnssec.validator.ValUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.Header;
import org.xbill.DNS.Master;
import org.xbill.DNS.Message;
import org.xbill.DNS.NSECRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.Type;

public class ValidatingResolver
implements Resolver {
    public static final int VALIDATION_REASON_QCLASS = 65280;
    private static final Logger logger = LoggerFactory.getLogger(ValidatingResolver.class);
    private static final long DEFAULT_TA_BAD_KEY_TTL = 60L;
    private KeyCache keyCache;
    private TrustAnchorStore trustAnchors;
    private ValUtils valUtils;
    private NSEC3ValUtils n3valUtils;
    private Resolver headResolver;
    private final Clock clock;

    public ValidatingResolver(Resolver headResolver) {
        this(headResolver, Clock.systemUTC());
    }

    public ValidatingResolver(Resolver headResolver, Clock clock) {
        this.headResolver = headResolver;
        this.clock = clock;
        headResolver.setEDNS(0, 0, 32768, new EDNSOption[0]);
        headResolver.setIgnoreTruncation(false);
        this.keyCache = new KeyCache();
        this.valUtils = new ValUtils();
        this.n3valUtils = new NSEC3ValUtils();
        this.trustAnchors = new TrustAnchorStore();
    }

    public void init(Properties config) throws IOException {
        this.keyCache.init(config);
        this.n3valUtils.init(config);
        this.valUtils.init(config);
        String s = config.getProperty("org.jitsi.dnssec.trust_anchor_file");
        if (s != null) {
            logger.debug("reading trust anchor file file: " + s);
            this.loadTrustAnchors(new FileInputStream(s));
        }
    }

    public void loadTrustAnchors(InputStream data) throws IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        Master master = new Master(data, Name.root, 0L);
        Object object = null;
        try {
            Record mr;
            while ((mr = master.nextRecord()) != null) {
                records.add(mr);
            }
        }
        catch (Throwable mr) {
            object = mr;
            throw mr;
        }
        finally {
            if (master != null) {
                if (object != null) {
                    try {
                        master.close();
                    }
                    catch (Throwable mr) {
                        ((Throwable)object).addSuppressed(mr);
                    }
                } else {
                    master.close();
                }
            }
        }
        Collections.sort(records);
        SRRset currentRrset = new SRRset();
        for (Record r : records) {
            if (r.getType() != 48 && r.getType() != 43) continue;
            if (currentRrset.size() == 0) {
                currentRrset.addRR(r);
                continue;
            }
            if (currentRrset.getName().equals((Object)r.getName()) && currentRrset.getType() == r.getType() && currentRrset.getDClass() == r.getDClass()) {
                currentRrset.addRR(r);
                continue;
            }
            this.trustAnchors.store(currentRrset);
            currentRrset = new SRRset();
            currentRrset.addRR(r);
        }
        if (currentRrset.size() > 0) {
            this.trustAnchors.store(currentRrset);
        }
    }

    public TrustAnchorStore getTrustAnchors() {
        return this.trustAnchors;
    }

    private void removeSpuriousAuthority(SMessage response) {
        if (response.getSectionRRsets(1).size() == 0 && response.getSectionRRsets(2).size() == 1) {
            return;
        }
        Iterator<SRRset> authRrsetIterator = response.getSectionRRsets(2).iterator();
        while (authRrsetIterator.hasNext()) {
            SRRset rrset = authRrsetIterator.next();
            if (rrset.getType() != 2 || !rrset.sigs().isEmpty()) continue;
            logger.trace("Removing spurious unsigned NS record (likely inserted by forwarder) {}/{}/{}", new Object[]{rrset.getName(), Type.string((int)rrset.getType()), DClass.string((int)rrset.getDClass())});
            authRrsetIterator.remove();
        }
    }

    private CompletionStage<Void> validatePositiveResponse(Message request, SMessage response) {
        HashMap<Name, Name> wcs = new HashMap<Name, Name>(1);
        ArrayList nsec3s = new ArrayList(0);
        ArrayList nsecs = new ArrayList(0);
        return this.validateAnswerAndGetWildcards(response, request.getQuestion().getType(), wcs).thenCompose(success -> {
            if (success.booleanValue()) {
                int[] sections = request.getQuestion().getType() == 255 ? new int[]{1, 2} : new int[]{2};
                return this.validatePositiveResponseRecursive(response, wcs, nsec3s, nsecs, sections, new AtomicInteger(0), new AtomicInteger(0));
            }
            return CompletableFuture.completedFuture(false);
        }).thenAccept(success -> {
            if (!success.booleanValue()) {
                return;
            }
            if (wcs.size() > 0) {
                for (Map.Entry wc : wcs.entrySet()) {
                    boolean wcNsecOk = false;
                    for (SRRset set : nsecs) {
                        NSECRecord nsec;
                        if (!ValUtils.nsecProvesNameError(set, nsec = (NSECRecord)set.first(), (Name)wc.getKey())) continue;
                        try {
                            Name nsecWc = ValUtils.nsecWildcard((Name)wc.getKey(), set, nsec);
                            if (!((Name)wc.getValue()).equals((Object)nsecWc)) continue;
                            wcNsecOk = true;
                            break;
                        }
                        catch (NameTooLongException e) {
                            throw new RuntimeException(R.get("failed.positive.wildcardgeneration", new Object[0]));
                        }
                    }
                    if (!wcNsecOk && nsec3s.size() > 0) {
                        if (this.n3valUtils.allNSEC3sIgnoreable(nsec3s, this.keyCache)) {
                            response.setStatus(SecurityStatus.INSECURE, R.get("failed.nsec3_ignored", new Object[0]));
                            return;
                        }
                        SecurityStatus status = this.n3valUtils.proveWildcard(nsec3s, (Name)wc.getKey(), ((SRRset)((Object)((Object)nsec3s.get(0)))).getSignerName(), (Name)wc.getValue());
                        if (status == SecurityStatus.INSECURE) {
                            response.setStatus(status);
                            return;
                        }
                        if (status == SecurityStatus.SECURE) {
                            wcNsecOk = true;
                        }
                    }
                    if (wcNsecOk) continue;
                    response.setBogus(R.get("failed.positive.wildcard_too_broad", new Object[0]));
                    return;
                }
            }
            response.setStatus(SecurityStatus.SECURE);
        });
    }

    private CompletionStage<Boolean> validatePositiveResponseRecursive(SMessage response, Map<Name, Name> wcs, List<SRRset> nsec3s, List<SRRset> nsecs, int[] sections, AtomicInteger sectionIndex, AtomicInteger setIndex) {
        if (sectionIndex.get() >= sections.length) {
            return CompletableFuture.completedFuture(true);
        }
        List<SRRset> sectionRRsets = response.getSectionRRsets(sections[sectionIndex.get()]);
        if (setIndex.get() >= sectionRRsets.size()) {
            sectionIndex.getAndIncrement();
            setIndex.set(0);
            return this.validatePositiveResponseRecursive(response, wcs, nsec3s, nsecs, sections, sectionIndex, setIndex);
        }
        SRRset set = sectionRRsets.get(setIndex.getAndIncrement());
        return this.prepareFindKey(set).thenCompose(ke -> {
            JustifiedSecStatus kve = ke.validateKeyFor(set.getSignerName());
            if (kve != null) {
                kve.applyToResponse(response);
                return CompletableFuture.completedFuture(false);
            }
            SecurityStatus status = this.valUtils.verifySRRset(set, (SRRset)((Object)ke), this.clock.instant());
            if (status != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.authority.positive", new Object[]{set}));
                return CompletableFuture.completedFuture(false);
            }
            if (wcs.size() > 0) {
                if (set.getType() == 47) {
                    nsecs.add(set);
                } else if (set.getType() == 50) {
                    nsec3s.add(set);
                }
            }
            return this.validatePositiveResponseRecursive(response, wcs, nsec3s, nsecs, sections, sectionIndex, setIndex);
        });
    }

    private CompletionStage<Boolean> validateAnswerAndGetWildcards(SMessage response, int qtype, Map<Name, Name> wcs) {
        return this.validateAnswerAndGetWildcardsRecursive(response, qtype, wcs, new AtomicInteger(0));
    }

    private CompletionStage<Boolean> validateAnswerAndGetWildcardsRecursive(SMessage response, int qtype, Map<Name, Name> wcs, AtomicInteger setIndex) {
        List<SRRset> sectionRRsets = response.getSectionRRsets(1);
        if (setIndex.get() >= sectionRRsets.size()) {
            return CompletableFuture.completedFuture(true);
        }
        SRRset set = sectionRRsets.get(setIndex.get());
        return this.prepareFindKey(set).thenCompose(ke -> {
            Name wc;
            JustifiedSecStatus kve = ke.validateKeyFor(set.getSignerName());
            if (kve != null) {
                kve.applyToResponse(response);
                return CompletableFuture.completedFuture(false);
            }
            SecurityStatus status = this.valUtils.verifySRRset(set, (SRRset)((Object)ke), this.clock.instant());
            if (status != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.answer.positive", new Object[]{set}));
                return CompletableFuture.completedFuture(false);
            }
            try {
                wc = ValUtils.rrsetWildcard(set);
            }
            catch (RuntimeException ex) {
                response.setBogus(R.get(ex.getMessage(), set.getName()));
                return CompletableFuture.completedFuture(false);
            }
            if (wc != null) {
                if (set.getType() == 39) {
                    response.setBogus(R.get("failed.dname.wildcard", set.getName()));
                    return CompletableFuture.completedFuture(false);
                }
                wcs.put(set.getName(), wc);
            }
            if (qtype != 39 && set.getType() == 39) {
                SRRset cnameSet;
                DNAMERecord dname = (DNAMERecord)set.first();
                if (setIndex.getAndIncrement() < sectionRRsets.size() && (cnameSet = (SRRset)((Object)((Object)sectionRRsets.get(setIndex.get())))).getType() == 5 && dname != null) {
                    if (cnameSet.size() > 1) {
                        response.setBogus(R.get("failed.synthesize.multiple", new Object[0]));
                        return CompletableFuture.completedFuture(false);
                    }
                    CNAMERecord cname = (CNAMERecord)cnameSet.first();
                    try {
                        Name expected = Name.concatenate((Name)cname.getName().relativize(dname.getName()), (Name)dname.getTarget());
                        if (!expected.equals((Object)cname.getTarget())) {
                            response.setBogus(R.get("failed.synthesize.nomatch", cname.getTarget(), expected));
                            return CompletableFuture.completedFuture(false);
                        }
                    }
                    catch (NameTooLongException e) {
                        response.setBogus(R.get("failed.synthesize.toolong", new Object[0]));
                        return CompletableFuture.completedFuture(false);
                    }
                    cnameSet.setSecurityStatus(SecurityStatus.SECURE);
                }
            }
            setIndex.getAndIncrement();
            return this.validateAnswerAndGetWildcardsRecursive(response, qtype, wcs, setIndex);
        });
    }

    private CompletionStage<Void> validateNodataResponse(Message request, SMessage response) {
        Name intermediateQname = request.getQuestion().getName();
        int qtype = request.getQuestion().getType();
        for (SRRset set : response.getSectionRRsets(1)) {
            if (set.getSecurityStatus() != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.answer.cname_nodata", set.getName()));
                return CompletableFuture.completedFuture(null);
            }
            if (set.getType() != 5) continue;
            intermediateQname = ((CNAMERecord)set.first()).getTarget();
        }
        Name qname = intermediateQname;
        return this.validateNodataResponseRecursive(response, new AtomicInteger(0)).handleAsync((result, ex) -> {
            if (ex != null) {
                return null;
            }
            boolean hasValidNSEC = false;
            Name ce = null;
            ValUtils.NsecProvesNodataResponse ndp = new ValUtils.NsecProvesNodataResponse();
            ArrayList<SRRset> nsec3s = new ArrayList<SRRset>(0);
            Name nsec3Signer = null;
            for (SRRset set : response.getSectionRRsets(2)) {
                if (set.getType() == 47) {
                    NSECRecord nsec = (NSECRecord)set.first();
                    ndp = ValUtils.nsecProvesNodata(set, nsec, qname, qtype);
                    if (ndp.result) {
                        hasValidNSEC = true;
                    }
                    if (ValUtils.nsecProvesNameError(set, nsec, qname)) {
                        ce = ValUtils.closestEncloser(qname, set.getName(), nsec.getNext());
                    }
                }
                if (set.getType() != 50) continue;
                nsec3s.add(set);
                nsec3Signer = set.getSignerName();
            }
            if (ndp.wc != null && (ce == null || !ce.equals((Object)ndp.wc) && !qname.equals(ce))) {
                hasValidNSEC = false;
            }
            this.n3valUtils.stripUnknownAlgNSEC3s(nsec3s);
            if (!hasValidNSEC && nsec3s.size() > 0) {
                logger.debug("Validating nodata: using NSEC3 records");
                if (this.n3valUtils.allNSEC3sIgnoreable(nsec3s, this.keyCache)) {
                    response.setStatus(SecurityStatus.BOGUS, R.get("failed.nsec3_ignored", new Object[0]));
                    return null;
                }
                SecurityStatus status = this.n3valUtils.proveNodata(nsec3s, qname, qtype, nsec3Signer);
                if (status == SecurityStatus.INSECURE) {
                    response.setStatus(SecurityStatus.INSECURE);
                    return null;
                }
                boolean bl = hasValidNSEC = status == SecurityStatus.SECURE;
            }
            if (!hasValidNSEC) {
                response.setBogus(R.get("failed.nodata", new Object[0]));
                logger.trace("Failed NODATA for " + qname);
                return null;
            }
            logger.trace("successfully validated NODATA response");
            response.setStatus(SecurityStatus.SECURE);
            return null;
        });
    }

    private CompletionStage<Void> validateNodataResponseRecursive(SMessage response, AtomicInteger setIndex) {
        if (setIndex.get() >= response.getSectionRRsets(2).size()) {
            return CompletableFuture.completedFuture(null);
        }
        SRRset set = response.getSectionRRsets(2).get(setIndex.getAndIncrement());
        return this.prepareFindKey(set).thenComposeAsync(ke -> {
            JustifiedSecStatus kve = ke.validateKeyFor(set.getSignerName());
            if (kve != null) {
                kve.applyToResponse(response);
                return this.failedFuture(new Exception(kve.reason));
            }
            SecurityStatus status = this.valUtils.verifySRRset(set, (SRRset)((Object)ke), this.clock.instant());
            if (status != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.authority.nodata", new Object[]{set}));
                return this.failedFuture(new Exception("failed.authority.nodata"));
            }
            return this.validateNodataResponseRecursive(response, setIndex);
        });
    }

    private <T> CompletionStage<T> failedFuture(Throwable e) {
        CompletableFuture f = new CompletableFuture();
        f.completeExceptionally(e);
        return f;
    }

    private CompletionStage<Void> validateNameErrorResponse(Message request, SMessage response) {
        Name intermediateQname = request.getQuestion().getName();
        for (SRRset set : response.getSectionRRsets(1)) {
            if (set.getSecurityStatus() != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.nxdomain.cname_nxdomain", new Object[]{set}));
                return CompletableFuture.completedFuture(null);
            }
            if (set.getType() != 5) continue;
            intermediateQname = ((CNAMERecord)set.first()).getTarget();
        }
        Name qname = intermediateQname;
        return this.validateNameErrorResponseRecursive(response, new AtomicInteger(0)).thenComposeAsync(v -> {
            boolean hasValidNSEC = false;
            boolean hasValidWCNSEC = false;
            ArrayList<SRRset> nsec3s = new ArrayList<SRRset>(0);
            Name nsec3Signer = null;
            int previousClosestEncloseLabels = 0;
            for (SRRset set : response.getSectionRRsets(2)) {
                if (set.getType() == 47) {
                    NSECRecord nsec = (NSECRecord)set.first();
                    if (ValUtils.nsecProvesNameError(set, nsec, qname)) {
                        hasValidNSEC = true;
                    }
                    Name next = nsec.getNext();
                    int closestEncloserLabels = ValUtils.closestEncloser(qname, set.getName(), next).labels();
                    if (closestEncloserLabels > previousClosestEncloseLabels || closestEncloserLabels == previousClosestEncloseLabels && !hasValidWCNSEC) {
                        hasValidWCNSEC = ValUtils.nsecProvesNoWC(set, nsec, qname);
                    }
                    previousClosestEncloseLabels = closestEncloserLabels;
                }
                if (set.getType() != 50) continue;
                nsec3s.add(set);
                nsec3Signer = set.getSignerName();
            }
            this.n3valUtils.stripUnknownAlgNSEC3s(nsec3s);
            if (!(hasValidNSEC && hasValidWCNSEC || nsec3s.size() <= 0)) {
                logger.debug("Validating nxdomain: using NSEC3 records");
                if (this.n3valUtils.allNSEC3sIgnoreable(nsec3s, this.keyCache)) {
                    response.setStatus(SecurityStatus.INSECURE, R.get("failed.nsec3_ignored", new Object[0]));
                    return CompletableFuture.completedFuture(null);
                }
                SecurityStatus status = this.n3valUtils.proveNameError(nsec3s, qname, nsec3Signer);
                if (status != SecurityStatus.SECURE) {
                    if (status == SecurityStatus.INSECURE) {
                        response.setStatus(status, R.get("failed.nxdomain.nsec3_insecure", new Object[0]));
                    } else {
                        response.setStatus(status, R.get("failed.nxdomain.nsec3_bogus", new Object[0]));
                    }
                    return CompletableFuture.completedFuture(null);
                }
                hasValidNSEC = true;
                hasValidWCNSEC = true;
            }
            if (!hasValidNSEC || !hasValidWCNSEC) {
                boolean hasValidNSEC2 = hasValidNSEC;
                return this.validateNodataResponse(request, response).thenRun(() -> {
                    if (response.getStatus() == SecurityStatus.SECURE) {
                        response.getHeader().setRcode(0);
                    } else {
                        if (!hasValidNSEC2) {
                            response.setBogus(R.get("failed.nxdomain.exists", response.getQuestion().getName()));
                            return;
                        }
                        response.setBogus(R.get("failed.nxdomain.haswildcard", new Object[0]));
                    }
                });
            }
            logger.trace("successfully validated NAME ERROR response.");
            response.setStatus(SecurityStatus.SECURE);
            return CompletableFuture.completedFuture(null);
        }).exceptionally(ex -> null);
    }

    private CompletionStage<Void> validateNameErrorResponseRecursive(SMessage response, AtomicInteger setIndex) {
        if (setIndex.get() >= response.getSectionRRsets(2).size()) {
            return CompletableFuture.completedFuture(null);
        }
        SRRset set = response.getSectionRRsets(2).get(setIndex.getAndIncrement());
        return this.prepareFindKey(set).thenCompose(ke -> {
            JustifiedSecStatus kve = ke.validateKeyFor(set.getSignerName());
            if (kve != null) {
                kve.applyToResponse(response);
                return this.failedFuture(new Exception(kve.reason));
            }
            SecurityStatus status = this.valUtils.verifySRRset(set, (SRRset)((Object)ke), this.clock.instant());
            if (status != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.nxdomain.authority", new Object[]{set}));
                return this.failedFuture(new Exception("failed.nxdomain.authority"));
            }
            return this.validateNameErrorResponseRecursive(response, setIndex);
        });
    }

    private CompletionStage<SMessage> sendRequest(Message request) {
        Record q = request.getQuestion();
        logger.trace("sending request: <" + q.getName() + "/" + Type.string((int)q.getType()) + "/" + DClass.string((int)q.getDClass()) + ">");
        Message localRequest = request.clone();
        localRequest.getHeader().setFlag(11);
        return this.headResolver.sendAsync(localRequest).thenApply(SMessage::new);
    }

    private CompletionStage<KeyEntry> prepareFindKey(SRRset rrset) {
        SRRset trustAnchorRRset;
        FindKeyState state = new FindKeyState();
        state.signerName = rrset.getSignerName();
        state.qclass = rrset.getDClass();
        if (state.signerName == null) {
            state.signerName = rrset.getName();
        }
        if ((trustAnchorRRset = this.trustAnchors.find(state.signerName, rrset.getDClass())) == null) {
            KeyEntry ke = KeyEntry.newNullKeyEntry(state.signerName, rrset.getDClass(), 60L);
            return CompletableFuture.completedFuture(ke);
        }
        state.keyEntry = this.keyCache.find(state.signerName, rrset.getDClass());
        if (state.keyEntry == null || !state.keyEntry.getName().equals((Object)state.signerName) && state.keyEntry.isGood()) {
            state.dsRRset = trustAnchorRRset;
            state.keyEntry = null;
            state.currentDSKeyName = new Name(trustAnchorRRset.getName(), 1);
            return this.processFindKey(state).thenApply(v -> state.keyEntry);
        }
        return CompletableFuture.completedFuture(state.keyEntry);
    }

    private CompletionStage<Void> processFindKey(FindKeyState state) {
        int currentLabels;
        int targetLabels;
        int l;
        int qclass = state.qclass;
        Name targetKeyName = state.signerName;
        Name currentKeyName = Name.empty;
        if (state.keyEntry != null) {
            currentKeyName = state.keyEntry.getName();
        }
        if (state.currentDSKeyName != null) {
            currentKeyName = state.currentDSKeyName;
            state.currentDSKeyName = null;
        }
        if (currentKeyName.equals((Object)targetKeyName)) {
            return CompletableFuture.completedFuture(null);
        }
        if (state.emptyDSName != null) {
            currentKeyName = state.emptyDSName;
        }
        if ((l = (targetLabels = targetKeyName.labels()) - (currentLabels = currentKeyName.labels()) - 1) < 0) {
            return CompletableFuture.completedFuture(null);
        }
        Name nextKeyName = new Name(targetKeyName, l);
        logger.trace("findKey: targetKeyName = " + targetKeyName + ", currentKeyName = " + currentKeyName + ", nextKeyName = " + nextKeyName);
        if (state.dsRRset == null || !state.dsRRset.getName().equals((Object)nextKeyName)) {
            Message dsRequest = Message.newQuery((Record)Record.newRecord((Name)nextKeyName, (int)43, (int)qclass));
            return this.sendRequest(dsRequest).thenComposeAsync(dsResponse -> this.processDSResponse(dsRequest, (SMessage)dsResponse, state));
        }
        Message dnskeyRequest = Message.newQuery((Record)Record.newRecord((Name)state.dsRRset.getName(), (int)48, (int)qclass));
        return this.sendRequest(dnskeyRequest).thenComposeAsync(dnskeyResponse -> this.processDNSKEYResponse(dnskeyRequest, (SMessage)dnskeyResponse, state));
    }

    private KeyEntry dsResponseToKE(SMessage response, Message request, SRRset keyRrset) {
        Name qname = request.getQuestion().getName();
        int qclass = request.getQuestion().getDClass();
        ResponseClassification subtype = ValUtils.classifyResponse(request, response);
        KeyEntry bogusKE = KeyEntry.newBadKeyEntry(qname, qclass, 60L);
        switch (subtype) {
            case POSITIVE: {
                SRRset dsRrset = response.findAnswerRRset(qname, 43, qclass);
                SecurityStatus status = this.valUtils.verifySRRset(dsRrset, keyRrset, this.clock.instant());
                if (status != SecurityStatus.SECURE) {
                    bogusKE.setBadReason(R.get("failed.ds", new Object[0]));
                    return bogusKE;
                }
                if (!this.valUtils.atLeastOneSupportedAlgorithm(dsRrset)) {
                    KeyEntry nullKey = KeyEntry.newNullKeyEntry(qname, qclass, dsRrset.getTTL());
                    nullKey.setBadReason(R.get("insecure.ds.noalgorithms", qname));
                    return nullKey;
                }
                logger.trace("DS rrset was good.");
                return KeyEntry.newKeyEntry(dsRrset);
            }
            case CNAME: {
                SRRset cnameRrset = response.findAnswerRRset(qname, 5, qclass);
                SecurityStatus status = this.valUtils.verifySRRset(cnameRrset, keyRrset, this.clock.instant());
                if (status == SecurityStatus.SECURE) {
                    return null;
                }
                bogusKE.setBadReason(R.get("failed.ds.cname", new Object[0]));
                return bogusKE;
            }
            case NODATA: 
            case NAMEERROR: {
                return this.dsReponseToKeForNodata(response, request, keyRrset);
            }
        }
        bogusKE.setBadReason(R.get("failed.ds.notype", new Object[]{subtype}));
        return bogusKE;
    }

    private KeyEntry dsReponseToKeForNodata(SMessage response, Message request, SRRset keyRrset) {
        Name qname = request.getQuestion().getName();
        int qclass = request.getQuestion().getDClass();
        KeyEntry bogusKE = KeyEntry.newBadKeyEntry(qname, qclass, 60L);
        if (!this.valUtils.hasSignedNsecs(response)) {
            bogusKE.setBadReason(R.get("failed.ds.nonsec", qname));
            return bogusKE;
        }
        JustifiedSecStatus status = this.valUtils.nsecProvesNodataDsReply(request, response, keyRrset, this.clock.instant());
        switch (status.status) {
            case SECURE: {
                KeyEntry nullKey = KeyEntry.newNullKeyEntry(qname, qclass, 60L);
                nullKey.setBadReason(R.get("insecure.ds.nsec", new Object[0]));
                return nullKey;
            }
            case INSECURE: {
                return null;
            }
            case BOGUS: {
                bogusKE.setBadReason(status.reason);
                return bogusKE;
            }
        }
        List<SRRset> nsec3Rrsets = response.getSectionRRsets(2, 50);
        ArrayList<SRRset> nsec3s = new ArrayList<SRRset>(0);
        Name nsec3Signer = null;
        long nsec3TTL = -1L;
        if (!nsec3Rrsets.isEmpty()) {
            for (SRRset nsec3set : nsec3Rrsets) {
                SecurityStatus sstatus = this.valUtils.verifySRRset(nsec3set, keyRrset, this.clock.instant());
                if (sstatus != SecurityStatus.SECURE) {
                    logger.debug("skipping bad nsec3");
                    continue;
                }
                nsec3Signer = nsec3set.getSignerName();
                if (nsec3TTL < 0L || nsec3set.getTTL() < nsec3TTL) {
                    nsec3TTL = nsec3set.getTTL();
                }
                nsec3s.add(nsec3set);
            }
            switch (this.n3valUtils.proveNoDS(nsec3s, qname, nsec3Signer)) {
                case SECURE: 
                case INSECURE: {
                    KeyEntry nullKey = KeyEntry.newNullKeyEntry(qname, qclass, nsec3TTL);
                    nullKey.setBadReason(R.get("insecure.ds.nsec3", new Object[0]));
                    return nullKey;
                }
                case INDETERMINATE: {
                    logger.debug("nsec3s for the referral proved no delegation.");
                    return null;
                }
                case BOGUS: {
                    bogusKE.setBadReason(R.get("failed.ds.nsec3", new Object[0]));
                    return bogusKE;
                }
            }
            bogusKE.setBadReason(R.get("unknown.ds.nsec3", new Object[0]));
            return bogusKE;
        }
        bogusKE.setBadReason(R.get("failed.ds.unknown", new Object[0]));
        return bogusKE;
    }

    private CompletionStage<Void> processDSResponse(Message request, SMessage response, FindKeyState state) {
        Name qname = request.getQuestion().getName();
        state.emptyDSName = null;
        state.dsRRset = null;
        KeyEntry dsKE = this.dsResponseToKE(response, request, state.keyEntry);
        if (dsKE == null) {
            state.emptyDSName = qname;
        } else if (dsKE.isGood()) {
            state.dsRRset = dsKE;
            state.currentDSKeyName = new Name(dsKE.getName(), 1);
        } else {
            state.keyEntry = dsKE;
            if (dsKE.isNull()) {
                this.keyCache.store(dsKE);
            }
            return CompletableFuture.completedFuture(null);
        }
        return this.processFindKey(state);
    }

    private CompletionStage<Void> processDNSKEYResponse(Message request, SMessage response, FindKeyState state) {
        int qclass;
        Name qname = request.getQuestion().getName();
        SRRset dnskeyRrset = response.findAnswerRRset(qname, 48, qclass = request.getQuestion().getDClass());
        if (dnskeyRrset == null) {
            state.keyEntry = KeyEntry.newBadKeyEntry(qname, qclass, 60L);
            state.keyEntry.setBadReason(R.get("dnskey.no_rrset", qname));
            return CompletableFuture.completedFuture(null);
        }
        state.keyEntry = this.valUtils.verifyNewDNSKEYs(dnskeyRrset, state.dsRRset, 60L, this.clock.instant());
        if (!state.keyEntry.isGood()) {
            return CompletableFuture.completedFuture(null);
        }
        this.keyCache.store(state.keyEntry);
        return this.processFindKey(state);
    }

    private CompletionStage<SMessage> processValidate(Message request, SMessage response) {
        CompletionStage<Void> completionStage;
        ResponseClassification subtype = ValUtils.classifyResponse(request, response);
        if (subtype != ResponseClassification.REFERRAL) {
            this.removeSpuriousAuthority(response);
        }
        switch (subtype) {
            case POSITIVE: 
            case CNAME: 
            case ANY: {
                logger.trace("Validating a positive response");
                completionStage = this.validatePositiveResponse(request, response);
                break;
            }
            case NODATA: {
                logger.trace("Validating a nodata response");
                completionStage = this.validateNodataResponse(request, response);
                break;
            }
            case CNAME_NODATA: {
                logger.trace("Validating a CNAME_NODATA response");
                completionStage = this.validatePositiveResponse(request, response).thenCompose(v -> {
                    if (response.getStatus() != SecurityStatus.INSECURE) {
                        response.setStatus(SecurityStatus.UNCHECKED);
                        return this.validateNodataResponse(request, response);
                    }
                    return CompletableFuture.completedFuture(null);
                });
                break;
            }
            case NAMEERROR: {
                logger.trace("Validating a nxdomain response");
                completionStage = this.validateNameErrorResponse(request, response);
                break;
            }
            case CNAME_NAMEERROR: {
                logger.trace("Validating a cname_nxdomain response");
                completionStage = this.validatePositiveResponse(request, response).thenCompose(v -> {
                    if (response.getStatus() != SecurityStatus.INSECURE) {
                        response.setStatus(SecurityStatus.UNCHECKED);
                        return this.validateNameErrorResponse(request, response);
                    }
                    return CompletableFuture.completedFuture(null);
                });
                break;
            }
            default: {
                response.setStatus(SecurityStatus.BOGUS, R.get("validate.response.unknown", new Object[]{subtype}));
                completionStage = CompletableFuture.completedFuture(null);
            }
        }
        return completionStage.thenApply(v -> this.processFinishedState(request, response));
    }

    private SMessage processFinishedState(Message request, SMessage response) {
        SecurityStatus status = response.getStatus();
        String reason = response.getBogusReason();
        switch (status) {
            case BOGUS: {
                int code = response.getHeader().getRcode();
                if (code == 0 || code == 3) {
                    code = 2;
                }
                response = ValidatingResolver.errorMessage(request, code);
                break;
            }
            case SECURE: {
                response.getHeader().setFlag(10);
                break;
            }
            case INSECURE: 
            case UNCHECKED: {
                break;
            }
            default: {
                throw new RuntimeException("unexpected security status");
            }
        }
        response.setStatus(status, reason);
        return response;
    }

    public void setPort(int port) {
        this.headResolver.setPort(port);
    }

    public void setTCP(boolean flag) {
        this.headResolver.setTCP(flag);
    }

    public void setIgnoreTruncation(boolean flag) {
    }

    public void setEDNS(int version, int payloadSize, int flags, List<EDNSOption> options) {
        if (version == -1) {
            throw new IllegalArgumentException("EDNS cannot be disabled");
        }
        this.headResolver.setEDNS(version, payloadSize, flags | 0x8000, options);
    }

    public void setTSIGKey(TSIG key) {
        this.headResolver.setTSIGKey(key);
    }

    public Duration getTimeout() {
        return this.headResolver.getTimeout();
    }

    public void setTimeout(Duration duration) {
        this.headResolver.setTimeout(duration);
    }

    public CompletionStage<Message> sendAsync(Message query) {
        return this.sendRequest(query).thenCompose(response -> {
            response.getHeader().unsetFlag(10);
            if (query.getHeader().getFlag(11)) {
                return CompletableFuture.completedFuture(response.getMessage());
            }
            Message rrsigResponse = response.getMessage();
            if (query.getQuestion().getType() == 46 && rrsigResponse.getHeader().getRcode() == 0 && !rrsigResponse.getSectionRRsets(1).isEmpty()) {
                rrsigResponse.getHeader().unsetFlag(10);
                return CompletableFuture.completedFuture(rrsigResponse);
            }
            return this.processValidate(query, (SMessage)response).thenApply(validated -> {
                Message m = validated.getMessage();
                String reason = validated.getBogusReason();
                if (reason != null) {
                    int maxTxtRecordStringLength = 255;
                    String[] parts = new String[reason.length() / 255 + 1];
                    for (int i = 0; i < parts.length; ++i) {
                        int length = Math.min((i + 1) * 255, reason.length());
                        parts[i] = reason.substring(i * 255, length);
                    }
                    m.addRecord((Record)new TXTRecord(Name.root, 65280, 0L, Arrays.asList(parts)), 3);
                }
                return m;
            });
        });
    }

    private static SMessage errorMessage(Message request, int rcode) {
        SMessage m = new SMessage(request.getHeader().getID(), request.getQuestion());
        Header h = m.getHeader();
        h.setRcode(rcode);
        h.setFlag(0);
        return m;
    }
}

