/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.awt.Dimension;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.PlugInManager;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.SourceStream;
import net.sf.fmj.media.BasicPlugIn;
import net.sf.fmj.media.CircularBuffer;
import net.sf.fmj.media.parser.RawStreamParser;
import net.sf.fmj.media.protocol.DelegateDataSource;
import net.sf.fmj.media.rtp.Depacketizer;

public class RawPushBufferParser
extends RawStreamParser {
    static final String NAMEBUFFER = "Raw video/audio buffer stream parser";
    private boolean started = false;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");
    static VideoFormat jpegVideo = new VideoFormat("jpeg/rtp");
    static VideoFormat h261Video = new VideoFormat("h261/rtp");
    static VideoFormat h263Video = new VideoFormat("h263/rtp");
    final int[] h261Widths = new int[]{176, 352};
    final int[] h261Heights = new int[]{144, 288};
    final int[] h263Widths = new int[]{0, 128, 176, 352, 704, 1408, 0, 0};
    final int[] h263Heights = new int[]{0, 96, 144, 288, 576, 1152, 0, 0};
    final float[] MPEGRateTbl = new float[]{0.0f, 23.976f, 24.0f, 25.0f, 29.97f, 30.0f, 50.0f, 59.94f, 60.0f};
    public static int[][] MPASampleTbl = new int[][]{{22050, 24000, 16000, 0}, {44100, 48000, 32000, 0}};

    @Override
    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                for (int i = 0; i < this.tracks.length; ++i) {
                    ((FrameTrack)this.tracks[i]).stop();
                    ((FrameTrack)this.tracks[i]).close();
                }
                this.source.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.source = null;
        }
        this.started = false;
    }

    @Override
    public String getName() {
        return NAMEBUFFER;
    }

    @Override
    public Track[] getTracks() {
        for (int i = 0; i < this.tracks.length; ++i) {
            ((FrameTrack)this.tracks[i]).parse();
        }
        return this.tracks;
    }

    boolean isRTPFormat(Format fmt) {
        return fmt != null && fmt.getEncoding() != null && (fmt.getEncoding().endsWith("rtp") || fmt.getEncoding().endsWith("RTP"));
    }

    @Override
    public void open() {
        if (this.tracks != null) {
            return;
        }
        this.tracks = new Track[this.streams.length];
        for (int i = 0; i < this.streams.length; ++i) {
            this.tracks[i] = new FrameTrack(this, (PushBufferStream)this.streams[i], 1);
        }
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.tracks.length; ++i) {
            ((FrameTrack)this.tracks[i]).reset();
        }
    }

    @Override
    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PushBufferDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        SourceStream[] streams = ((PushBufferDataSource)source).getStreams();
        if (streams == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (streams.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        if (!this.supports(streams)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        this.source = source;
        this.streams = streams;
    }

    @Override
    public void start() throws IOException {
        if (this.started) {
            return;
        }
        for (int i = 0; i < this.tracks.length; ++i) {
            ((FrameTrack)this.tracks[i]).start();
        }
        this.source.start();
        this.started = true;
    }

    @Override
    public void stop() {
        try {
            for (int i = 0; i < this.tracks.length; ++i) {
                ((FrameTrack)this.tracks[i]).stop();
            }
            this.source.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.started = false;
    }

    @Override
    protected boolean supports(SourceStream[] streams) {
        return streams[0] != null && streams[0] instanceof PushBufferStream;
    }

    class FrameTrack
    implements Track,
    BufferTransferHandler {
        Demultiplexer parser;
        PushBufferStream pbs;
        boolean enabled = true;
        final CircularBuffer bufferQ;
        Format format = null;
        TrackListener listener;
        volatile boolean stopped = true;
        volatile boolean closed = false;
        boolean keyFrameFound = false;
        boolean checkDepacketizer = false;
        Depacketizer depacketizer = null;
        Object keyFrameLock = new Object();

        public FrameTrack(Demultiplexer parser, PushBufferStream pbs, int numOfBufs) {
            this.pbs = pbs;
            this.format = pbs.getFormat();
            if (RawPushBufferParser.this.source instanceof DelegateDataSource || !RawPushBufferParser.this.isRTPFormat(this.format)) {
                this.keyFrameFound = true;
            }
            this.bufferQ = new CircularBuffer(numOfBufs);
            pbs.setTransferHandler(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.setEnabled(false);
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.closed = true;
                this.bufferQ.notifyAll();
            }
        }

        private Depacketizer findDepacketizer(String name, Format input) {
            try {
                Class<?> cls = BasicPlugIn.getClassForName(name);
                Object obj = cls.newInstance();
                if (!(obj instanceof Depacketizer)) {
                    return null;
                }
                Depacketizer dpktizer = (Depacketizer)obj;
                if (dpktizer.setInputFormat(input) == null) {
                    return null;
                }
                dpktizer.open();
                return dpktizer;
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
            return null;
        }

        public boolean findH261Key(Buffer b) {
            int skipBytes;
            byte[] data = (byte[])b.getData();
            if (data == null) {
                return false;
            }
            int offset = b.getOffset();
            if (data[offset + (skipBytes = 4)] != 0 || data[offset + skipBytes + 1] != 1 || (data[offset + skipBytes + 2] & 0xFC) != 0) {
                return false;
            }
            int s = data[offset + skipBytes + 3] >> 3 & 1;
            int width = RawPushBufferParser.this.h261Widths[s];
            int height = RawPushBufferParser.this.h261Heights[s];
            this.format = new VideoFormat("h261/rtp", new Dimension(width, height), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            b.setFormat(this.format);
            return true;
        }

        public boolean findH263_1998Key(Buffer b) {
            int s = -1;
            int picOffset = -1;
            byte[] data = (byte[])b.getData();
            if (data == null) {
                return false;
            }
            int offset = b.getOffset();
            int payloadLen = 2 + ((data[offset] & 1) << 5 | (data[offset + 1] & 0xF8) >> 3);
            if ((data[offset] & 2) != 0) {
                ++payloadLen;
            }
            picOffset = -1;
            if (payloadLen > 5) {
                if ((data[offset] & 2) == 2 && (data[offset + 3] & 0xFC) == 128) {
                    picOffset = offset + 3;
                } else if ((data[offset + 2] & 0xFC) == 128) {
                    picOffset = offset + 2;
                }
            } else if ((data[offset] & 4) == 4 && (data[offset + payloadLen] & 0xFC) == 128) {
                picOffset = offset + payloadLen;
            }
            if (picOffset < 0) {
                return false;
            }
            s = data[picOffset + 2] >> 2 & 7;
            if (s == 7) {
                if ((data[picOffset + 3] >> 1 & 7) == 1) {
                    s = data[picOffset + 3] << 2 & 4 | data[picOffset + 4] >> 6 & 3;
                } else {
                    return false;
                }
            }
            if (s < 0) {
                return false;
            }
            int width = RawPushBufferParser.this.h263Widths[s];
            int height = RawPushBufferParser.this.h263Heights[s];
            this.format = new VideoFormat("h263-1998/rtp", new Dimension(width, height), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            b.setFormat(this.format);
            return true;
        }

        public boolean findH263Key(Buffer b) {
            byte[] data = (byte[])b.getData();
            if (data == null) {
                return false;
            }
            int payloadLen = this.getH263PayloadHeaderLength(data, b.getOffset());
            int offset = b.getOffset();
            if (data[offset + payloadLen] != 0 || data[offset + payloadLen + 1] != 0 || (data[offset + payloadLen + 2] & 0xFC) != 128) {
                return false;
            }
            int s = data[offset + payloadLen + 4] >> 2 & 7;
            int width = RawPushBufferParser.this.h263Widths[s];
            int height = RawPushBufferParser.this.h263Heights[s];
            this.format = new VideoFormat("h263/rtp", new Dimension(width, height), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            b.setFormat(this.format);
            return true;
        }

        public boolean findJPEGKey(Buffer b) {
            if ((b.getFlags() & 0x800) == 0) {
                return false;
            }
            byte[] data = (byte[])b.getData();
            int width = (data[b.getOffset() + 6] & 0xFF) * 8;
            int height = (data[b.getOffset() + 7] & 0xFF) * 8;
            this.format = new VideoFormat("jpeg/rtp", new Dimension(width, height), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            b.setFormat(this.format);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean findKeyFrame(Buffer buf) {
            Format fmt;
            if (!this.checkDepacketizer) {
                Vector pnames = PlugInManager.getPlugInList(buf.getFormat(), null, 6);
                if (pnames.size() != 0) {
                    this.depacketizer = this.findDepacketizer((String)pnames.elementAt(0), buf.getFormat());
                }
                this.checkDepacketizer = true;
            }
            if ((fmt = buf.getFormat()) == null) {
                return false;
            }
            if (fmt.getEncoding() == null) {
                Object object = this.keyFrameLock;
                synchronized (object) {
                    this.keyFrameFound = true;
                    this.keyFrameLock.notifyAll();
                }
                return true;
            }
            boolean rtn = true;
            if (jpegVideo.matches(fmt)) {
                rtn = this.findJPEGKey(buf);
            } else if (h261Video.matches(fmt)) {
                rtn = this.findH261Key(buf);
            } else if (h263Video.matches(fmt)) {
                rtn = this.findH263Key(buf);
            } else if (mpegVideo.matches(fmt)) {
                rtn = this.findMPEGKey(buf);
            } else if (mpegAudio.matches(fmt)) {
                rtn = this.findMPAKey(buf);
            } else if (this.depacketizer != null) {
                fmt = this.depacketizer.parse(buf);
                if (fmt != null) {
                    this.format = fmt;
                    buf.setFormat(this.format);
                    this.depacketizer.close();
                    this.depacketizer = null;
                } else {
                    rtn = false;
                }
            }
            if (rtn) {
                Object object = this.keyFrameLock;
                synchronized (object) {
                    this.keyFrameFound = true;
                    this.keyFrameLock.notifyAll();
                }
            }
            return this.keyFrameFound;
        }

        public boolean findMPAKey(Buffer b) {
            byte[] data = (byte[])b.getData();
            if (data == null) {
                return false;
            }
            int off = b.getOffset();
            if (b.getLength() < 8) {
                return false;
            }
            if (data[off + 2] != 0 || data[off + 3] != 0) {
                return false;
            }
            if ((data[off += 4] & 0xFF) != 255 || (data[off + 1] & 0xF6) <= 240 || (data[off + 2] & 0xF0) == 240 || (data[off + 2] & 0xC) == 12 || (data[off + 3] & 3) == 2) {
                return false;
            }
            int id = data[off + 1] >> 3 & 1;
            int six = data[off + 2] >> 2 & 3;
            int channels = (data[off + 3] >> 6 & 3) == 3 ? 1 : 2;
            double sampleRate = MPASampleTbl[id][six];
            this.format = new AudioFormat("mpegaudio/rtp", sampleRate, 16, channels, 0, 1);
            b.setFormat(this.format);
            return true;
        }

        public boolean findMPEGKey(Buffer b) {
            byte[] data = (byte[])b.getData();
            if (data == null) {
                return false;
            }
            int off = b.getOffset();
            if (b.getLength() < 12) {
                return false;
            }
            if ((data[off + 2] & 0x20) != 32) {
                return false;
            }
            if (data[off + 4] != 0 || data[off + 5] != 0 || data[off + 6] != 1 || (data[off + 7] & 0xFF) != 179) {
                return false;
            }
            int frix = data[off + 11] & 0xF;
            if (frix == 0 || frix > 8) {
                return false;
            }
            int width = (data[off + 8] & 0xFF) << 4 | (data[off + 9] & 0xF0) >> 4;
            int height = (data[off + 9] & 0xF) << 8 | data[off + 10] & 0xFF;
            float frameRate = RawPushBufferParser.this.MPEGRateTbl[frix];
            this.format = new VideoFormat("mpeg/rtp", new Dimension(width, height), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), frameRate);
            b.setFormat(this.format);
            return true;
        }

        @Override
        public Time getDuration() {
            return this.parser.getDuration();
        }

        @Override
        public Format getFormat() {
            return this.format;
        }

        int getH263PayloadHeaderLength(byte[] input, int offset) {
            int l = 0;
            byte b = input[offset];
            l = (b & 0x80) != 0 ? ((b & 0x40) != 0 ? 12 : 8) : 4;
            return l;
        }

        @Override
        public Time getStartTime() {
            return new Time(0L);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public Time mapFrameToTime(int frameNumber) {
            return new Time(0L);
        }

        @Override
        public int mapTimeToFrame(Time t) {
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse() {
            try {
                Object object = this.keyFrameLock;
                synchronized (object) {
                    while (!this.keyFrameFound) {
                        this.keyFrameLock.wait();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readFrame(Buffer buffer) {
            Buffer filled;
            if (this.stopped) {
                buffer.setDiscard(true);
                buffer.setFormat(this.format);
                return;
            }
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (!this.bufferQ.canRead()) {
                    try {
                        this.bufferQ.wait();
                        if (!this.stopped) continue;
                        buffer.setDiscard(true);
                        buffer.setFormat(this.format);
                        return;
                    }
                    catch (Exception exception) {
                    }
                }
                filled = this.bufferQ.read();
            }
            Object hdr = buffer.getHeader();
            buffer.copy(filled, true);
            filled.setHeader(hdr);
            this.format = filled.getFormat();
            CircularBuffer circularBuffer2 = this.bufferQ;
            synchronized (circularBuffer2) {
                this.bufferQ.readReport();
                this.bufferQ.notifyAll();
            }
        }

        public void reset() {
        }

        @Override
        public void setEnabled(boolean t) {
            if (t) {
                this.pbs.setTransferHandler(this);
            } else {
                this.pbs.setTransferHandler(null);
            }
            this.enabled = t;
        }

        @Override
        public void setTrackListener(TrackListener l) {
            this.listener = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.stopped = false;
                if (RawPushBufferParser.this.source instanceof CaptureDevice) {
                    while (this.bufferQ.canRead()) {
                        this.bufferQ.read();
                        this.bufferQ.readReport();
                    }
                }
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.stopped = true;
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transferData(PushBufferStream pbs) {
            Buffer buffer;
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (!(this.bufferQ.canWrite() || this.closed || this.stopped)) {
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception exception) {}
                }
                if (this.closed || this.stopped) {
                    return;
                }
                buffer = this.bufferQ.getEmptyBuffer();
            }
            try {
                pbs.read(buffer);
            }
            catch (IOException e) {
                buffer.setDiscard(true);
            }
            if (!this.keyFrameFound && !this.findKeyFrame(buffer)) {
                circularBuffer = this.bufferQ;
                synchronized (circularBuffer) {
                    this.bufferQ.writeReport();
                    this.bufferQ.read();
                    this.bufferQ.readReport();
                }
                return;
            }
            circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.bufferQ.writeReport();
                this.bufferQ.notifyAll();
            }
        }
    }
}

