/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.net.InetAddress;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.rtp.RTCPTransmitter;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.util.RTPMediaThread;

public class RTCPReporter
implements Runnable {
    private static final Logger logger = Logger.getLogger(RTCPReporter.class.getName());
    RTCPTransmitter transmit;
    SSRCCache cache;
    RTPMediaThread reportthread;
    Random myrand;
    boolean restart = false;
    boolean closed = false;
    InetAddress host;
    String cname;

    public RTCPReporter(SSRCCache cache, RTCPTransmitter t) {
        this.cache = cache;
        this.setTransmitter(t);
        this.reportthread = new RTPMediaThread(this, "RTCP Reporter");
        this.reportthread.useControlPriority();
        this.reportthread.setDaemon(true);
        this.reportthread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason) {
        RTPMediaThread rTPMediaThread = this.reportthread;
        synchronized (rTPMediaThread) {
            this.closed = true;
            this.reportthread.notifyAll();
        }
        this.releasessrc(reason);
        this.transmit.close();
    }

    public void releasessrc(String reason) {
        this.transmit.bye(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.restart) {
            this.restart = false;
        }
        while (true) {
            double delay = this.cache.calcReportInterval(this.cache.ourssrc.sender, false);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("RTCP reporting for " + "running again after " + delay + " ms.");
            }
            RTPMediaThread rTPMediaThread = this.reportthread;
            synchronized (rTPMediaThread) {
                try {
                    this.reportthread.wait((long)delay);
                }
                catch (InterruptedException e) {
                    Log.dumpStack(e);
                }
            }
            if (this.closed) {
                return;
            }
            if (!this.restart) {
                this.transmit.report();
                continue;
            }
            this.restart = false;
        }
    }

    public void setTransmitter(RTCPTransmitter t) {
        this.transmit = t;
    }
}

