/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkUtils {
    private static final Logger logger = Logger.getLogger(NetworkUtils.class.getName());
    public static final String IN6_ADDR_ANY = "::0";
    private static final int IN6_ADDR_SIZE = 16;
    private static final int IN6_ADDR_TOKEN_SIZE = 2;
    public static final String IN4_ADDR_ANY = "0.0.0.0";
    private static final int IN4_ADDR_SIZE = 4;
    public static final String IN_ADDR_ANY = NetworkUtils.determineAnyAddress();
    public static final int MAX_PORT_NUMBER = 65535;
    public static final int MIN_PORT_NUMBER = 1024;
    private static Random portNumberGenerator = new Random();

    public static boolean isWindowsAutoConfiguredIPv4Address(InetAddress add) {
        return (add.getAddress()[0] & 0xFF) == 169 && (add.getAddress()[1] & 0xFF) == 254;
    }

    public static int getRandomPortNumber() {
        return NetworkUtils.getRandomPortNumber(1024, 65535);
    }

    public static int getRandomPortNumber(int min, int max) {
        return portNumberGenerator.nextInt(max - min + 1) + min;
    }

    public static boolean isIPv4Address(String address) {
        return NetworkUtils.strToIPv4(address) != null;
    }

    public static boolean isIPv6Address(String address) {
        return NetworkUtils.strToIPv6(address) != null;
    }

    public static boolean isValidIPAddress(String address) {
        if (address == null || address.length() == 0) {
            return false;
        }
        boolean ipv6Expected = false;
        if (address.charAt(0) == '[') {
            if (address.length() > 2 && address.charAt(address.length() - 1) == ']') {
                address = address.substring(1, address.length() - 1);
                ipv6Expected = true;
            } else {
                return false;
            }
        }
        if (Character.digit(address.charAt(0), 16) != -1 || address.charAt(0) == ':') {
            byte[] addr = null;
            addr = NetworkUtils.strToIPv4(address);
            if (addr == null) {
                addr = NetworkUtils.strToIPv6(address);
            } else if (ipv6Expected) {
                return false;
            }
            if (addr != null) {
                return true;
            }
        }
        return false;
    }

    public static byte[] strToIPv4(String ipv4AddrStr) {
        if (ipv4AddrStr.length() == 0) {
            return null;
        }
        byte[] address = new byte[4];
        String[] tokens = ipv4AddrStr.split("\\.", -1);
        try {
            switch (tokens.length) {
                case 1: {
                    long currentTkn = Long.parseLong(tokens[0]);
                    if (currentTkn < 0L || currentTkn > 0xFFFFFFFFL) {
                        return null;
                    }
                    address[0] = (byte)(currentTkn >> 24 & 0xFFL);
                    address[1] = (byte)((currentTkn & 0xFFFFFFL) >> 16 & 0xFFL);
                    address[2] = (byte)((currentTkn & 0xFFFFL) >> 8 & 0xFFL);
                    address[3] = (byte)(currentTkn & 0xFFL);
                    break;
                }
                case 2: {
                    long currentTkn = Integer.parseInt(tokens[0]);
                    if (currentTkn < 0L || currentTkn > 255L) {
                        return null;
                    }
                    address[0] = (byte)(currentTkn & 0xFFL);
                    currentTkn = Integer.parseInt(tokens[1]);
                    if (currentTkn < 0L || currentTkn > 0xFFFFFFL) {
                        return null;
                    }
                    address[1] = (byte)(currentTkn >> 16 & 0xFFL);
                    address[2] = (byte)((currentTkn & 0xFFFFL) >> 8 & 0xFFL);
                    address[3] = (byte)(currentTkn & 0xFFL);
                    break;
                }
                case 3: {
                    long currentTkn;
                    for (int i = 0; i < 2; ++i) {
                        currentTkn = Integer.parseInt(tokens[i]);
                        if (currentTkn < 0L || currentTkn > 255L) {
                            return null;
                        }
                        address[i] = (byte)(currentTkn & 0xFFL);
                    }
                    currentTkn = Integer.parseInt(tokens[2]);
                    if (currentTkn < 0L || currentTkn > 65535L) {
                        return null;
                    }
                    address[2] = (byte)(currentTkn >> 8 & 0xFFL);
                    address[3] = (byte)(currentTkn & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long currentTkn = Integer.parseInt(tokens[i]);
                        if (currentTkn < 0L || currentTkn > 255L) {
                            return null;
                        }
                        address[i] = (byte)(currentTkn & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return address;
    }

    public static byte[] strToIPv6(String ipv6AddrStr) {
        if (ipv6AddrStr.length() < 2) {
            return null;
        }
        char[] addrBuff = ipv6AddrStr.toCharArray();
        byte[] dst = new byte[16];
        int srcb_length = addrBuff.length;
        int scopeID = ipv6AddrStr.indexOf("%");
        if (scopeID == srcb_length - 1) {
            return null;
        }
        if (scopeID != -1) {
            srcb_length = scopeID;
        }
        int colonIndex = -1;
        int i = 0;
        int j = 0;
        if (addrBuff[i] == '[') {
            ++i;
            if (scopeID == -1) {
                --srcb_length;
            }
        }
        if (addrBuff[i] == ':' && addrBuff[++i] != ':') {
            return null;
        }
        int curtok = i;
        boolean sawtDigit = false;
        int currentTkn = 0;
        while (i < srcb_length) {
            char currentChar;
            int chval;
            if ((chval = Character.digit(currentChar = addrBuff[i++], 16)) != -1) {
                currentTkn <<= 4;
                if ((currentTkn |= chval) > 65535) {
                    return null;
                }
                sawtDigit = true;
                continue;
            }
            if (currentChar == ':') {
                curtok = i;
                if (!sawtDigit) {
                    if (colonIndex != -1) {
                        return null;
                    }
                    colonIndex = j;
                    continue;
                }
                if (i == srcb_length) {
                    return null;
                }
                if (j + 2 > 16) {
                    return null;
                }
                dst[j++] = (byte)(currentTkn >> 8 & 0xFF);
                dst[j++] = (byte)(currentTkn & 0xFF);
                sawtDigit = false;
                currentTkn = 0;
                continue;
            }
            if (currentChar == '.' && j + 4 <= 16) {
                String ia4 = ipv6AddrStr.substring(curtok, srcb_length);
                int dot_count = 0;
                int index = 0;
                while ((index = ia4.indexOf(46, index)) != -1) {
                    ++dot_count;
                    ++index;
                }
                if (dot_count != 3) {
                    return null;
                }
                byte[] v4addr = NetworkUtils.strToIPv4(ia4);
                if (v4addr == null) {
                    return null;
                }
                for (int k = 0; k < 4; ++k) {
                    dst[j++] = v4addr[k];
                }
                sawtDigit = false;
                break;
            }
            return null;
        }
        if (sawtDigit) {
            if (j + 2 > 16) {
                return null;
            }
            dst[j++] = (byte)(currentTkn >> 8 & 0xFF);
            dst[j++] = (byte)(currentTkn & 0xFF);
        }
        if (colonIndex != -1) {
            int n = j - colonIndex;
            if (j == 16) {
                return null;
            }
            for (i = 1; i <= n; ++i) {
                dst[16 - i] = dst[colonIndex + n - i];
                dst[colonIndex + n - i] = 0;
            }
            j = 16;
        }
        if (j != 16) {
            return null;
        }
        byte[] newdst = NetworkUtils.mappedIPv4ToRealIPv4(dst);
        if (newdst != null) {
            return newdst;
        }
        return dst;
    }

    public static byte[] mappedIPv4ToRealIPv4(byte[] addr) {
        if (NetworkUtils.isMappedIPv4Addr(addr)) {
            byte[] newAddr = new byte[4];
            System.arraycopy(addr, 12, newAddr, 0, 4);
            return newAddr;
        }
        return null;
    }

    private static boolean isMappedIPv4Addr(byte[] address) {
        if (address.length < 16) {
            return false;
        }
        return address[0] == 0 && address[1] == 0 && address[2] == 0 && address[3] == 0 && address[4] == 0 && address[5] == 0 && address[6] == 0 && address[7] == 0 && address[8] == 0 && address[9] == 0 && address[10] == -1 && address[11] == -1;
    }

    public static InetAddress getInetAddress(String hostAddress) throws UnknownHostException {
        if (hostAddress == null || hostAddress.length() == 0) {
            throw new UnknownHostException(hostAddress + " is not a valid host address");
        }
        if (hostAddress.charAt(0) == '[') {
            if (hostAddress.length() > 2 && hostAddress.charAt(hostAddress.length() - 1) == ']') {
                hostAddress = hostAddress.substring(1, hostAddress.length() - 1);
            } else {
                throw new UnknownHostException(hostAddress);
            }
        }
        if (NetworkUtils.isValidIPAddress(hostAddress)) {
            byte[] addr = null;
            addr = NetworkUtils.strToIPv4(hostAddress);
            if (addr == null) {
                addr = NetworkUtils.strToIPv6(hostAddress);
            }
            return InetAddress.getByAddress(hostAddress, addr);
        }
        return InetAddress.getByName(hostAddress);
    }

    private static String determineAnyAddress() {
        Enumeration<NetworkInterface> ifaces;
        try {
            ifaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            logger.log(Level.FINE, "Couldn't retrieve local interfaces.", e);
            return IN4_ADDR_ANY;
        }
        while (ifaces.hasMoreElements()) {
            Enumeration<InetAddress> addrs = ifaces.nextElement().getInetAddresses();
            while (addrs.hasMoreElements()) {
                if (!(addrs.nextElement() instanceof Inet6Address)) continue;
                return IN6_ADDR_ANY;
            }
        }
        return IN4_ADDR_ANY;
    }

    public static boolean isValidPortNumber(int port) {
        return 1024 <= port && port <= 65535;
    }

    public static boolean isInterfaceLoopback(NetworkInterface iface) {
        try {
            Method method = iface.getClass().getMethod("isLoopback", new Class[0]);
            return (Boolean)method.invoke((Object)iface, new Object[0]);
        }
        catch (Throwable method) {
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            return addresses.hasMoreElements() && addresses.nextElement().isLoopbackAddress();
        }
    }

    public static boolean isInterfaceUp(NetworkInterface iface) {
        try {
            Method method = iface.getClass().getMethod("isUp", new Class[0]);
            return (Boolean)method.invoke((Object)iface, new Object[0]);
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public static boolean isInterfaceVirtual(NetworkInterface iface) {
        try {
            Method method = iface.getClass().getMethod("isVirtual", new Class[0]);
            return (Boolean)method.invoke((Object)iface, new Object[0]);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String stripScopeID(String ipv6Address) {
        int scopeStart = ((String)ipv6Address).indexOf(37);
        if (scopeStart == -1) {
            return ipv6Address;
        }
        if (((String)(ipv6Address = ((String)ipv6Address).substring(0, scopeStart))).charAt(0) == '[' && ((String)ipv6Address).charAt(((String)ipv6Address).length() - 1) != ']') {
            ipv6Address = (String)ipv6Address + "]";
        }
        return ipv6Address;
    }
}

