/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.pseudotcp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.pseudotcp.EnShutdown;
import org.ice4j.pseudotcp.Option;
import org.ice4j.pseudotcp.PseudoTcpNotify;
import org.ice4j.pseudotcp.PseudoTcpState;
import org.ice4j.pseudotcp.RSegment;
import org.ice4j.pseudotcp.SSegment;
import org.ice4j.pseudotcp.Segment;
import org.ice4j.pseudotcp.SendFlags;
import org.ice4j.pseudotcp.WriteResult;
import org.ice4j.pseudotcp.util.ByteFifoBuffer;

public class PseudoTCPBase {
    private static final Logger logger = Logger.getLogger(PseudoTCPBase.class.getName());
    private static boolean PSEUDO_KEEPALIVE = false;
    static final int[] PACKET_MAXIMUMS = new int[]{65535, 32000, 17914, 8166, 4352, 2002, 1492, 1006, 508, 296, 0};
    static final int MAX_PACKET = 65535;
    static final int MIN_PACKET = 296;
    static final int IP_HEADER_SIZE = 20;
    static final int ICMP_HEADER_SIZE = 8;
    static final int UDP_HEADER_SIZE = 8;
    static final int JINGLE_HEADER_SIZE = 64;
    public static final int DEFAULT_RCV_BUF_SIZE = 61440;
    public static final int DEFAULT_SND_BUF_SIZE = 92160;
    static final long MAX_SEQ = 0xFFFFFFFFL;
    static final int HEADER_SIZE = 24;
    static final int PACKET_OVERHEAD = 116;
    static final long MIN_RTO = 250L;
    static final long DEF_RTO = 3000L;
    static final long MAX_RTO = 60000L;
    static final long DEF_ACK_DELAY = 100L;
    static final short FLAG_CTL = 2;
    static final short FLAG_RST = 4;
    static final short CTL_CONNECT = 0;
    static final short CTL_EXTRA = 255;
    static final short TCP_OPT_EOL = 0;
    static final short TCP_OPT_NOOP = 1;
    static final short TCP_OPT_MSS = 2;
    static final short TCP_OPT_WND_SCALE = 3;
    static final int CTRL_BOUND = Integer.MIN_VALUE;
    static final long DEFAULT_TIMEOUT = 4000L;
    static final long CLOSED_TIMEOUT = 60000L;
    static final int IDLE_PING = 20000;
    static final int IDLE_TIMEOUT = 90000;
    PseudoTcpState m_state;
    long m_conv;
    boolean m_bReadEnable;
    boolean m_bWriteEnable;
    boolean m_bOutgoing;
    long m_lasttraffic;
    List<RSegment> m_rlist = new ArrayList<RSegment>();
    long m_lastrecv;
    int m_rbuf_len;
    int m_rcv_nxt;
    int m_rcv_wnd;
    private short m_rwnd_scale;
    ByteFifoBuffer m_rbuf;
    List<SSegment> m_slist = new ArrayList<SSegment>();
    long m_lastsend;
    long m_snd_nxt;
    long m_snd_una;
    int m_sbuf_len;
    private int m_snd_wnd;
    private short m_swnd_scale;
    ByteFifoBuffer m_sbuf;
    long m_mss;
    long m_largest;
    long m_mtu_advise;
    int m_msslevel;
    long m_rto_base;
    long m_ts_recent;
    long m_ts_lastack;
    long m_rx_rttvar;
    long m_rx_srtt;
    long m_rx_rto;
    long m_ssthresh;
    long m_cwnd;
    short m_dup_acks;
    long m_recover;
    long m_t_ack;
    boolean m_use_nagling;
    long m_ack_delay;
    boolean m_support_wnd_scale;
    PseudoTcpNotify m_notify;
    EnShutdown m_shutdown;
    String debugName = "";
    private final Object ack_notify = new Object();

    public PseudoTCPBase(PseudoTcpNotify notify, long conv) {
        this.m_notify = notify;
        this.m_shutdown = EnShutdown.SD_NONE;
        this.m_rbuf_len = 61440;
        this.m_rbuf = new ByteFifoBuffer(this.m_rbuf_len);
        this.m_sbuf_len = 92160;
        this.m_sbuf = new ByteFifoBuffer(this.m_sbuf_len);
        assert (this.m_rbuf_len + 296 < this.m_sbuf_len);
        long now = PseudoTCPBase.now();
        this.m_state = PseudoTcpState.TCP_LISTEN;
        this.m_conv = conv;
        this.m_rcv_wnd = this.m_rbuf_len;
        this.m_swnd_scale = 0;
        this.m_rwnd_scale = 0;
        this.m_snd_nxt = 0L;
        this.m_snd_wnd = 1;
        this.m_rcv_nxt = 0;
        this.m_snd_una = 0;
        this.m_bReadEnable = true;
        this.m_bWriteEnable = false;
        this.m_t_ack = 0L;
        this.m_msslevel = 0;
        this.m_largest = 0L;
        this.m_mss = 180L;
        this.m_mtu_advise = 65535L;
        this.m_rto_base = 0L;
        this.m_cwnd = 2L * this.m_mss;
        this.m_ssthresh = this.m_rbuf_len;
        this.m_lastsend = this.m_lasttraffic = now;
        this.m_lastrecv = this.m_lasttraffic;
        this.m_bOutgoing = false;
        this.m_dup_acks = 0;
        this.m_recover = 0L;
        this.m_ts_lastack = 0L;
        this.m_ts_recent = 0L;
        this.m_rx_rto = 3000L;
        this.m_rx_rttvar = 0L;
        this.m_rx_srtt = 0L;
        this.m_use_nagling = true;
        this.m_ack_delay = 100L;
        this.m_support_wnd_scale = false;
    }

    public void connect() throws IOException {
        if (this.m_state != PseudoTcpState.TCP_LISTEN) {
            throw new IOException("Invalid socket state: " + this.m_state);
        }
        this.m_state = PseudoTcpState.TCP_SYN_SENT;
        logger.log(Level.FINE, "State: TCP_SYN_SENT", "");
        this.queueConnectMessage();
        this.attemptSend(SendFlags.sfNone);
    }

    public void notifyMTU(int mtu) {
        this.m_mtu_advise = mtu;
        if (this.m_state == PseudoTcpState.TCP_ESTABLISHED) {
            this.adjustMTU();
        }
    }

    public int getMTU() {
        return (int)this.m_mtu_advise;
    }

    public static long now() {
        return System.nanoTime() / 1000000L & 0xFFFFFFFFL;
    }

    public long getNextClock(long now) {
        return this.clock_check(now);
    }

    public void notifyClock(long now) {
        if (this.m_state == PseudoTcpState.TCP_CLOSED) {
            return;
        }
        if (this.m_rto_base > 0L && PseudoTCPBase.timeDiff(this.m_rto_base + this.m_rx_rto, now) <= 0L) {
            assert (!this.m_slist.isEmpty());
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "timeout retransmit (rto: " + this.m_rx_rto + ")(rto_base: " + this.m_rto_base + ") (now: " + now + ") (dup_acks: " + this.m_dup_acks + ")");
            }
            if (!this.transmit(this.m_slist.get(0), now)) {
                this.closedown(new IOException("Connection aborted"));
                return;
            }
            long nInFlight = this.m_snd_nxt - this.m_snd_una;
            this.m_ssthresh = Math.max(nInFlight / 2L, 2L * this.m_mss);
            this.m_cwnd = this.m_mss;
            long rto_limit = this.m_state.ordinal() < PseudoTcpState.TCP_ESTABLISHED.ordinal() ? 3000L : 60000L;
            this.m_rx_rto = Math.min(rto_limit, this.m_rx_rto * 2L);
            this.m_rto_base = now;
        }
        if (this.getM_snd_wnd() == 0 && PseudoTCPBase.timeDiff(this.m_lastsend + this.m_rx_rto, now) <= 0L) {
            if (PseudoTCPBase.timeDiff(now, this.m_lastrecv) >= 15000L) {
                this.closedown(new IOException("Connection aborted"));
                return;
            }
            this.packet(this.m_snd_nxt - 1L, (short)0, 0L, 0L);
            this.m_lastsend = now;
            this.m_rx_rto = Math.min(60000L, this.m_rx_rto * 2L);
        }
        long timeDiff = PseudoTCPBase.timeDiff(this.m_t_ack + this.m_ack_delay, now);
        if (this.m_t_ack > 0L && timeDiff <= 0L) {
            this.packet(this.m_snd_nxt, (short)0, 0L, 0L);
        }
        if (PSEUDO_KEEPALIVE) {
            if (this.m_state == PseudoTcpState.TCP_ESTABLISHED && PseudoTCPBase.timeDiff(this.m_lastrecv + 90000L, now) <= 0L) {
                this.closedown(new IOException("Connection aborted"));
                return;
            }
            if (this.m_state == PseudoTcpState.TCP_ESTABLISHED && PseudoTCPBase.timeDiff(this.m_lasttraffic + (long)(this.m_bOutgoing ? 30000 : 20000), now) <= 0L) {
                this.packet(this.m_snd_nxt, (short)0, 0L, 0L);
            }
        }
    }

    public synchronized boolean notifyPacket(byte[] buffer, int len) {
        if (len > 65535) {
            logger.log(Level.WARNING, this.debugName + " packet too large");
            return false;
        }
        return this.parse(buffer, len);
    }

    long getOption(Option opt) {
        if (opt == Option.OPT_NODELAY) {
            return this.m_use_nagling ? 0L : 1L;
        }
        if (opt == Option.OPT_ACKDELAY) {
            return this.m_ack_delay;
        }
        if (opt == Option.OPT_SNDBUF) {
            return this.m_sbuf_len;
        }
        assert (opt == Option.OPT_RCVBUF);
        return this.m_rbuf_len;
    }

    void setOption(Option opt, long value) {
        if (opt == Option.OPT_NODELAY) {
            this.m_use_nagling = value == 0L;
        } else if (opt == Option.OPT_ACKDELAY) {
            this.m_ack_delay = value;
        } else if (opt == Option.OPT_SNDBUF) {
            assert (this.m_state == PseudoTcpState.TCP_LISTEN);
            this.resizeSendBuffer((int)value);
        } else {
            assert (opt == Option.OPT_RCVBUF);
            assert (this.m_state == PseudoTcpState.TCP_LISTEN);
            this.resizeReceiveBuffer((int)value);
        }
    }

    long getCongestionWindow() {
        return this.m_cwnd;
    }

    long getBytesInFlight() {
        return this.m_snd_nxt - this.m_snd_una;
    }

    long getBytesBufferedNotSent() {
        long buffered_bytes = this.m_sbuf.getBuffered();
        return this.m_snd_una + buffered_bytes - this.m_snd_nxt;
    }

    int getAvailable() {
        return this.m_rbuf.getBuffered();
    }

    int getAvailableSendBuffer() {
        return this.m_sbuf.getWriteRemaining();
    }

    long getRoundTripTimeEstimateMs() {
        return this.m_rx_srtt;
    }

    public synchronized int recv(byte[] buffer, int offset, int len) throws IOException {
        if (this.m_state != PseudoTcpState.TCP_ESTABLISHED) {
            throw new IOException("Socket not connected");
        }
        int read = this.m_rbuf.read(buffer, offset, len);
        if (read == 0) {
            this.m_bReadEnable = true;
            return 0;
        }
        assert (read != -1);
        int available_space = this.m_rbuf.getWriteRemaining();
        if ((long)(available_space - this.m_rcv_wnd) >= Math.min((long)(this.m_rbuf_len / 8), this.m_mss)) {
            boolean bWasClosed = this.m_rcv_wnd == 0;
            this.m_rcv_wnd = available_space;
            if (bWasClosed) {
                this.attemptSend(SendFlags.sfImmediateAck);
            }
        }
        return read;
    }

    public int recv(byte[] buffer, int len) throws IOException {
        return this.recv(buffer, 0, len);
    }

    public int send(byte[] buffer, int len) throws IOException {
        return this.send(buffer, 0, len);
    }

    public synchronized int send(byte[] buffer, int offset, int len) throws IOException {
        if (this.m_state != PseudoTcpState.TCP_ESTABLISHED) {
            throw new IOException("Socket not connected");
        }
        long available_space = this.m_sbuf.getWriteRemaining();
        if (available_space == 0L) {
            this.m_bWriteEnable = true;
            return 0;
        }
        int written = this.queue(buffer, offset, len, false);
        this.attemptSend(SendFlags.sfNone);
        return written;
    }

    void close(boolean force) {
        logger.log(Level.FINE, this.debugName + " close (" + force + ")");
        EnShutdown enShutdown = this.m_shutdown = force ? EnShutdown.SD_FORCEFUL : EnShutdown.SD_GRACEFUL;
        if (force) {
            this.m_state = PseudoTcpState.TCP_CLOSED;
        }
    }

    int queue(byte[] buffer, int offset, int len, boolean bCtrl) {
        int available_space = this.m_sbuf.getWriteRemaining();
        if (len > available_space) {
            assert (!bCtrl);
            len = available_space;
        }
        SSegment back = null;
        if (!this.m_slist.isEmpty()) {
            back = this.m_slist.get(this.m_slist.size() - 1);
        }
        if (back != null && back.bCtrl == bCtrl && back.xmit == 0) {
            back.len += (long)len;
        } else {
            long snd_buffered = this.m_sbuf.getBuffered();
            SSegment sseg = new SSegment(this.m_snd_una + snd_buffered, len, bCtrl);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, this.debugName + " enqueued send segment seq: " + sseg.seq + " len: " + sseg.len);
            }
            this.m_slist.add(sseg);
        }
        int written = this.m_sbuf.write(buffer, offset, len);
        return written;
    }

    WriteResult packet(long seq, short flags, long offset, long len) {
        WriteResult wres;
        assert (24L + len <= 65535L);
        long now = PseudoTCPBase.now();
        byte[] buffer = new byte[24 + (int)len];
        PseudoTCPBase.long_to_bytes(this.m_conv, buffer, 0);
        PseudoTCPBase.long_to_bytes(seq, buffer, 4);
        PseudoTCPBase.long_to_bytes(this.m_rcv_nxt, buffer, 8);
        buffer[12] = 0;
        buffer[13] = (byte)(flags & 0xFF);
        PseudoTCPBase.short_to_bytes(this.m_rcv_wnd >> this.m_rwnd_scale, buffer, 14);
        PseudoTCPBase.long_to_bytes(now, buffer, 16);
        PseudoTCPBase.long_to_bytes(this.m_ts_recent, buffer, 20);
        this.m_ts_lastack = this.m_rcv_nxt;
        if (len > 0L) {
            int bytes_read = this.m_sbuf.readOffset(buffer, 24, (int)len, (int)offset);
            assert ((long)bytes_read == len);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "<-- " + this.debugName + " <CONV=" + this.m_conv + "><FLG=" + flags + "><SEQ=" + seq + ":" + (seq + len) + "><ACK=" + this.m_rcv_nxt + "><WND=" + this.m_rcv_wnd + "><SCALE=" + this.m_rwnd_scale + "><TS=" + now + "><TSR=" + this.m_ts_recent + "><LEN=" + len + ">");
        }
        if ((wres = this.m_notify.tcpWritePacket(this, buffer, (int)len + 24)) != WriteResult.WR_SUCCESS && 0L != len) {
            return wres;
        }
        this.m_t_ack = 0L;
        if (len > 0L) {
            this.m_lastsend = now;
        }
        this.m_lasttraffic = now;
        this.m_bOutgoing = true;
        return WriteResult.WR_SUCCESS;
    }

    public static Segment parseSeg(byte[] buffer, int size) {
        if (size < 12) {
            return null;
        }
        Segment seg = new Segment();
        seg.conv = PseudoTCPBase.bytes_to_long(buffer, 0);
        seg.seq = PseudoTCPBase.bytes_to_long(buffer, 4);
        seg.ack = PseudoTCPBase.bytes_to_long(buffer, 8);
        seg.flags = buffer[13];
        seg.wnd = PseudoTCPBase.bytes_to_short(buffer, 14);
        seg.tsval = PseudoTCPBase.bytes_to_long(buffer, 16);
        seg.tsecr = PseudoTCPBase.bytes_to_long(buffer, 20);
        seg.data = PseudoTCPBase.copy_buffer(buffer, 24, size - 24);
        seg.len = size - 24;
        return seg;
    }

    public static String segToStr(Segment seg) {
        Object data = "data: ";
        for (byte b : seg.data) {
            data = (String)data + b;
        }
        return "<CONV=" + seg.conv + "><FLG=" + seg.flags + "><SEQ=" + seg.seq + ":" + (seg.seq + (long)seg.len) + "><ACK=" + seg.ack + "><WND=" + seg.wnd + "><TS=" + seg.tsval + "><TSR=" + seg.tsecr + "><LEN=" + seg.len + "> " + (String)data;
    }

    boolean parse(byte[] buffer, int size) {
        if (size < 12) {
            return false;
        }
        Segment seg = PseudoTCPBase.parseSeg(buffer, size);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "--> " + this.debugName + "<CONV=" + seg.conv + "><FLG=" + seg.flags + "><SEQ=" + seg.seq + ":" + (seg.seq + (long)seg.len) + "><ACK=" + seg.ack + "><WND=" + seg.wnd + "><SCALE=" + this.m_swnd_scale + "><TS=" + seg.tsval + "><TSR=" + seg.tsecr + "><LEN=" + seg.len + ">");
        }
        return this.process(seg);
    }

    long clock_check(long now) {
        if (this.m_shutdown == EnShutdown.SD_FORCEFUL) {
            return -1L;
        }
        long snd_buffered = this.m_sbuf.getBuffered();
        if (this.m_shutdown == EnShutdown.SD_GRACEFUL && (this.m_state != PseudoTcpState.TCP_ESTABLISHED || snd_buffered == 0L && this.m_t_ack == 0L)) {
            return -1L;
        }
        if (this.m_state == PseudoTcpState.TCP_CLOSED) {
            return 60000L;
        }
        long nTimeout = 4000L;
        if (this.m_t_ack > 0L) {
            nTimeout = Math.min(nTimeout, PseudoTCPBase.timeDiff(this.m_t_ack + this.m_ack_delay, now));
        }
        if (this.m_rto_base > 0L) {
            nTimeout = Math.min(nTimeout, PseudoTCPBase.timeDiff(this.m_rto_base + this.m_rx_rto, now));
        }
        if (this.getM_snd_wnd() == 0) {
            nTimeout = Math.min(nTimeout, PseudoTCPBase.timeDiff(this.m_lastsend + this.m_rx_rto, now));
        }
        if (PSEUDO_KEEPALIVE && this.m_state == PseudoTcpState.TCP_ESTABLISHED) {
            nTimeout = Math.min(nTimeout, PseudoTCPBase.timeDiff(this.m_lasttraffic + (long)(this.m_bOutgoing ? 30000 : 20000), now));
        }
        return nTimeout <= 0L ? 1L : nTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean process(Segment seg) {
        long available_space;
        long now;
        if (seg.conv != this.m_conv) {
            logger.info(this.debugName + " wrong conversation number, this: " + this.m_conv + " remote: " + seg.conv);
            return false;
        }
        this.m_lasttraffic = this.m_lastrecv = (now = PseudoTCPBase.now());
        this.m_bOutgoing = false;
        if (this.m_state == PseudoTcpState.TCP_CLOSED) {
            this.closedown(new IOException(this.debugName + " in closed state"));
            return false;
        }
        if ((seg.flags & 4) > 0) {
            this.closedown(new IOException("Connection reset"));
            return false;
        }
        boolean bConnect = false;
        if ((seg.flags & 2) > 0) {
            if (seg.len == 0) {
                logger.log(Level.SEVERE, this.debugName + " Missing control code");
                return false;
            }
            if (seg.data[0] == 0) {
                bConnect = true;
                if (!this.parseOptions(seg.data, 1, seg.len - 1)) {
                    return false;
                }
                if (this.m_state == PseudoTcpState.TCP_LISTEN) {
                    this.m_state = PseudoTcpState.TCP_SYN_RECEIVED;
                    logger.log(Level.FINE, this.debugName + " State: TCP_SYN_RECEIVED");
                    this.queueConnectMessage();
                } else if (this.m_state == PseudoTcpState.TCP_SYN_SENT) {
                    this.m_state = PseudoTcpState.TCP_ESTABLISHED;
                    logger.log(Level.FINE, this.debugName + " State: TCP_ESTABLISHED");
                    this.adjustMTU();
                    if (this.m_notify != null) {
                        this.m_notify.onTcpOpen(this);
                    }
                }
            } else {
                logger.log(Level.SEVERE, this.debugName + " Unknown control code: " + seg.data[0]);
                return false;
            }
        }
        if (seg.seq <= this.m_ts_lastack && this.m_ts_lastack < seg.seq + (long)seg.len) {
            this.m_ts_recent = seg.tsval;
        }
        if (seg.ack > this.m_snd_una && seg.ack <= this.m_snd_nxt) {
            if (seg.tsecr > 0L) {
                long rtt = PseudoTCPBase.timeDiff(now, seg.tsecr);
                assert (rtt >= 0L);
                if (this.m_rx_srtt == 0L) {
                    this.m_rx_srtt = rtt;
                    this.m_rx_rttvar = rtt / 2L;
                } else {
                    this.m_rx_rttvar = (3L * this.m_rx_rttvar + Math.abs(rtt - this.m_rx_srtt)) / 4L;
                    this.m_rx_srtt = (7L * this.m_rx_srtt + rtt) / 8L;
                }
                this.m_rx_rto = this.bound(250L, this.m_rx_srtt + Math.max(1L, 4L * this.m_rx_rttvar), 60000L);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "rtt: " + rtt + " srtt: " + this.m_rx_srtt + " rto: " + this.m_rx_rto);
                }
            }
            this.m_snd_wnd = seg.wnd << this.m_swnd_scale;
            long nAcked = seg.ack - this.m_snd_una;
            Object object = this.ack_notify;
            synchronized (object) {
                this.m_snd_una = seg.ack;
                this.m_rto_base = this.m_snd_una == this.m_snd_nxt ? 0L : now;
                this.m_sbuf.consumeReadData((int)nAcked);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, this.debugName + " acked: " + nAcked + " m_snd_una: " + this.m_snd_una);
                }
                this.ack_notify.notifyAll();
            }
            long nFree = nAcked;
            while (nFree > 0L) {
                assert (!this.m_slist.isEmpty());
                if (nFree < this.m_slist.get((int)0).len) {
                    this.m_slist.get((int)0).len -= nFree;
                    this.m_slist.get((int)0).seq += nFree;
                    nFree = 0L;
                    continue;
                }
                if (this.m_slist.get((int)0).len > this.m_largest) {
                    this.m_largest = this.m_slist.get((int)0).len;
                }
                nFree -= this.m_slist.get((int)0).len;
                this.m_slist.remove(0);
            }
            if (this.m_dup_acks >= 3) {
                if (this.m_snd_una >= this.m_recover) {
                    long nInFlight = this.m_snd_nxt - this.m_snd_una;
                    this.m_cwnd = Math.min(this.m_ssthresh, nInFlight + this.m_mss);
                    logger.log(Level.FINE, "exit recovery");
                    this.m_dup_acks = 0;
                } else {
                    logger.log(Level.FINE, "recovery retransmit");
                    if (!this.transmit(this.m_slist.get(0), now)) {
                        this.closedown(new IOException("Connection aborted"));
                        return false;
                    }
                    this.m_cwnd += this.m_mss - Math.min(nAcked, this.m_cwnd);
                }
            } else {
                this.m_dup_acks = 0;
                this.m_cwnd = this.m_cwnd < this.m_ssthresh ? (this.m_cwnd += this.m_mss) : (this.m_cwnd += Math.max(1L, this.m_mss * this.m_mss / this.m_cwnd));
            }
        } else if (seg.ack == this.m_snd_una) {
            this.m_snd_wnd = seg.wnd << this.m_swnd_scale;
            if (seg.len <= 0) {
                if (this.m_snd_una != this.m_snd_nxt) {
                    this.m_dup_acks = (short)(this.m_dup_acks + 1);
                    if (this.m_dup_acks == 3) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, this.debugName + " enter recovery");
                            logger.log(Level.FINE, this.debugName + " recovery retransmit");
                        }
                        if (!this.transmit(this.m_slist.get(0), now)) {
                            this.closedown(new IOException("Connection aborted"));
                            return false;
                        }
                        this.m_recover = this.m_snd_nxt;
                        long nInFlight = this.m_snd_nxt - this.m_snd_una;
                        this.m_ssthresh = Math.max(nInFlight / 2L, 2L * this.m_mss);
                        this.m_cwnd = this.m_ssthresh + 3L * this.m_mss;
                    } else if (this.m_dup_acks > 3) {
                        this.m_cwnd += this.m_mss;
                    }
                } else {
                    this.m_dup_acks = 0;
                }
            }
        }
        if (this.m_state == PseudoTcpState.TCP_SYN_RECEIVED && !bConnect) {
            this.m_state = PseudoTcpState.TCP_ESTABLISHED;
            logger.log(Level.FINE, this.debugName + " State: TCP_ESTABLISHED");
            this.adjustMTU();
            if (this.m_notify != null) {
                this.m_notify.onTcpOpen(this);
            }
        }
        long kIdealRefillSize = (this.m_sbuf_len + this.m_rbuf_len) / 2;
        long snd_buffered = this.m_sbuf.getBuffered();
        if (this.m_bWriteEnable && snd_buffered < kIdealRefillSize) {
            this.m_bWriteEnable = false;
            if (this.m_notify != null) {
                this.m_notify.onTcpWriteable(this);
            }
        }
        SendFlags sflags = SendFlags.sfNone;
        if (seg.seq != (long)this.m_rcv_nxt) {
            sflags = SendFlags.sfImmediateAck;
        } else if (seg.len != 0) {
            sflags = this.m_ack_delay == 0L ? SendFlags.sfImmediateAck : SendFlags.sfDelayedAck;
        }
        if (sflags == SendFlags.sfImmediateAck) {
            if (seg.seq > (long)this.m_rcv_nxt) {
                logger.log(Level.FINER, "too new, seq.seq=" + seg.seq + ", seg.len=" + seg.len + ", m_rcv_nxt=" + this.m_rcv_nxt);
            } else if (seg.seq + (long)seg.len <= (long)this.m_rcv_nxt) {
                logger.log(Level.FINER, "too old, seq.seq=" + seg.seq + ", seg.len=" + seg.len + ", m_rcv_nxt=" + this.m_rcv_nxt);
            }
        }
        if (seg.seq < (long)this.m_rcv_nxt) {
            long nAdjust = (long)this.m_rcv_nxt - seg.seq;
            if (nAdjust < (long)seg.len) {
                seg.seq += nAdjust;
                seg.data = this.scrollBuffer(seg.data, (int)nAdjust);
                seg.len = (int)((long)seg.len - nAdjust);
            } else {
                seg.len = 0;
            }
        }
        if (seg.seq + (long)seg.len - (long)this.m_rcv_nxt > (available_space = (long)this.m_rbuf.getWriteRemaining())) {
            long nAdjust = seg.seq + (long)seg.len - (long)this.m_rcv_nxt - available_space;
            seg.len = nAdjust < (long)seg.len ? (int)((long)seg.len - nAdjust) : 0;
        }
        boolean bIgnoreData = (seg.flags & 2) > 0 || this.m_shutdown != EnShutdown.SD_NONE;
        boolean bNewData = false;
        if (seg.len > 0) {
            if (bIgnoreData) {
                if (seg.seq == (long)this.m_rcv_nxt) {
                    this.m_rcv_nxt += seg.len;
                }
            } else {
                long nOffset = seg.seq - (long)this.m_rcv_nxt;
                int result = this.m_rbuf.writeOffset(seg.data, seg.len, (int)nOffset);
                assert (result == seg.len);
                if (seg.seq == (long)this.m_rcv_nxt) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Avail space: " + available_space + " seg.len: " + seg.len);
                    }
                    this.m_rbuf.consumeWriteBuffer(seg.len);
                    this.m_rcv_nxt += seg.len;
                    this.m_rcv_wnd -= seg.len;
                    bNewData = true;
                    Iterator<RSegment> iter = this.m_rlist.iterator();
                    ArrayList<RSegment> toBeRemoved = new ArrayList<RSegment>();
                    while (iter.hasNext()) {
                        RSegment it = iter.next();
                        if (it.seq > (long)this.m_rcv_nxt) break;
                        if (it.seq + it.len > (long)this.m_rcv_nxt) {
                            sflags = SendFlags.sfImmediateAck;
                            long nAdjust = it.seq + it.len - (long)this.m_rcv_nxt;
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Recovered " + nAdjust + " bytes (" + this.m_rcv_nxt + " -> " + ((long)this.m_rcv_nxt + nAdjust) + ")");
                            }
                            this.m_rbuf.consumeWriteBuffer((int)nAdjust);
                            this.m_rcv_nxt = (int)((long)this.m_rcv_nxt + nAdjust);
                            this.m_rcv_wnd = (int)((long)this.m_rcv_wnd - nAdjust);
                        }
                        toBeRemoved.add(it);
                    }
                    this.m_rlist.removeAll(toBeRemoved);
                } else {
                    int insertPos;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Saving " + seg.len + " bytes (" + seg.seq + " -> " + (seg.seq + (long)seg.len) + ")");
                    }
                    RSegment rseg = new RSegment(seg.seq, seg.len);
                    for (insertPos = 0; insertPos < this.m_rlist.size(); ++insertPos) {
                        RSegment it = this.m_rlist.get(insertPos);
                        if (it.seq >= rseg.seq) break;
                    }
                    this.m_rlist.add(insertPos, rseg);
                }
            }
        }
        this.attemptSend(sflags);
        if (bNewData && this.m_bReadEnable) {
            this.m_bReadEnable = false;
            if (this.m_notify != null) {
                this.m_notify.onTcpReadable(this);
            }
        }
        return true;
    }

    private static long timeDiff(long later, long earlier) {
        return later - earlier;
    }

    private static void long_to_bytes(long anUnsignedInt, byte[] buf, int offset) {
        buf[offset] = (byte)((anUnsignedInt & 0xFF000000L) >>> 24);
        buf[offset + 1] = (byte)((anUnsignedInt & 0xFF0000L) >>> 16);
        buf[offset + 2] = (byte)((anUnsignedInt & 0xFF00L) >>> 8);
        buf[offset + 3] = (byte)(anUnsignedInt & 0xFFL);
    }

    private static void short_to_bytes(int anUnsignedShort, byte[] buf, int offset) {
        buf[offset] = (byte)((anUnsignedShort & 0xFF00) >>> 8);
        buf[offset + 1] = (byte)(anUnsignedShort & 0xFF);
    }

    private static long bytes_to_long(byte[] buffer, int offset) {
        int fByte = 0xFF & buffer[offset];
        int sByte = 0xFF & buffer[offset + 1];
        int tByte = 0xFF & buffer[offset + 2];
        int foByte = 0xFF & buffer[offset + 3];
        return (long)(fByte << 24 | sByte << 16 | tByte << 8 | foByte) & 0xFFFFFFFFL;
    }

    private static int bytes_to_short(byte[] buffer, int offset) {
        int fByte = 0xFF & buffer[offset];
        int sByte = 0xFF & buffer[offset + 1];
        return (fByte << 8 | sByte) & 0xFFFF;
    }

    private static byte[] copy_buffer(byte[] buffer, int sOffset, int len) {
        byte[] newData = new byte[len];
        System.arraycopy(buffer, sOffset, newData, 0, len);
        return newData;
    }

    private long bound(long lower, long middle, long upper) {
        return Math.min(Math.max(lower, middle), upper);
    }

    private byte[] scrollBuffer(byte[] data, int nAdjust) {
        byte[] newBuffer = new byte[data.length - nAdjust];
        System.arraycopy(data, nAdjust, newBuffer, 0, newBuffer.length);
        return newBuffer;
    }

    boolean transmit(SSegment seg, long now) {
        short flags;
        long seq;
        WriteResult wres;
        if (seg.xmit >= (this.m_state == PseudoTcpState.TCP_ESTABLISHED ? (short)15 : 30)) {
            logger.log(Level.FINE, "too many retransmits");
            return false;
        }
        long nTransmit = Math.min(seg.len, this.m_mss);
        while ((wres = this.packet(seq = seg.seq, flags = seg.bCtrl ? (short)2 : 0, seg.seq - this.m_snd_una, nTransmit)) != WriteResult.WR_SUCCESS) {
            if (wres == WriteResult.WR_FAIL) {
                logger.log(Level.WARNING, "packet failed");
                return false;
            }
            assert (wres == WriteResult.WR_TOO_LARGE);
            do {
                if (PACKET_MAXIMUMS[this.m_msslevel + 1] == 0) {
                    logger.log(Level.INFO, "MTU too small");
                    return false;
                }
                this.m_mss = PACKET_MAXIMUMS[++this.m_msslevel] - 116;
                this.m_cwnd = 2L * this.m_mss;
            } while (this.m_mss >= nTransmit);
            nTransmit = this.m_mss;
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.log(Level.INFO, "Adjusting mss to " + this.m_mss + " bytes");
        }
        if (nTransmit < seg.len) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "mss reduced to " + this.m_mss);
            }
            SSegment subseg = new SSegment(seg.seq + nTransmit, seg.len - nTransmit, seg.bCtrl);
            subseg.xmit = seg.xmit;
            seg.len = nTransmit;
            this.m_slist.add(this.m_slist.indexOf(seg) + 1, subseg);
        }
        if (seg.xmit == 0) {
            this.m_snd_nxt += seg.len;
        }
        seg.xmit = (short)(seg.xmit + 1);
        if (this.m_rto_base == 0L) {
            this.m_rto_base = now;
        }
        return true;
    }

    void attemptSend(SendFlags sflags) {
        long now = PseudoTCPBase.now();
        if (PseudoTCPBase.timeDiff(now, this.m_lastsend) > this.m_rx_rto) {
            this.m_cwnd = this.m_mss;
        }
        boolean bFirst = true;
        while (true) {
            long nWindow;
            long nInFlight;
            long cwnd = this.m_cwnd;
            if (this.m_dup_acks == 1 || this.m_dup_acks == 2) {
                cwnd += (long)this.m_dup_acks * this.m_mss;
            }
            long nUseable = (nInFlight = this.m_snd_nxt - this.m_snd_una) < (nWindow = Math.min((long)this.getM_snd_wnd(), cwnd)) ? nWindow - nInFlight : 0L;
            long snd_buffered = this.m_sbuf.getBuffered();
            long nAvailable = Math.min(snd_buffered - nInFlight, this.m_mss);
            if (nAvailable > nUseable) {
                if (nUseable * 4L < nWindow) {
                    logger.log(Level.FINER, "RFC 813 - avoid SWS(nAvailable = 0)");
                    nAvailable = 0L;
                } else {
                    nAvailable = nUseable;
                }
            }
            if (bFirst) {
                long available_space = this.m_sbuf.getWriteRemaining();
                bFirst = false;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "[cwnd: " + this.m_cwnd + " nWindow: " + nWindow + " nInFlight: " + nInFlight + " nAvailable: " + nAvailable + " nQueued: " + snd_buffered + " nEmpty: " + available_space + " ssthresh: " + this.m_ssthresh + "]");
                }
            }
            if (nAvailable == 0L) {
                if (sflags == SendFlags.sfNone) {
                    logger.log(Level.FINEST, "nAvailable == 0: quit");
                    return;
                }
                if (sflags == SendFlags.sfImmediateAck || this.m_t_ack > 0L) {
                    this.packet(this.m_snd_nxt, (short)0, 0L, 0L);
                    logger.log(Level.FINER, "Immediate ack: ");
                } else {
                    this.m_t_ack = PseudoTCPBase.now();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "Delayed ack, m_t_ack: " + this.m_t_ack);
                    }
                }
                return;
            }
            if (this.m_use_nagling && this.m_snd_nxt > this.m_snd_una && nAvailable < this.m_mss) {
                logger.log(Level.FINER, "wait until more data is acked");
                return;
            }
            SSegment seg = null;
            Iterator<SSegment> iter = this.m_slist.iterator();
            do {
                SSegment it = iter.next();
                if (it.xmit != 0) continue;
                seg = it;
                break;
            } while (iter.hasNext());
            assert (seg != null);
            if (seg.len > nAvailable) {
                logger.log(Level.FINEST, "Break a segment into 2");
                SSegment subseg = new SSegment(seg.seq + nAvailable, seg.len - nAvailable, seg.bCtrl);
                seg.len = nAvailable;
                this.m_slist.add(this.m_slist.indexOf(seg) + 1, subseg);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "TRANSMIT SEGMENT seq: " + seg.seq + " len: " + seg.len);
            }
            if (!this.transmit(seg, now)) {
                logger.log(Level.SEVERE, "transmit failed");
                return;
            }
            sflags = SendFlags.sfNone;
        }
    }

    void closedown(IOException e) {
        logger.log(Level.FINE, this.debugName + " State: TCP_CLOSED ");
        this.m_state = PseudoTcpState.TCP_CLOSED;
        if (this.m_notify != null) {
            this.m_notify.onTcpClosed(this, e);
        }
    }

    void adjustMTU() {
        this.m_msslevel = 0;
        while (PACKET_MAXIMUMS[this.m_msslevel + 1] > 0 && (long)PACKET_MAXIMUMS[this.m_msslevel] > this.m_mtu_advise) {
            ++this.m_msslevel;
        }
        this.m_mss = this.m_mtu_advise - 116L;
        logger.log(Level.FINE, "Adjusting mss to " + this.m_mss + " bytes");
        this.m_ssthresh = Math.max(this.m_ssthresh, 2L * this.m_mss);
        this.m_cwnd = Math.max(this.m_cwnd, this.m_mss);
    }

    boolean isReceiveBufferFull() {
        return this.m_rbuf.getWriteRemaining() == 0;
    }

    void disableWindowScale() {
        this.m_support_wnd_scale = false;
    }

    void queueConnectMessage() {
        byte[] buff = null;
        if (this.m_support_wnd_scale) {
            buff = new byte[4];
            buff[1] = 3;
            buff[2] = 1;
            buff[3] = (byte)(this.m_rwnd_scale & 0xFF);
        } else {
            buff = new byte[]{0};
        }
        this.m_snd_wnd = buff.length;
        this.queue(buff, 0, buff.length, true);
    }

    boolean parseOptions(byte[] data, int offset, int len) {
        ArrayList<Short> options_specified = new ArrayList<Short>();
        ByteBuffer buf = ByteBuffer.wrap(data, offset, len);
        while (buf.hasRemaining()) {
            short kind = 0;
            short tmp = buf.get();
            if (tmp != -1) {
                kind = tmp;
            }
            if (kind == 0) break;
            if (kind == 1) continue;
            assert (len != 0);
            short opt_len = buf.get();
            if (opt_len > buf.remaining()) {
                logger.log(Level.SEVERE, "Invalid option length received: " + opt_len + " data len: " + buf.remaining());
                return false;
            }
            byte[] opt_data = new byte[opt_len];
            buf.get(opt_data);
            this.applyOption(kind, opt_data, opt_len);
            options_specified.add(kind);
        }
        if (!options_specified.contains((short)3)) {
            logger.log(Level.WARNING, "Peer doesn't support window scaling");
            if (this.getM_rwnd_scale() > 0) {
                this.resizeReceiveBuffer(61440);
                this.m_swnd_scale = 0;
            }
        }
        return true;
    }

    void applyOption(short kind, byte[] data, long len) {
        if (kind == 2) {
            logger.log(Level.WARNING, "Peer specified MSS option which is not supported.");
        } else if (kind == 3) {
            if (len != 1L) {
                logger.log(Level.SEVERE, "Invalid window scale option received.");
                return;
            }
            this.applyWindowScaleOption(data[0]);
        }
    }

    void applyWindowScaleOption(short scale_factor) {
        this.m_swnd_scale = scale_factor;
    }

    void resizeSendBuffer(int new_size) {
        this.m_sbuf_len = new_size;
        this.m_sbuf.setCapacity(new_size);
    }

    void resizeReceiveBuffer(int new_size) {
        int available_space;
        int scale_factor = 0;
        while (new_size > 65535) {
            scale_factor = (short)(scale_factor + 1);
            new_size >>= 1;
        }
        boolean result = this.m_rbuf.setCapacity(new_size <<= scale_factor);
        assert (result);
        this.m_rbuf_len = new_size;
        this.m_rwnd_scale = (short)scale_factor;
        this.m_ssthresh = new_size;
        this.m_rcv_wnd = available_space = this.m_rbuf.getWriteRemaining();
    }

    int getM_snd_wnd() {
        return this.m_snd_wnd;
    }

    public PseudoTcpState getState() {
        return this.m_state;
    }

    int getSendBufferSize() {
        return this.m_sbuf_len;
    }

    int getRecvBufferSize() {
        return this.m_rbuf_len;
    }

    public short getM_rwnd_scale() {
        return this.m_rwnd_scale;
    }

    public short getM_swnd_scale() {
        return this.m_swnd_scale;
    }

    public Object getAckNotify() {
        return this.ack_notify;
    }

    long getConversationID() {
        return this.m_conv;
    }

    void setConversationID(long convID) {
        if (this.m_state != PseudoTcpState.TCP_LISTEN) {
            throw new IllegalStateException();
        }
        this.m_conv = convID;
    }
}

