/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.negotiators.capabilities;

import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.negotiators.CompositeNegotiator;
import com.ircclouds.irc.api.negotiators.api.Relay;
import com.ircclouds.irc.api.om.ServerMessageBuilder;
import com.ircclouds.irc.api.utils.RawMessageUtils;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsCapability
implements CompositeNegotiator.Capability {
    private static final Logger LOG = LoggerFactory.getLogger(TlsCapability.class);
    private static final ServerMessageBuilder SERVER_MESSAGE_BUILDER = new ServerMessageBuilder();
    private final IRCApi irc;

    public TlsCapability(IRCApi aIrc) {
        if (aIrc == null) {
            throw new NullPointerException("IRC api instance must be provided.");
        }
        this.irc = aIrc;
    }

    @Override
    public String getId() {
        return "tls";
    }

    @Override
    public boolean enable() {
        return true;
    }

    @Override
    public boolean converse(Relay relay, String msg) {
        if (msg == null) {
            relay.send("STARTTLS");
            return true;
        }
        if (!RawMessageUtils.isServerNumericMessage(msg)) {
            LOG.error("Unexpected message encountered. Aborting securing connection with TLS.");
            return false;
        }
        ServerNumericMessage numMsg = SERVER_MESSAGE_BUILDER.build(msg);
        switch (numMsg.getNumericCode()) {
            case 670: {
                try {
                    this.irc.secureConnection(null, numMsg.getSource().getHostname(), numMsg.getSource().getPort());
                }
                catch (SSLException e) {
                    LOG.error("error starting handshake", (Throwable)e);
                }
                return false;
            }
            case 691: {
                return false;
            }
        }
        LOG.error("Unsupported numeric message from server: {}", (Object)numMsg.asRaw());
        return false;
    }
}

