/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jitsi.config.ConfigSourceWrapper;
import org.jitsi.config.ConfigurationServiceConfigSource;
import org.jitsi.config.ReadOnlyConfigurationService;
import org.jitsi.config.TypesafeConfigSource;
import org.jitsi.metaconfig.ConfigSource;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.utils.logging2.LoggerImpl;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jitsi/config/JitsiConfig;", "", "()V", "Companion", "jicoco-config"})
public final class JitsiConfig {
    @NotNull
    private static final LoggerImpl logger;
    @NotNull
    private static ConfigSource TypesafeConfig;
    private static int numTypesafeReloads;
    private static final ConfigSourceWrapper _newConfig;
    @NotNull
    private static final ConfigurationService SipCommunicatorProps;
    @NotNull
    private static final ConfigSource SipCommunicatorPropsConfigSource;
    private static final ConfigSourceWrapper _legacyConfig;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        logger = new LoggerImpl(Reflection.getOrCreateKotlinClass(JitsiConfig.class).getSimpleName());
        TypesafeConfig = new TypesafeConfigSource("typesafe config", JitsiConfig.Companion.loadNewConfig());
        ConfigSourceWrapper configSourceWrapper = new ConfigSourceWrapper(TypesafeConfig);
        boolean bl = false;
        boolean bl2 = false;
        ConfigSourceWrapper it = configSourceWrapper;
        boolean bl3 = false;
        logger.info((Object)("Initialized newConfig: " + TypesafeConfig.getDescription()));
        _newConfig = configSourceWrapper;
        SipCommunicatorProps = new ReadOnlyConfigurationService();
        SipCommunicatorPropsConfigSource = new ConfigurationServiceConfigSource("sip communicator props", SipCommunicatorProps);
        configSourceWrapper = new ConfigSourceWrapper(SipCommunicatorPropsConfigSource);
        bl = false;
        bl2 = false;
        it = configSourceWrapper;
        boolean bl4 = false;
        logger.info((Object)("Initialized legacyConfig: " + SipCommunicatorPropsConfigSource.getDescription()));
        _legacyConfig = configSourceWrapper;
    }

    @NotNull
    public static final ConfigurationService getSipCommunicatorProps() {
        Companion companion = Companion;
        return SipCommunicatorProps;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\tJ\u000e\u0010$\u001a\u00020!2\u0006\u0010#\u001a\u00020\tR\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jitsi/config/JitsiConfig$Companion;", "", "()V", "SipCommunicatorProps", "Lorg/jitsi/service/configuration/ConfigurationService;", "SipCommunicatorProps$annotations", "getSipCommunicatorProps", "()Lorg/jitsi/service/configuration/ConfigurationService;", "SipCommunicatorPropsConfigSource", "Lorg/jitsi/metaconfig/ConfigSource;", "getSipCommunicatorPropsConfigSource", "()Lorg/jitsi/metaconfig/ConfigSource;", "<set-?>", "TypesafeConfig", "getTypesafeConfig", "setTypesafeConfig", "(Lorg/jitsi/metaconfig/ConfigSource;)V", "_legacyConfig", "Lorg/jitsi/config/ConfigSourceWrapper;", "_newConfig", "legacyConfig", "getLegacyConfig", "logger", "Lorg/jitsi/utils/logging2/LoggerImpl;", "getLogger", "()Lorg/jitsi/utils/logging2/LoggerImpl;", "newConfig", "getNewConfig", "numTypesafeReloads", "", "loadNewConfig", "Lcom/typesafe/config/Config;", "reloadNewConfig", "", "useDebugLegacyConfig", "config", "useDebugNewConfig", "jicoco-config"})
    public static final class Companion {
        @NotNull
        public final LoggerImpl getLogger() {
            return logger;
        }

        @NotNull
        public final ConfigSource getTypesafeConfig() {
            return TypesafeConfig;
        }

        private final void setTypesafeConfig(ConfigSource configSource) {
            TypesafeConfig = configSource;
        }

        @NotNull
        public final ConfigSource getNewConfig() {
            return _newConfig;
        }

        @JvmStatic
        public static /* synthetic */ void SipCommunicatorProps$annotations() {
        }

        @NotNull
        public final ConfigurationService getSipCommunicatorProps() {
            return SipCommunicatorProps;
        }

        @NotNull
        public final ConfigSource getSipCommunicatorPropsConfigSource() {
            return SipCommunicatorPropsConfigSource;
        }

        @NotNull
        public final ConfigSource getLegacyConfig() {
            return _legacyConfig;
        }

        public final void useDebugNewConfig(@NotNull ConfigSource config) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            this.getLogger().info((Object)("Replacing newConfig with " + config.getDescription()));
            _newConfig.setInnerSource(config);
        }

        public final void useDebugLegacyConfig(@NotNull ConfigSource config) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            this.getLogger().info((Object)("Replacing legacyConfig with " + config.getDescription()));
            _legacyConfig.setInnerSource(config);
        }

        private final Config loadNewConfig() {
            Config config = ConfigFactory.parseApplicationReplacement().orElse(ConfigFactory.empty()).withFallback((ConfigMergeable)ConfigFactory.parseResourcesAnySyntax((String)"application")).withFallback((ConfigMergeable)ConfigFactory.defaultReference()).resolve();
            Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"ConfigFactory.parseAppli\u2026               .resolve()");
            return config;
        }

        public final void reloadNewConfig() {
            this.getLogger().info((Object)("Reloading the Typesafe config source (previously reloaded " + numTypesafeReloads + " times)."));
            ConfigFactory.invalidateCaches();
            int n = numTypesafeReloads;
            numTypesafeReloads = n + 1;
            this.setTypesafeConfig(new TypesafeConfigSource("typesafe config (reloaded " + numTypesafeReloads + " times)", this.loadNewConfig()));
            _newConfig.setInnerSource(this.getTypesafeConfig());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

