/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.osgi.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.text.StringTokenizer;
import org.apache.commons.text.matcher.StringMatcher;
import org.apache.commons.text.matcher.StringMatcherFactory;

public class BundleClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = Logger.getLogger(BundleClassLoader.class.getName());
    private final ClassLoader parent;
    private final Map<URI, List<File>> nativeLibraries = new HashMap<URI, List<File>>();
    private File nativeLibTempDir;

    public BundleClassLoader(ClassLoader parent) {
        super((URL[])Stream.of(System.getProperty("java.class.path").split(System.getProperty("path.separator"))).map(cp -> {
            try {
                return new File((String)cp).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new), (ClassLoader)null);
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            try {
                return name.startsWith("java.") ? this.parent.loadClass(name) : super.loadClass(name);
            }
            catch (ClassNotFoundException cnf) {
                return this.parent.loadClass(name);
            }
        }
    }

    @Override
    protected String findLibrary(String libname) {
        URI callerUrl;
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        Optional callerOpt = walker.walk(frames -> frames.dropWhile(f -> f.getDeclaringClass().getPackageName().startsWith("java.") || f.getDeclaringClass() == this.getClass()).findFirst().map(StackWalker.StackFrame::getDeclaringClass));
        if (callerOpt.isEmpty()) {
            return null;
        }
        Class caller = (Class)callerOpt.get();
        try {
            callerUrl = caller.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        List libs = this.nativeLibraries.computeIfAbsent(callerUrl, key -> {
            List<String> paths = this.loadNativeLibraries(caller);
            boolean found = false;
            for (String path : paths) {
                if (!System.mapLibraryName(libname).equals(new File(path).getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
            if (this.nativeLibTempDir == null) {
                this.nativeLibTempDir = new File(SystemUtils.getJavaIoTmpDir(), "jitsi-native-" + UUID.randomUUID());
                if (!this.nativeLibTempDir.mkdirs()) {
                    LOGGER.log(Level.SEVERE, "Could not create temp dir {0} for native libs", this.nativeLibTempDir.getAbsolutePath());
                    this.nativeLibTempDir = null;
                    return null;
                }
            }
            ArrayList<File> libPaths = new ArrayList<File>(paths.size());
            for (String path : paths) {
                URL libUrl = caller.getResource("/" + path);
                if (libUrl == null) continue;
                try {
                    File dest = new File(this.nativeLibTempDir, new File(path).getName());
                    IOUtils.copy((URL)libUrl, (File)dest);
                    libPaths.add(dest);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Could not extract lib", e);
                }
            }
            return libPaths;
        });
        if (libs != null) {
            for (File lib : libs) {
                if (!System.mapLibraryName(libname).equals(lib.getName())) continue;
                return lib.getAbsolutePath();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> loadNativeLibraries(Class<?> caller) {
        Object resources;
        URL mfResource = null;
        try {
            URL classSource = caller.getProtectionDomain().getCodeSource().getLocation();
            resources = caller.getClassLoader().getResources("META-INF/MANIFEST.MF").asIterator();
            while (resources.hasNext()) {
                int resPos;
                URL res = resources.next();
                String resPath = res.toString();
                if (resPath.startsWith("jar:")) {
                    resPath = resPath.substring(4);
                }
                if ((resPos = resPath.indexOf(33)) > -1) {
                    resPath = resPath.substring(0, resPos);
                }
                if (!resPath.equals(classSource.toString())) continue;
                mfResource = res;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (mfResource == null) {
            return Collections.emptyList();
        }
        try (InputStream s = mfResource.openStream();){
            Object arrayList;
            ArrayList<String> paths;
            if (s == null) {
                resources = Collections.emptyList();
                return resources;
            }
            Manifest mf = new Manifest(s);
            String nativeCodeNames = mf.getMainAttributes().getValue("Bundle-NativeCode");
            StringMatcher spaceIgnore = StringMatcherFactory.INSTANCE.charSetMatcher(new char[]{'\r', '\n', ' '});
            StringTokenizer filterSt = new StringTokenizer(nativeCodeNames, ',', '\"');
            filterSt.setIgnoredMatcher(spaceIgnore);
            ArrayList<NativeLibs> nativeLibs = new ArrayList<NativeLibs>();
            Iterator iterator = filterSt.getTokenList().iterator();
            while (true) {
                Iterator iterator2;
                String processor;
                String osName;
                ArrayList<String> paths2;
                if (iterator.hasNext()) {
                    String filter = (String)iterator.next();
                    paths2 = new ArrayList<String>();
                    osName = "";
                    processor = "";
                    StringTokenizer clauseSt = new StringTokenizer(filter, ';');
                    clauseSt.setIgnoredMatcher(spaceIgnore);
                    iterator2 = clauseSt.getTokenList().iterator();
                } else {
                    paths = new ArrayList<String>();
                    arrayList = nativeLibs.iterator();
                    break;
                }
                block20: while (iterator2.hasNext()) {
                    String clause = (String)iterator2.next();
                    if (clause.indexOf(61) == -1) {
                        paths2.add(clause.charAt(0) == '/' ? clause.substring(1) : clause);
                        continue;
                    }
                    StringTokenizer filterClauseSt = new StringTokenizer(clause, '=', '\"');
                    filterClauseSt.setIgnoredMatcher(spaceIgnore);
                    String[] filterClauseTokens = filterClauseSt.getTokenArray();
                    switch (filterClauseTokens[0]) {
                        case "osname": {
                            osName = filterClauseTokens[1].toLowerCase(Locale.ROOT);
                            break;
                        }
                        case "processor": {
                            processor = filterClauseTokens[1].toLowerCase(Locale.ROOT);
                            continue block20;
                        }
                    }
                }
                nativeLibs.add(new NativeLibs(paths2, osName, processor));
            }
            while (arrayList.hasNext()) {
                NativeLibs nl = (NativeLibs)arrayList.next();
                if (!nl.matchesThisOs() || !nl.matchesThisProcessor()) continue;
                paths.addAll(nl.paths);
            }
            arrayList = paths;
            return arrayList;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to extract manifest", e);
            return Collections.emptyList();
        }
    }

    private static class NativeLibs {
        private final List<String> paths;
        private final String osName;
        private final String processor;

        boolean matchesThisOs() {
            switch (this.osName) {
                case "linux": {
                    return SystemUtils.IS_OS_UNIX;
                }
                case "win32": {
                    return SystemUtils.IS_OS_WINDOWS;
                }
                case "macos": 
                case "macosx": {
                    return SystemUtils.IS_OS_MAC;
                }
            }
            return false;
        }

        boolean matchesThisProcessor() {
            switch (this.processor) {
                case "x86": 
                case "pentium": 
                case "i386": 
                case "i486": 
                case "i586": 
                case "i686": {
                    return SystemUtils.OS_ARCH.equals("x86");
                }
                case "x86-64": 
                case "amd64": 
                case "em64t": 
                case "x86_64": {
                    return SystemUtils.OS_ARCH.equals("amd64");
                }
                case "aarch64": 
                case "arm64": {
                    return SystemUtils.OS_ARCH.equals("aarch64");
                }
                case "powerpc-64-le": 
                case "ppc64le": 
                case "ppc64el": {
                    return SystemUtils.OS_ARCH.equals("ppc64le") || SystemUtils.OS_ARCH.equals("ppc64el") || SystemUtils.OS_ARCH.equals("ppc64") && "little".equalsIgnoreCase(System.getProperty("sun.cpu.endian"));
                }
            }
            return false;
        }

        public NativeLibs(List<String> paths, String osName, String processor) {
            this.paths = paths;
            this.osName = osName;
            this.processor = processor;
        }
    }
}

