/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.osgi.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.jitsi.impl.osgi.framework.BundleContextImpl;
import org.jitsi.impl.osgi.framework.launch.FrameworkImpl;
import org.jitsi.impl.osgi.framework.startlevel.BundleStartLevelImpl;
import org.jitsi.osgi.framework.BundleActivatorHolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;

public class BundleImpl
implements Bundle,
BundleActivatorHolder {
    private static final Logger logger = Logger.getLogger(BundleImpl.class.getName());
    private final List<Class<? extends BundleActivator>> bundleActivatorClasses = new ArrayList<Class<? extends BundleActivator>>();
    private final List<BundleActivator> bundleActivators = new ArrayList<BundleActivator>();
    private Dictionary<String, String> headers;
    private BundleContext bundleContext;
    private final long bundleId;
    private final BundleStartLevel bundleStartLevel = new BundleStartLevelImpl(this);
    private final FrameworkImpl framework;
    private final String location;
    protected final ClassLoader classLoader;
    private volatile int state = 2;

    public BundleImpl(FrameworkImpl framework, long bundleId, String location, ClassLoader classLoader) {
        this.framework = framework;
        this.bundleId = bundleId;
        this.location = location;
        this.classLoader = classLoader;
        Enumeration<URL> urls = this.findEntries("META-INF", "MANIFEST.MF", false);
        if (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            try (InputStream s = url.openStream();){
                Manifest m = new Manifest(s);
                this.headers = new Hashtable<String, String>(m.getMainAttributes().entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString())));
            }
            catch (IOException ex) {
                this.headers = new Hashtable<String, String>();
                logger.log(Level.WARNING, "Could not read headers from manifest", ex);
            }
        } else {
            this.headers = new Hashtable<String, String>();
        }
        this.headers.put("Location", location);
    }

    public <A> A adapt(Class<A> type) {
        if (BundleStartLevel.class.equals(type)) {
            if (this.getBundleId() == 0L) {
                return null;
            }
            return (A)this.bundleStartLevel;
        }
        if (BundleActivatorHolder.class.equals(type)) {
            return (A)this;
        }
        return null;
    }

    public int compareTo(Bundle other) {
        long thisBundleId = this.getBundleId();
        long otherBundleId = other.getBundleId();
        return Long.compare(thisBundleId, otherBundleId);
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        File f;
        if (this.location == null) {
            return Collections.emptyEnumeration();
        }
        try {
            f = new File(new URI(this.location));
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "Could not get bundle URI from " + this.location, e);
            return Collections.emptyEnumeration();
        }
        if (f.exists()) {
            List<URL> matches;
            if (((String)path).startsWith("/")) {
                path = ((String)path).substring(1);
            }
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            if (f.isFile() && f.getName().endsWith(".jar")) {
                matches = this.getJarEntries((String)path, filePattern, recurse, f);
            } else if (f.isDirectory()) {
                matches = this.getDirectoryEntries((String)path, filePattern, f);
            } else {
                logger.log(Level.SEVERE, this.location + " is neither a file nor a directory");
                return Collections.emptyEnumeration();
            }
            if (matches == null) {
                return Collections.emptyEnumeration();
            }
            final Iterator<URL> it = matches.iterator();
            return new Enumeration<URL>(){

                @Override
                public boolean hasMoreElements() {
                    return it.hasNext();
                }

                @Override
                public URL nextElement() {
                    return (URL)it.next();
                }
            };
        }
        return Collections.emptyEnumeration();
    }

    private List<URL> getJarEntries(String path, String filePattern, boolean recurse, File f) {
        List<URL> list;
        ZipFile z = new ZipFile(f);
        try {
            WildcardFileFilter filter = new WildcardFileFilter(filePattern == null ? "*" : filePattern);
            list = z.stream().filter(e -> recurse ? e.getName().startsWith(path) : e.getName().equals(path) && filter.accept(new File(e.getName()))).map(e -> {
                try {
                    return new URL(e.getName());
                }
                catch (MalformedURLException ex) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    z.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                logger.log(Level.SEVERE, "Could not open " + this.location, e2);
                return null;
            }
        }
        z.close();
        return list;
    }

    private List<URL> getDirectoryEntries(String path, String filePattern, File f) {
        WildcardFileFilter fileFilter = new WildcardFileFilter(filePattern == null ? "*" : filePattern);
        AccumulatorPathVisitor visitor = AccumulatorPathVisitor.withLongCounters((PathFilter)fileFilter, (PathFilter)FileFilterUtils.trueFileFilter());
        try {
            File dir = new File(f, path);
            if (!dir.exists()) {
                return Collections.emptyList();
            }
            Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)visitor);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Could not walk files in " + this.location, e);
            return null;
        }
        if (!visitor.getFileList().isEmpty()) {
            return visitor.getFileList().stream().map(r -> {
                try {
                    return r.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return null;
    }

    public BundleContext getBundleContext() {
        switch (this.getState()) {
            case 8: 
            case 16: 
            case 32: {
                return this.bundleContext;
            }
        }
        return null;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public File getDataFile(String filename) {
        throw new UnsupportedOperationException();
    }

    public URL getEntry(String path) {
        throw new UnsupportedOperationException();
    }

    public Enumeration<String> getEntryPaths(String path) {
        throw new UnsupportedOperationException();
    }

    public FrameworkImpl getFramework() {
        return this.framework;
    }

    public Dictionary<String, String> getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        return this.headers;
    }

    public long getLastModified() {
        throw new UnsupportedOperationException();
    }

    public String getLocation() {
        return this.getBundleId() == 0L ? "System Bundle" : this.location;
    }

    public ServiceReference<?>[] getRegisteredServices() {
        return this.framework.getRegisteredServices();
    }

    public URL getResource(String name) {
        throw new UnsupportedOperationException();
    }

    public Enumeration<URL> getResources(String name) {
        throw new UnsupportedOperationException();
    }

    public ServiceReference<?>[] getServicesInUse() {
        throw new UnsupportedOperationException();
    }

    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        throw new UnsupportedOperationException();
    }

    public int getState() {
        return this.state;
    }

    public String getSymbolicName() {
        return Objects.requireNonNullElse(this.headers.get("Bundle-SymbolicName"), Long.toString(this.bundleId));
    }

    public Version getVersion() {
        throw new UnsupportedOperationException();
    }

    public boolean hasPermission(Object permission) {
        throw new UnsupportedOperationException();
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.classLoader.loadClass(name);
    }

    protected void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void setState(int state) {
        int oldState = this.getState();
        if (oldState != state) {
            this.state = state;
            int newState = this.getState();
            if (oldState != newState) {
                this.stateChanged(oldState, newState);
            }
        }
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void start(int options) throws BundleException {
        if (this.getState() == 1) {
            throw new IllegalStateException("Bundle.UNINSTALLED");
        }
        BundleStartLevel bundleStartLevel = this.adapt(BundleStartLevel.class);
        FrameworkStartLevel frameworkStartLevel = this.getFramework().adapt(FrameworkStartLevel.class);
        if (bundleStartLevel != null && bundleStartLevel.getStartLevel() > frameworkStartLevel.getStartLevel()) {
            if ((options & 1) == 1) {
                throw new BundleException("startLevel");
            }
            return;
        }
        if (this.getState() == 32) {
            return;
        }
        if (this.getState() == 2) {
            this.setState(4);
        }
        this.setState(8);
        try {
            for (Class<? extends BundleActivator> activatorClass : this.bundleActivatorClasses) {
                logger.log(Level.INFO, "Starting activator " + activatorClass.getName() + " in " + this.location);
                BundleActivator activator = activatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                activator.start(this.getBundleContext());
                this.bundleActivators.add(activator);
            }
        }
        catch (Exception t) {
            logger.log(Level.SEVERE, "Error starting bundle: " + this.getLocation(), t);
            this.setState(16);
            this.setState(4);
            this.getFramework().fireBundleEvent(4, this);
            throw new BundleException("BundleActivator.start", (Throwable)t);
        }
        if (this.getState() == 1) {
            throw new IllegalStateException("Bundle.UNINSTALLED");
        }
        this.setState(32);
    }

    protected void stateChanged(int oldState, int newState) {
        switch (newState) {
            case 32: {
                this.getFramework().fireBundleEvent(2, this);
                break;
            }
            case 4: {
                this.setBundleContext(null);
                break;
            }
            case 8: {
                this.setBundleContext(new BundleContextImpl(this.getFramework(), this));
                break;
            }
        }
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    public void stop(int options) throws BundleException {
        boolean wasActive = false;
        switch (this.getState()) {
            case 32: {
                wasActive = true;
            }
            case 8: {
                this.setState(16);
                Exception exception = null;
                if (wasActive) {
                    for (BundleActivator activator : this.bundleActivators) {
                        try {
                            activator.stop(this.getBundleContext());
                        }
                        catch (Exception t) {
                            exception = t;
                        }
                    }
                }
                if (this.getState() == 1) {
                    throw new BundleException("Bundle.UNINSTALLED");
                }
                this.setState(4);
                this.getFramework().fireBundleEvent(4, this);
                if (exception == null) break;
                throw new BundleException("BundleActivator.stop", (Throwable)exception);
            }
            case 1: {
                throw new IllegalStateException("Bundle.UNINSTALLED");
            }
        }
    }

    public void uninstall() {
        throw new UnsupportedOperationException();
    }

    public void update() throws BundleException {
        this.update(null);
    }

    public void update(InputStream input) throws BundleException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBundleActivator(Class<? extends BundleActivator> activatorClass) {
        this.bundleActivatorClasses.add(activatorClass);
    }
}

