/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.osgi.framework;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import org.jitsi.impl.osgi.framework.BundleImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistrationImpl<S>
implements ServiceRegistration<S> {
    private static final Map<String, Object> EMPTY_PROPERTIES = ServiceRegistrationImpl.newCaseInsensitiveMapInstance();
    private final BundleImpl bundle;
    private final String[] classNames;
    private final Map<String, Object> properties;
    private final S service;
    private final long serviceId;
    private final ServiceReferenceImpl serviceReference = new ServiceReferenceImpl();

    public ServiceRegistrationImpl(BundleImpl bundle, long serviceId, String[] classNames, S service, Dictionary<String, ?> properties) {
        this.bundle = bundle;
        this.serviceId = serviceId;
        this.classNames = classNames;
        this.service = service;
        if (properties == null || properties.isEmpty()) {
            this.properties = EMPTY_PROPERTIES;
        } else {
            Enumeration<String> keys = properties.keys();
            Map<String, Object> thisProperties = ServiceRegistrationImpl.newCaseInsensitiveMapInstance();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if ("objectClass".equalsIgnoreCase(key) || "service.id".equalsIgnoreCase(key)) continue;
                if (thisProperties.containsKey(key)) {
                    throw new IllegalArgumentException(key);
                }
                thisProperties.put(key, properties.get(key));
            }
            this.properties = thisProperties.isEmpty() ? EMPTY_PROPERTIES : thisProperties;
        }
    }

    public ServiceReference<S> getReference() {
        return this.serviceReference;
    }

    private static Map<String, Object> newCaseInsensitiveMapInstance() {
        return new TreeMap<String, Object>(String::compareToIgnoreCase);
    }

    public void setProperties(Dictionary properties) {
        throw new UnsupportedOperationException();
    }

    public void unregister() {
        this.bundle.getFramework().unregisterService(this.bundle, this);
    }

    class ServiceReferenceImpl
    implements ServiceReference<S> {
        ServiceReferenceImpl() {
        }

        public int compareTo(Object other) {
            Long otherServiceId = ((ServiceRegistrationImpl)other).serviceId;
            return otherServiceId.compareTo(ServiceRegistrationImpl.this.serviceId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dictionary<String, Object> getProperties() {
            Map<String, Object> map = ServiceRegistrationImpl.this.properties;
            synchronized (map) {
                Hashtable<String, Object> dict = new Hashtable<String, Object>(ServiceRegistrationImpl.this.properties.size());
                for (Map.Entry<String, Object> e : ServiceRegistrationImpl.this.properties.entrySet()) {
                    ((Dictionary)dict).put(e.getKey(), e.getValue());
                }
                return dict;
            }
        }

        public <A> A adapt(Class<A> type) {
            throw new UnsupportedOperationException();
        }

        public Bundle getBundle() {
            return ServiceRegistrationImpl.this.bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getProperty(String key) {
            Object value;
            if ("objectClass".equalsIgnoreCase(key)) {
                value = ServiceRegistrationImpl.this.classNames;
            } else if ("service.id".equalsIgnoreCase(key)) {
                value = ServiceRegistrationImpl.this.serviceId;
            } else {
                Map<String, Object> map = ServiceRegistrationImpl.this.properties;
                synchronized (map) {
                    value = ServiceRegistrationImpl.this.properties.get(key);
                }
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getPropertyKeys() {
            Map<String, Object> map = ServiceRegistrationImpl.this.properties;
            synchronized (map) {
                String[] keys = new String[2 + ServiceRegistrationImpl.this.properties.size()];
                int index = 0;
                keys[index++] = "objectClass";
                keys[index++] = "service.id";
                for (String key : ServiceRegistrationImpl.this.properties.keySet()) {
                    keys[index++] = key;
                }
                return keys;
            }
        }

        S getService() {
            return ServiceRegistrationImpl.this.service;
        }

        public Bundle[] getUsingBundles() {
            throw new UnsupportedOperationException();
        }

        public boolean isAssignableTo(Bundle bundle, String className) {
            throw new UnsupportedOperationException();
        }
    }
}

