/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.osgi.framework.launch;

import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jitsi.impl.osgi.framework.launch.EventListenerList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class EventDispatcher {
    private static final Logger logger = Logger.getLogger(EventDispatcher.class.getName());
    private final EventListenerList listeners = new EventListenerList();

    public <T extends EventListener> boolean addListener(Bundle bundle, Class<T> clazz, T listener, Filter filter) {
        return this.listeners.add(bundle, clazz, listener, filter);
    }

    public <T extends EventListener> boolean removeListener(Bundle bundle, Class<T> clazz, T listener) {
        return this.listeners.remove(bundle, clazz, listener);
    }

    public boolean removeListeners(Bundle bundle) {
        return this.listeners.removeAll(bundle);
    }

    void fireBundleEvent(BundleEvent event) {
        this.fireEvent(BundleListener.class, (EventObject)event);
    }

    void fireServiceEvent(ServiceEvent event) {
        this.fireEvent(ServiceListener.class, (EventObject)event);
    }

    void fireFrameworkEvent(FrameworkEvent event) {
        this.fireEvent(FrameworkListener.class, (EventObject)event);
    }

    private <T extends EventListener> void fireEvent(Class<T> clazz, EventObject event) {
        try {
            ForkJoinPool.commonPool().execute(new Command(clazz, event));
        }
        catch (RejectedExecutionException ree) {
            logger.log(Level.SEVERE, "Error firing event", ree);
        }
    }

    private class Command
    implements Runnable {
        private final Class<? extends EventListener> clazz;
        private final EventObject event;

        public <T extends EventListener> Command(Class<T> clazz, EventObject event) {
            this.clazz = clazz;
            this.event = event;
        }

        @Override
        public void run() {
            List<? extends EventListener> listeners = EventDispatcher.this.listeners.getListeners(this.clazz, this.event);
            for (EventListener eventListener : listeners) {
                try {
                    if (BundleListener.class.equals(this.clazz)) {
                        ((BundleListener)eventListener).bundleChanged((BundleEvent)this.event);
                        continue;
                    }
                    if (ServiceListener.class.equals(this.clazz)) {
                        ((ServiceListener)eventListener).serviceChanged((ServiceEvent)this.event);
                        continue;
                    }
                    if (!FrameworkListener.class.equals(this.clazz)) continue;
                    ((FrameworkListener)eventListener).frameworkEvent((FrameworkEvent)this.event);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Error dispatching event", t);
                }
            }
        }
    }
}

