/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.osgi.framework.launch;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceEvent;

public class EventListenerList {
    private final List<Element<?>> elements = new LinkedList();

    public synchronized <T extends EventListener> boolean add(Bundle bundle, Class<T> clazz, T listener, Filter filter) {
        if (bundle == null) {
            throw new NullPointerException("bundle");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        int index = this.indexOf(bundle, clazz, listener);
        if (index == -1) {
            return this.elements.add(new Element<T>(bundle, clazz, listener, filter));
        }
        return false;
    }

    public synchronized <T extends EventListener> List<T> getListeners(Class<T> clazz, EventObject event) {
        ArrayList eventListeners = new ArrayList(this.elements.size());
        for (Element<?> element : this.elements) {
            if (element.clazz != clazz || event instanceof ServiceEvent && element.filter != null && !element.filter.match(((ServiceEvent)event).getServiceReference())) continue;
            eventListeners.add(element.listener);
        }
        return eventListeners;
    }

    private synchronized <T extends EventListener> int indexOf(Bundle bundle, Class<T> clazz, T listener) {
        int count = this.elements.size();
        for (int index = 0; index < count; ++index) {
            Element<?> element = this.elements.get(index);
            if (!element.bundle.equals(bundle) || element.clazz != clazz || element.listener != listener) continue;
            return index;
        }
        return -1;
    }

    public synchronized <T extends EventListener> boolean remove(Bundle bundle, Class<T> clazz, T listener) {
        int index = this.indexOf(bundle, clazz, listener);
        if (index == -1) {
            return false;
        }
        this.elements.remove(index);
        return true;
    }

    public synchronized boolean removeAll(Bundle bundle) {
        boolean changed = false;
        int index = 0;
        int count = this.elements.size();
        while (index < count) {
            if (this.elements.get((int)index).bundle.equals(bundle) && this.elements.remove(index) != null) {
                changed = true;
                continue;
            }
            ++index;
        }
        return changed;
    }

    private static class Element<T extends EventListener> {
        public final Bundle bundle;
        public final Class<T> clazz;
        public final T listener;
        public final Filter filter;

        public Element(Bundle bundle, Class<T> clazz, T listener, Filter filter) {
            this.bundle = bundle;
            this.clazz = clazz;
            this.listener = listener;
            this.filter = filter;
        }
    }
}

