/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.osgi.framework.launch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jitsi.impl.osgi.framework.BundleClassLoader;
import org.jitsi.impl.osgi.framework.BundleImpl;
import org.jitsi.impl.osgi.framework.ServiceRegistrationImpl;
import org.jitsi.impl.osgi.framework.launch.EventDispatcher;
import org.jitsi.impl.osgi.framework.startlevel.FrameworkStartLevelImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;

public class FrameworkImpl
extends BundleImpl
implements Framework {
    private final Logger logger = Logger.getLogger(FrameworkImpl.class.getName());
    private final List<BundleImpl> bundles = new LinkedList<BundleImpl>();
    private final Map<String, String> configuration;
    private EventDispatcher eventDispatcher;
    private final FrameworkStartLevelImpl frameworkStartLevel = new FrameworkStartLevelImpl(this);
    private long nextBundleId = 1L;
    private long nextServiceId = 1L;
    private final List<ServiceRegistrationImpl<?>> serviceRegistrations = new LinkedList();
    private final Object stopEvent = new Object();
    private final List<FrameworkListener> frameworkListeners = Collections.synchronizedList(new ArrayList());

    public FrameworkImpl(Map<String, String> configuration, ClassLoader classLoader) {
        super(null, 0L, FrameworkImpl.class.getProtectionDomain().getCodeSource().getLocation().toString(), classLoader);
        this.configuration = configuration;
        this.bundles.add(this);
    }

    @Override
    public <A> A adapt(Class<A> type) {
        if (FrameworkStartLevel.class.equals(type)) {
            return (A)this.frameworkStartLevel;
        }
        return super.adapt(type);
    }

    public void addBundleListener(BundleImpl origin, BundleListener listener) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.addListener(origin, BundleListener.class, listener, null);
        }
    }

    public void addServiceListener(BundleImpl origin, ServiceListener listener, Filter filter) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.addListener(origin, ServiceListener.class, listener, filter);
        }
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.frameworkListeners.add(listener);
    }

    public void fireBundleEvent(int type, Bundle bundle) {
        this.fireBundleEvent(type, bundle, bundle);
    }

    private void fireBundleEvent(int type, Bundle bundle, Bundle origin) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.fireBundleEvent(new BundleEvent(type, bundle, origin));
        }
    }

    private void fireFrameworkEvent(int type, FrameworkListener ... listeners) {
        FrameworkEvent event = new FrameworkEvent(type, (Bundle)this, null);
        if (listeners != null && listeners.length != 0) {
            for (FrameworkListener listener : listeners) {
                try {
                    listener.frameworkEvent(event);
                }
                catch (Exception t) {
                    this.logger.log(Level.SEVERE, "Error firing framework event", t);
                }
            }
        }
        for (FrameworkListener listener : this.frameworkListeners) {
            try {
                listener.frameworkEvent(event);
            }
            catch (Exception t) {
                this.logger.log(Level.SEVERE, "Error firing framework event", t);
            }
        }
    }

    private void fireServiceEvent(int type, ServiceReference<?> reference) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.fireServiceEvent(new ServiceEvent(type, reference));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleImpl getBundle(long id) {
        if (id == 0L) {
            return this;
        }
        List<BundleImpl> list = this.bundles;
        synchronized (list) {
            for (BundleImpl bundle : this.bundles) {
                if (bundle.getBundleId() != id) continue;
                return bundle;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BundleImpl> getBundlesByStartLevel(int startLevel) {
        LinkedList<BundleImpl> bundles = new LinkedList<BundleImpl>();
        List<BundleImpl> list = this.bundles;
        synchronized (list) {
            for (BundleImpl bundle : this.bundles) {
                BundleStartLevel bundleStartLevel = bundle.adapt(BundleStartLevel.class);
                if (bundleStartLevel == null || bundleStartLevel.getStartLevel() != startLevel) continue;
                bundles.add(bundle);
            }
        }
        return bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getBundles() {
        List<BundleImpl> list = this.bundles;
        synchronized (list) {
            return this.bundles.toArray(new Bundle[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> Collection<ServiceReference<S>> getServiceReferences(BundleImpl origin, String className, Filter filter, boolean checkAssignable) throws InvalidSyntaxException {
        Filter classNameFilter = FrameworkUtil.createFilter((String)("(objectClass=" + (Serializable)(className == null ? Character.valueOf('*') : className) + ")"));
        LinkedList<ServiceReference<S>> serviceReferences = new LinkedList<ServiceReference<S>>();
        List<ServiceRegistrationImpl<?>> list = this.serviceRegistrations;
        synchronized (list) {
            for (ServiceRegistrationImpl<?> serviceRegistration : this.serviceRegistrations) {
                ServiceReference<?> serviceReference = serviceRegistration.getReference();
                if (!classNameFilter.match(serviceReference) || filter != null && !filter.match(serviceReference)) continue;
                serviceReferences.add(serviceReference);
            }
        }
        return serviceReferences;
    }

    @Override
    public FrameworkImpl getFramework() {
        return this;
    }

    private long getNextBundleId() {
        return this.nextBundleId++;
    }

    public void init() throws BundleException {
        this.init(null);
    }

    public void init(FrameworkListener ... listeners) throws BundleException {
        if (listeners != null) {
            this.frameworkListeners.addAll(Arrays.asList(listeners));
        }
        this.setState(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle installBundle(BundleImpl origin, String location) throws BundleException {
        if (location == null) {
            throw new BundleException("location");
        }
        BundleImpl bundle = null;
        boolean fireBundleEvent = false;
        List<BundleImpl> list = this.bundles;
        synchronized (list) {
            for (BundleImpl existing : this.bundles) {
                if (!existing.getLocation().equals(location)) continue;
                bundle = existing;
                break;
            }
            if (bundle == null) {
                bundle = new BundleImpl(this.getFramework(), this.getNextBundleId(), location, new BundleClassLoader(this.classLoader));
                this.bundles.add(bundle);
                fireBundleEvent = true;
            }
        }
        if (fireBundleEvent) {
            this.fireBundleEvent(1, bundle, origin);
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ServiceRegistration<T> registerService(BundleImpl origin, String[] classNames, T service, Dictionary<String, ?> properties) {
        if (classNames == null || classNames.length == 0) {
            throw new IllegalArgumentException("classNames");
        }
        if (service == null) {
            throw new IllegalArgumentException("service is null for " + Arrays.toString(classNames));
        }
        Class<?> serviceClass = service.getClass();
        if (!ServiceFactory.class.isAssignableFrom(serviceClass)) {
            ClassLoader classLoader = serviceClass.getClassLoader();
            for (String className : classNames) {
                boolean illegalArgumentException = true;
                Throwable cause = null;
                try {
                    if (Class.forName(className, false, classLoader).isAssignableFrom(serviceClass)) {
                        illegalArgumentException = false;
                    }
                }
                catch (ClassNotFoundException | LinkageError eiie) {
                    cause = eiie;
                }
                if (!illegalArgumentException) continue;
                throw new IllegalArgumentException(className, cause);
            }
        }
        String[] stringArray = this.serviceRegistrations;
        synchronized (this.serviceRegistrations) {
            long serviceId = this.nextServiceId++;
            // ** MonitorExit[var7_8] (shouldn't be in output)
            ServiceRegistrationImpl<T> serviceRegistration = new ServiceRegistrationImpl<T>(origin, serviceId, classNames, service, properties);
            List<ServiceRegistrationImpl<?>> list = this.serviceRegistrations;
            synchronized (list) {
                this.serviceRegistrations.add(serviceRegistration);
            }
            this.fireServiceEvent(1, serviceRegistration.getReference());
            return serviceRegistration;
        }
    }

    public void removeBundleListener(BundleImpl origin, BundleListener listener) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.removeListener(origin, BundleListener.class, listener);
        }
    }

    public void removeServiceListener(BundleImpl origin, ServiceListener listener) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.removeListener(origin, ServiceListener.class, listener);
        }
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.frameworkListeners.remove(listener);
    }

    @Override
    public void start(int options) throws BundleException {
        int state = this.getState();
        if (state == 2 || state == 4) {
            this.init();
            state = this.getState();
        }
        if (state == 8) {
            String s;
            int startLevel = 1;
            if (this.configuration != null && (s = this.configuration.get("org.osgi.framework.startlevel.beginning")) != null) {
                try {
                    startLevel = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Semaphore startLevelAwaiter = new Semaphore(0);
            this.frameworkStartLevel.setStartLevel(startLevel, event -> startLevelAwaiter.release());
            while (this.frameworkStartLevel.getStartLevel() < startLevel) {
                try {
                    startLevelAwaiter.acquire();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            this.setState(32);
            this.fireFrameworkEvent(1, new FrameworkListener[0]);
        }
    }

    public void startLevelChanged(int oldStartLevel, int newStartLevel, FrameworkListener ... listeners) {
        if (oldStartLevel < newStartLevel) {
            for (BundleImpl bundle : this.getBundlesByStartLevel(newStartLevel)) {
                try {
                    BundleStartLevel bundleStartLevel = bundle.adapt(BundleStartLevel.class);
                    int options = 1;
                    bundle.start(options);
                }
                catch (Exception t) {
                    this.logger.log(Level.SEVERE, "Error changing start level", t);
                }
            }
        }
        this.fireFrameworkEvent(8, listeners);
    }

    public void startLevelChanging(int oldStartLevel, int newStartLevel) {
        if (oldStartLevel > newStartLevel) {
            for (BundleImpl bundle : this.getBundlesByStartLevel(oldStartLevel)) {
                try {
                    bundle.stop(1);
                }
                catch (Exception t) {
                    this.logger.log(Level.SEVERE, "Error changing start level", t);
                }
            }
        }
    }

    @Override
    protected void stateChanged(int oldState, int newState) {
        switch (newState) {
            case 4: {
                this.eventDispatcher = null;
                break;
            }
            case 8: {
                this.eventDispatcher = new EventDispatcher();
            }
        }
        super.stateChanged(oldState, newState);
    }

    @Override
    public void stop(int options) throws BundleException {
        this.logger.fine("Stopping framework");
        this.setState(16);
        this.logger.fine("Waiting for framework stop event");
        this.frameworkStartLevel.internalSetStartLevel(0, event -> {
            this.setState(4);
            this.fireFrameworkEvent(64, new FrameworkListener[0]);
            Object object = this.stopEvent;
            synchronized (object) {
                this.stopEvent.notifyAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(BundleImpl origin, ServiceRegistration<?> serviceRegistration) {
        boolean removed;
        List<ServiceRegistrationImpl<?>> list = this.serviceRegistrations;
        synchronized (list) {
            removed = this.serviceRegistrations.remove(serviceRegistration);
        }
        if (!removed) {
            throw new IllegalStateException("serviceRegistrations");
        }
        this.fireServiceEvent(4, serviceRegistration.getReference());
    }

    @Override
    public ServiceReference<?>[] getRegisteredServices() {
        ServiceReference[] references = new ServiceReference[this.serviceRegistrations.size()];
        for (int i = 0; i < this.serviceRegistrations.size(); ++i) {
            references[i] = this.serviceRegistrations.get(i).getReference();
        }
        return references;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        long start = System.nanoTime();
        long timeoutNanos = TimeUnit.MILLISECONDS.toNanos(timeout);
        Object object = this.stopEvent;
        synchronized (object) {
            if (timeout > 0L && System.nanoTime() - start > timeoutNanos) {
                return new FrameworkEvent(512, (Bundle)this, null);
            }
            while (this.getState() != 4) {
                this.stopEvent.wait(timeout);
            }
        }
        return new FrameworkEvent(64, (Bundle)this, null);
    }
}

