/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.osgi.framework.startlevel;

import java.util.concurrent.ForkJoinPool;
import org.jitsi.impl.osgi.framework.launch.FrameworkImpl;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.FrameworkStartLevel;

public class FrameworkStartLevelImpl
implements FrameworkStartLevel {
    private final FrameworkImpl framework;
    private int initialBundleStartLevel = 0;
    private int startLevel;

    public FrameworkStartLevelImpl(FrameworkImpl framework) {
        this.framework = framework;
    }

    public FrameworkImpl getBundle() {
        return this.framework;
    }

    public int getInitialBundleStartLevel() {
        int initialBundleStartLevel = this.initialBundleStartLevel;
        if (initialBundleStartLevel == 0) {
            initialBundleStartLevel = 1;
        }
        return initialBundleStartLevel;
    }

    public synchronized int getStartLevel() {
        return this.startLevel;
    }

    public void internalSetStartLevel(int startLevel, FrameworkListener ... listeners) {
        if (startLevel < 0) {
            throw new IllegalArgumentException("startLevel");
        }
        ForkJoinPool.commonPool().execute(new Command(startLevel, listeners));
    }

    public void setInitialBundleStartLevel(int initialBundleStartLevel) {
        if (initialBundleStartLevel <= 0) {
            throw new IllegalArgumentException("initialBundleStartLevel");
        }
        this.initialBundleStartLevel = initialBundleStartLevel;
    }

    public void setStartLevel(int startLevel, FrameworkListener ... listeners) {
        if (startLevel == 0) {
            throw new IllegalArgumentException("startLevel");
        }
        this.internalSetStartLevel(startLevel, listeners);
    }

    private class Command
    implements Runnable {
        private final FrameworkListener[] listeners;
        private final int startLevel;

        public Command(int startLevel, FrameworkListener ... listeners) {
            this.startLevel = startLevel;
            this.listeners = listeners;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int startLevel = FrameworkStartLevelImpl.this.getStartLevel();
            if (startLevel < this.startLevel) {
                for (int intermediateStartLevel = startLevel + 1; intermediateStartLevel <= this.startLevel; ++intermediateStartLevel) {
                    int oldStartLevel = FrameworkStartLevelImpl.this.getStartLevel();
                    FrameworkStartLevelImpl.this.framework.startLevelChanging(oldStartLevel, intermediateStartLevel);
                    FrameworkStartLevelImpl frameworkStartLevelImpl = FrameworkStartLevelImpl.this;
                    synchronized (frameworkStartLevelImpl) {
                        FrameworkStartLevelImpl.this.startLevel = intermediateStartLevel;
                    }
                    FrameworkStartLevelImpl.this.framework.startLevelChanged(oldStartLevel, intermediateStartLevel, this.listeners);
                }
            } else if (this.startLevel < startLevel) {
                for (int intermediateStartLevel = startLevel; intermediateStartLevel > this.startLevel; --intermediateStartLevel) {
                    int oldStartLevel = FrameworkStartLevelImpl.this.getStartLevel();
                    int newStartLevel = intermediateStartLevel - 1;
                    FrameworkStartLevelImpl.this.framework.startLevelChanging(oldStartLevel, newStartLevel);
                    FrameworkStartLevelImpl frameworkStartLevelImpl = FrameworkStartLevelImpl.this;
                    synchronized (frameworkStartLevelImpl) {
                        FrameworkStartLevelImpl.this.startLevel = newStartLevel;
                    }
                    FrameworkStartLevelImpl.this.framework.startLevelChanged(oldStartLevel, newStartLevel, this.listeners);
                }
            } else {
                FrameworkStartLevelImpl.this.framework.startLevelChanging(startLevel, startLevel);
                FrameworkStartLevelImpl.this.framework.startLevelChanged(startLevel, startLevel, this.listeners);
            }
        }
    }
}

