/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.jedit;

import org.dts.spell.filter.Filter;
import org.dts.spell.finder.CharSequenceWordFinder;
import org.dts.spell.finder.Word;
import org.dts.spell.jedit.BufferCharSequenceAdapter;
import org.dts.spell.jedit.TokenModeFilter;
import org.dts.spell.tokenizer.DefaultWordTokenizer;
import org.dts.spell.tokenizer.FilteredTokenizer;
import org.dts.spell.tokenizer.WordTokenizer;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.Selection;

public class BufferWordFinder
extends CharSequenceWordFinder {
    public BufferWordFinder(JEditBuffer buffer) {
        this(buffer, 0, buffer.getLength(), false);
    }

    public BufferWordFinder(JEditBuffer buffer, Selection selection) {
        this(buffer, selection.getStart(), selection.getEnd(), false);
    }

    public BufferWordFinder(JEditBuffer buffer, Selection selection, boolean tokenMode) {
        this(buffer, selection.getStart(), selection.getEnd(), tokenMode);
    }

    public BufferWordFinder(JEditBuffer buffer, int offSet, int end, boolean tokenMode) {
        super((CharSequence)new BufferCharSequenceAdapter(buffer, offSet, end), (WordTokenizer)(tokenMode ? new FilteredTokenizer((Filter)new TokenModeFilter()) : new DefaultWordTokenizer()));
    }

    protected void replace(String newWord, Word currentWord) {
        JEditBuffer buffer = this.getBuffer();
        int start = currentWord.getStart();
        buffer.remove(start, currentWord.length());
        this.updateCharSequence(start, start + currentWord.length(), 1);
        if (newWord.length() > 0) {
            buffer.insert(start, newWord);
            this.updateCharSequence(start, start + newWord.length(), 0);
        }
    }

    public JEditBuffer getBuffer() {
        return ((BufferCharSequenceAdapter)this.getCharSequence()).getBuffer();
    }
}

