/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.jedit;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import javax.swing.text.Position;
import org.dts.spell.SpellChecker;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.dictionary.openoffice.OpenOfficeSpellDictionary;
import org.dts.spell.event.SpellCheckListener;
import org.dts.spell.finder.WordFinder;
import org.dts.spell.jedit.BufferWordFinder;
import org.dts.spell.jedit.UIErrorListener;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;

public class JMySpellChecker {
    private SpellDictionary dictionary = null;
    private SpellChecker spellChecker = null;
    private static final String AUTOMATIC_DOWNLOAD = "options.jmyspell.auto-load";
    private static final String RESET_SPELLCHECKER = "options.jmyspell.auto-reset";
    private static final String TOKEN_MODE = "options.jmyspell.token-mode";
    private static final String DICTIONARY = "options.jmyspell.dictionary";
    private static final String IGNORE_DIGITS = "options.jmyspell.spell.ignore-digits";
    private static final String IGNORE_CASE = "options.jmyspell.spell.ignore-case";
    private static final String IGNORE_UPPERCASE = "options.jmyspell.spell.ignore-uppercase";

    public JMySpellChecker() throws IOException {
        if (JMySpellChecker.isAutomaticLoadDictionary()) {
            this.loadDictionary();
        }
    }

    private boolean checkSelections(Selection[] selection, JEditBuffer buffer, UIErrorListener listener) {
        boolean result = true;
        boolean isTokenMode = JMySpellChecker.isTokenMode();
        for (int i = 0; i < selection.length; ++i) {
            listener.setOriginOffSet(selection[i].getStart());
            result &= this.spellChecker.check((WordFinder)new BufferWordFinder(buffer, selection[i], isTokenMode), (SpellCheckListener)listener);
        }
        return result;
    }

    public void checkText(View view) throws IOException {
        if (null == this.spellChecker) {
            this.loadDictionary();
        }
        JEditTextArea textArea = view.getTextArea();
        JEditBuffer buffer = textArea.getBuffer();
        UIErrorListener listener = new UIErrorListener(textArea);
        Position caretPos = buffer.createPosition(textArea.getCaretPosition());
        Selection[] selections = textArea.getSelection();
        boolean hasSelection = null != selections && selections.length > 0;
        this.spellChecker.setIgnoreUpperCaseWords(JMySpellChecker.isIgnoreUpperCase());
        this.spellChecker.setCaseSensitive(!JMySpellChecker.isIgnoreCase());
        this.spellChecker.setSkipNumbers(JMySpellChecker.isIgnoreDigits());
        if (!hasSelection) {
            selections = new Selection[]{new Selection.Range(0, buffer.getLength())};
        }
        if (this.checkSelections(selections, buffer, listener)) {
            Macros.message((Component)view, (String)jEdit.getProperty((String)"jmyspell.no-error.found"));
        }
        if (hasSelection) {
            textArea.setSelection(selections);
        }
        textArea.setCaretPosition(caretPos.getOffset());
        if (JMySpellChecker.isResetSpellChecker()) {
            this.resetSpellChecker();
        }
    }

    public void loadDictionary() throws IOException {
        File dictionaryFile = JMySpellChecker.getDictionaryFile();
        this.dictionary = dictionaryFile.getName().endsWith("zip") ? new OpenOfficeSpellDictionary(new ZipFile(dictionaryFile)) : new OpenOfficeSpellDictionary(dictionaryFile);
        if (null == this.spellChecker) {
            this.spellChecker = new SpellChecker(this.dictionary);
        } else {
            this.spellChecker.setDictionary(this.dictionary);
        }
    }

    public void resetSpellChecker() {
        if (null != this.spellChecker) {
            this.spellChecker.resetIgnore();
        }
    }

    public void unloadDictionary() {
        this.spellChecker = null;
        this.dictionary = null;
        System.gc();
    }

    public SpellChecker getSpellChecker() {
        return this.spellChecker;
    }

    public static boolean isResetSpellChecker() {
        return jEdit.getBooleanProperty((String)RESET_SPELLCHECKER, (boolean)false);
    }

    public static void setResetSpellChecker(boolean on) {
        jEdit.setBooleanProperty((String)RESET_SPELLCHECKER, (boolean)on);
    }

    public static boolean isAutomaticLoadDictionary() {
        return jEdit.getBooleanProperty((String)AUTOMATIC_DOWNLOAD, (boolean)false);
    }

    public static void setAutomaticLoadDictionary(boolean on) {
        jEdit.setBooleanProperty((String)AUTOMATIC_DOWNLOAD, (boolean)on);
    }

    public static boolean isTokenMode() {
        return jEdit.getBooleanProperty((String)TOKEN_MODE, (boolean)false);
    }

    public static void setTokeMode(boolean on) {
        jEdit.setBooleanProperty((String)TOKEN_MODE, (boolean)on);
    }

    public static File getDictionaryFile() {
        return new File(jEdit.getProperty((String)DICTIONARY, (String)""));
    }

    public static void setDictionaryFile(String file) {
        jEdit.setProperty((String)DICTIONARY, (String)file);
    }

    public static boolean isIgnoreUpperCase() {
        return jEdit.getBooleanProperty((String)IGNORE_UPPERCASE, (boolean)false);
    }

    public static void setIgnoreUpperCase(boolean on) {
        jEdit.setBooleanProperty((String)IGNORE_UPPERCASE, (boolean)on);
    }

    public static boolean isIgnoreCase() {
        return jEdit.getBooleanProperty((String)IGNORE_CASE, (boolean)false);
    }

    public static void setIgnoreCase(boolean on) {
        jEdit.setBooleanProperty((String)IGNORE_CASE, (boolean)on);
    }

    public static boolean isIgnoreDigits() {
        return jEdit.getBooleanProperty((String)IGNORE_DIGITS, (boolean)true);
    }

    public static void setIgnoreDigits(boolean on) {
        jEdit.setBooleanProperty((String)IGNORE_DIGITS, (boolean)on);
    }
}

