/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.jedit;

import java.io.File;
import javax.swing.JCheckBox;
import org.dts.spell.jedit.JMySpellChecker;
import org.dts.spell.jedit.JMySpellPlugin;
import org.dts.spell.jedit.PatchChooserPanel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;

public class JMySpellOptionPane
extends AbstractOptionPane {
    private PatchChooserPanel dictDir;
    private JCheckBox automaticLoad;
    private JCheckBox resetDict;
    private JCheckBox ignoreUpperCase;
    private JCheckBox ignoreCase;
    private JCheckBox ignoreNumbers;

    public JMySpellOptionPane() {
        super("jmyspell-properties");
    }

    private void addDictionaryPanel() {
        this.addSeparator("options.jmyspell-properties.dictionary.title.label");
        this.dictDir = new PatchChooserPanel(JMySpellChecker.getDictionaryFile(), jEdit.getProperty((String)"options.jmyspell-properties.dictionary.browse"));
        this.addComponent(jEdit.getProperty((String)"options.jmyspell-properties.dictionary.label"), this.dictDir, 2);
    }

    private void addOptionPanel() {
        this.addSeparator("options.jmyspell-properties.options.title.label");
        this.automaticLoad = new JCheckBox(jEdit.getProperty((String)"options.jmyspell-properties.options.auto-load.label"));
        this.automaticLoad.setSelected(JMySpellChecker.isAutomaticLoadDictionary());
        this.addComponent(this.automaticLoad);
        this.resetDict = new JCheckBox(jEdit.getProperty((String)"options.jmyspell-properties.options.auto-reset.label"));
        this.resetDict.setSelected(JMySpellChecker.isResetSpellChecker());
        this.addComponent(this.resetDict);
    }

    private void addSpellOptionPanel() {
        this.addSeparator("options.jmyspell-properties.spell-options.title.label");
        this.ignoreUpperCase = new JCheckBox(jEdit.getProperty((String)"options.jmyspell-properties.spell-options.ignore-uppercase.label"));
        this.ignoreUpperCase.setSelected(JMySpellChecker.isIgnoreUpperCase());
        this.addComponent(this.ignoreUpperCase);
        this.ignoreCase = new JCheckBox(jEdit.getProperty((String)"options.jmyspell-properties.spell-options.ignore-case.label"));
        this.ignoreCase.setSelected(JMySpellChecker.isIgnoreCase());
        this.addComponent(this.ignoreCase);
        this.ignoreNumbers = new JCheckBox(jEdit.getProperty((String)"options.jmyspell-properties.spell-options.ignore-numbers.label"));
        this.ignoreNumbers.setSelected(JMySpellChecker.isIgnoreDigits());
        this.addComponent(this.ignoreNumbers);
    }

    protected void _init() {
        this.addDictionaryPanel();
        this.addOptionPanel();
        this.addSpellOptionPanel();
    }

    protected void _save() {
        File oldFile = JMySpellChecker.getDictionaryFile();
        boolean isNewFile = !oldFile.equals(new File(this.dictDir.getFile()));
        boolean oldLoad = JMySpellChecker.isAutomaticLoadDictionary();
        boolean load = this.automaticLoad.isSelected();
        JMySpellChecker.setDictionaryFile(this.dictDir.getFile());
        JMySpellChecker.setAutomaticLoadDictionary(load);
        JMySpellChecker.setResetSpellChecker(this.resetDict.isSelected());
        JMySpellChecker.setIgnoreUpperCase(this.ignoreUpperCase.isSelected());
        JMySpellChecker.setIgnoreCase(this.ignoreCase.isSelected());
        JMySpellChecker.setIgnoreDigits(this.ignoreNumbers.isSelected());
        if (load && (!oldLoad || isNewFile)) {
            JMySpellPlugin.reloadDictionary();
        }
    }
}

