/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.jedit;

import java.awt.Component;
import java.io.IOException;
import org.dts.spell.SpellChecker;
import org.dts.spell.jedit.JMySpellChecker;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;

public class JMySpellPlugin
extends EditPlugin {
    private static JMySpellChecker jmySpellChecker;

    public static void staticSpellCheck(View view) {
        try {
            if (null != jmySpellChecker) {
                jmySpellChecker.checkText(view);
            } else {
                Macros.error((Component)view, (String)jEdit.getProperty((String)"jmyspell.no-init"));
            }
        }
        catch (IllegalStateException ex) {
            Macros.error((Component)view, (String)jEdit.getProperty((String)"jmyspell.error.dictionary.not-found"));
        }
        catch (Exception e) {
            Macros.error((Component)view, (String)e.getLocalizedMessage());
        }
    }

    public void start() {
        try {
            jmySpellChecker = new JMySpellChecker();
        }
        catch (Exception e) {
            Macros.error((Component)jEdit.getActiveView(), (String)e.getLocalizedMessage());
        }
    }

    public void stop() {
        JMySpellPlugin.unloadDictionary();
        jmySpellChecker = null;
    }

    public static void unloadDictionary() {
        if (null != jmySpellChecker) {
            jmySpellChecker.unloadDictionary();
        }
    }

    public static void reloadDictionary() {
        try {
            if (null != jmySpellChecker) {
                jmySpellChecker.unloadDictionary();
                jmySpellChecker.loadDictionary();
            } else {
                jmySpellChecker = new JMySpellChecker();
            }
        }
        catch (IOException e) {
            Macros.error((Component)jEdit.getActiveView(), (String)e.getLocalizedMessage());
        }
    }

    public static void resetSpellChecker() {
        if (null != jmySpellChecker) {
            jmySpellChecker.resetSpellChecker();
        }
    }

    public static SpellChecker getSpellChecker() {
        if (jmySpellChecker != null) {
            return jmySpellChecker.getSpellChecker();
        }
        return null;
    }

    public static void main(String[] args) {
        jEdit.main((String[])args);
    }
}

