/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.jedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.dts.spell.jedit.JMySpellChecker;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.JCheckBoxList;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;

public class ModesOptionPane
extends AbstractOptionPane {
    private JCheckBox tokenMode;
    private JComboBox modesComboBox;
    private JCheckBoxList tokensList;
    private Map<Mode, boolean[]> modesTokens;

    public ModesOptionPane() {
        super("jmyspell-modes");
    }

    protected void _init() {
        this.createTokensModesTable();
        this.modesComboBox = this.createModesComboBox();
        this.addComponent(jEdit.getProperty((String)"options.jmyspell-modes.modes.label"), this.modesComboBox);
        this.tokensList = this.createTokensTableScroller();
        this.addComponent(jEdit.getProperty((String)"options.jmyspell-modes.tokens.label"), new JScrollPane((Component)this.tokensList), 3);
        this.tokenMode = this.createEnableModeCheckBox();
        this.addComponent(this.tokenMode);
        View view = jEdit.getActiveView();
        if (view != null) {
            this.modesComboBox.setSelectedItem(view.getBuffer().getMode());
        }
    }

    private void createTokensModesTable() {
        this.modesTokens = new HashMap<Mode, boolean[]>();
        this.loadModes(jEdit.getModes());
    }

    private JComboBox createModesComboBox() {
        Mode[] mode = jEdit.getModes();
        JComboBox<Mode> result = new JComboBox<Mode>(mode);
        result.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Mode mode = (Mode)evt.getItem();
                if (evt.getStateChange() == 1) {
                    ModesOptionPane.this.putMode(mode);
                } else {
                    ModesOptionPane.this.quitMode(mode);
                }
            }
        });
        return result;
    }

    private JCheckBoxList createTokensTableScroller() {
        Object[] tokensChoices = new String[19];
        for (int i = 0; i < 19; ++i) {
            tokensChoices[i] = this.getVisibleTokenName(i);
        }
        return new JCheckBoxList(tokensChoices);
    }

    private JCheckBox createEnableModeCheckBox() {
        JCheckBox result = new JCheckBox(jEdit.getProperty((String)"options.jmyspell-modes.disable-mode.label"));
        result.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ModesOptionPane.this.tokensList.setEnabled(evt.getStateChange() == 1);
                ModesOptionPane.this.modesComboBox.setEnabled(evt.getStateChange() == 1);
            }
        });
        result.setSelected(JMySpellChecker.isTokenMode());
        this.tokensList.setEnabled(result.isSelected());
        this.modesComboBox.setEnabled(result.isSelected());
        return result;
    }

    private void quitMode(Mode mode) {
        JCheckBoxList.Entry[] values = this.tokensList.getValues();
        boolean[] tokens = this.modesTokens.get(mode);
        for (int i = 0; i < 19; ++i) {
            tokens[i] = values[i].isChecked();
        }
    }

    private String getVisibleTokenName(int id) {
        if (0 == id) {
            return jEdit.getProperty((String)"options.jmyspell-modes.default.label");
        }
        return Token.tokenToString((byte)((byte)id));
    }

    private void putMode(Mode mode) {
        Object[] values = this.tokensList.getValues();
        boolean[] tokens = this.modesTokens.get(mode);
        for (int i = 0; i < 19; ++i) {
            values[i] = new JCheckBoxList.Entry(tokens[i], (Object)this.getVisibleTokenName(i));
        }
        this.tokensList.setModel(values);
        this.tokensList.getColumnModel().getColumn(1).setCellRenderer(new TokenRenderer());
    }

    public static String getTokenModeName(Mode mode, int token) {
        return "options.jmyspell." + mode.getName() + "." + Token.tokenToString((byte)((byte)token));
    }

    public static String getTokenModeName(Mode mode, Token token) {
        return ModesOptionPane.getTokenModeName(mode, token.id);
    }

    public static boolean hasToBeParsed(Mode mode, Token token) {
        return jEdit.getBooleanProperty((String)ModesOptionPane.getTokenModeName(mode, token), (boolean)false);
    }

    public static boolean hasToBeParsed(Mode mode, int token) {
        return jEdit.getBooleanProperty((String)ModesOptionPane.getTokenModeName(mode, token), (boolean)false);
    }

    protected void saveMode(Mode mode, boolean[] tokens) {
        for (int i = 0; i < 19; ++i) {
            jEdit.setBooleanProperty((String)ModesOptionPane.getTokenModeName(mode, i), (boolean)tokens[i]);
        }
    }

    protected void saveModes(Mode[] modes) {
        for (int i = 0; i < modes.length; ++i) {
            this.saveMode(modes[i], this.modesTokens.get(modes[i]));
        }
    }

    protected boolean[] loadMode(Mode mode) {
        boolean[] tokens = new boolean[19];
        for (int i = 0; i < 19; ++i) {
            tokens[i] = jEdit.getBooleanProperty((String)ModesOptionPane.getTokenModeName(mode, i), (boolean)false);
        }
        return tokens;
    }

    protected void loadModes(Mode[] modes) {
        for (int i = 0; i < modes.length; ++i) {
            this.modesTokens.put(modes[i], this.loadMode(modes[i]));
        }
    }

    protected void _save() {
        this.quitMode((Mode)this.modesComboBox.getSelectedItem());
        this.saveModes(jEdit.getModes());
        JMySpellChecker.setTokeMode(this.tokenMode.isSelected());
    }

    private class TokenRenderer
    extends DefaultTableCellRenderer {
        private SyntaxStyle[] styles;

        public TokenRenderer() {
            this.setOpaque(true);
            Font font = jEdit.getFontProperty((String)"view.font");
            this.styles = GUIUtilities.loadStyles((String)font.getFamily(), (int)font.getSize());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color background;
            Color foreground;
            Font font;
            if (null != this.styles[row]) {
                font = this.styles[row].getFont();
                foreground = this.styles[row].getForegroundColor();
                background = this.styles[row].getBackgroundColor() == null ? jEdit.getColorProperty((String)"view.bgColor") : this.styles[row].getBackgroundColor();
            } else {
                font = jEdit.getFontProperty((String)"view.font");
                foreground = jEdit.getColorProperty((String)"view.fgColor");
                background = jEdit.getColorProperty((String)"view.bgColor");
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                this.setBackground(background);
                this.setForeground(foreground);
            }
            this.setFont(font);
            return this;
        }
    }
}

