/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.jedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.gjt.sp.jedit.jEdit;

class PatchChooserPanel
extends JPanel {
    private JTextField textField;

    public PatchChooserPanel(File initFile, String buttonText) {
        super(new BorderLayout(2, 2));
        this.textField = new JTextField(initFile.getPath());
        this.add((Component)this.textField, "Center");
        this.add((Component)new JButton(new AbstractAction(buttonText){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatchChooserPanel.this.openFileDialog();
            }
        }), "East");
    }

    public String getFile() {
        return this.textField.getText();
    }

    private JFileChooser getBrowser() {
        File file;
        String fileName = this.getFile();
        String path = null;
        String position = null;
        if (!fileName.endsWith("zip")) {
            fileName = fileName + ".dic";
        }
        if ((file = new File(fileName)).exists()) {
            if (file.isDirectory()) {
                path = file.getPath();
            } else {
                path = file.getParent();
                position = file.getName();
            }
        }
        JFileChooser result = new JFileChooser(path);
        result.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String fileName = f.getName();
                return f.isDirectory() || fileName.endsWith(".zip") || fileName.endsWith(".dic") || fileName.endsWith(".aff");
            }

            @Override
            public String getDescription() {
                return jEdit.getProperty((String)"jmyspell.filter.description");
            }
        });
        result.setMultiSelectionEnabled(false);
        if (null != position) {
            result.setSelectedFile(new File(position));
        }
        return result;
    }

    private void openFileDialog() {
        JFileChooser browser = this.getBrowser();
        browser.showOpenDialog(this);
        File file = browser.getSelectedFile();
        if (null != file) {
            String filePath = file.getPath();
            if (filePath.endsWith("zip")) {
                this.textField.setText(filePath);
            } else {
                int index = filePath.lastIndexOf(46);
                this.textField.setText(filePath.substring(0, index));
            }
        }
    }
}

