/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.jedit;

import org.dts.spell.filter.Filter;
import org.dts.spell.finder.Word;
import org.dts.spell.jedit.BufferCharSequenceAdapter;
import org.dts.spell.jedit.ModesOptionPane;
import org.dts.spell.tokenizer.WordTokenizer;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.util.Log;

public class TokenModeFilter
implements Filter {
    private DefaultTokenHandler tokenHandler = new DefaultTokenHandler();
    private int currentLine = -1;

    public Word filter(Word word, WordTokenizer tokenizer) {
        if (null != word) {
            BufferCharSequenceAdapter sequence = this.getBufferCharSequenceAdapter(tokenizer);
            int offSet = sequence.getStart() + (word.getEnd() + word.getStart()) / 2;
            JEditBuffer buffer = this.getBuffer(tokenizer);
            int wordLine = buffer.getLineOfOffset(offSet);
            Log.log((int)9, (Object)this, (Object)("Current word " + offSet + " #" + word + "#"));
            if (wordLine != this.currentLine) {
                this.currentLine = wordLine;
                this.tokenHandler.init();
                buffer.markTokens(this.currentLine, (TokenHandler)this.tokenHandler);
            }
            Token token = this.tokenHandler.getTokens();
            int lineStart = buffer.getLineStartOffset(this.currentLine);
            token = TextUtilities.getTokenAtOffset((Token)this.tokenHandler.getTokens(), (int)(offSet - lineStart));
            if (this.hasToBeParsed(buffer, token)) {
                return word;
            }
            return null;
        }
        return null;
    }

    public void updateCharSequence(WordTokenizer tokenizer, int start, int end, int cause) {
        if (this.currentLine == -1) {
            this.currentLine = 0;
        }
        this.tokenHandler.init();
        this.getBuffer(tokenizer).markTokens(this.currentLine, (TokenHandler)this.tokenHandler);
    }

    private BufferCharSequenceAdapter getBufferCharSequenceAdapter(WordTokenizer tokenizer) {
        return (BufferCharSequenceAdapter)tokenizer.getCharSequence();
    }

    private JEditBuffer getBuffer(WordTokenizer tokenizer) {
        return this.getBufferCharSequenceAdapter(tokenizer).getBuffer();
    }

    private boolean hasToBeParsed(JEditBuffer buffer, Token token) {
        if (token.id < 19) {
            return ModesOptionPane.hasToBeParsed(buffer.getMode(), token);
        }
        return false;
    }
}

