/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.jedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import org.dts.spell.event.SpellCheckEvent;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.event.UISpellCheckListener;
import org.dts.spell.swing.utils.ErrorHighlighterPainter;
import org.dts.spell.swing.utils.ErrorMsgBox;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class UIErrorListener
extends UISpellCheckListener {
    private ErrorMarker errorMarker = new ErrorMarker();
    private JEditTextArea textArea;
    private int originOffSet;

    public UIErrorListener(JEditTextArea textArea) {
        this.textArea = textArea;
    }

    public void beginChecking(SpellCheckEvent event) {
        super.beginChecking(event);
        this.textArea.selectNone();
        this.textArea.getPainter().addExtension((TextAreaExtension)this.errorMarker);
    }

    public void spellingError(SpellCheckEvent event) {
        this.markError(event);
        this.relocateDialog(this.errorMarker.getErrorRectangle());
        super.spellingError(event);
    }

    public void badCaseError(SpellCheckEvent event) {
        this.markError(event);
        super.badCaseError(event);
    }

    public void repeatWordError(SpellCheckEvent event) {
        this.markError(event);
        super.repeatWordError(event);
    }

    private void markError(SpellCheckEvent event) {
        try {
            int offSet = this.getOriginOffSet();
            Word word = event.getCurrentWord();
            int begin = offSet + word.getStart();
            int end = offSet + word.getEnd();
            this.textArea.scrollTo(begin, false);
            int line = this.textArea.getScreenLineOfOffset(begin);
            line = line > 2 ? (line -= 2) : 0;
            this.errorMarker.setMarks(begin, end);
            this.textArea.setSelection((Selection)new Selection.Range(begin, end));
            for (int i = 0; i < line; ++i) {
                this.textArea.scrollDownLine();
            }
        }
        catch (Exception ex) {
            ErrorMsgBox.show((Throwable)ex);
            System.out.println(ex);
        }
    }

    public void endChecking(SpellCheckEvent event) {
        this.textArea.getPainter().removeExtension((TextAreaExtension)this.errorMarker);
        this.textArea.selectNone();
        super.endChecking(event);
    }

    public void setOriginOffSet(int offSet) {
        this.originOffSet = offSet;
    }

    public int getOriginOffSet() {
        return this.originOffSet;
    }

    private class ErrorMarker
    extends TextAreaExtension {
        private int beginError;
        private int endError;

        private ErrorMarker() {
        }

        public void setMarks(int begin, int end) {
            this.beginError = begin;
            this.endError = end;
        }

        public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
            int errorLineBegin = UIErrorListener.this.textArea.getScreenLineOfOffset(this.beginError);
            int errorLineEnd = UIErrorListener.this.textArea.getScreenLineOfOffset(this.endError);
            if (screenLine == errorLineBegin) {
                if (screenLine == errorLineEnd) {
                    end = this.endError;
                }
                this.paintErrorLine(gfx, this.beginError, end, y);
            } else if (screenLine == errorLineEnd) {
                this.paintErrorLine(gfx, start, this.endError, y);
            }
        }

        private void paintErrorLine(Graphics2D gfx, int begin, int end, int y) {
            FontMetrics fm = UIErrorListener.this.textArea.getPainter().getFontMetrics();
            Point org = UIErrorListener.this.textArea.offsetToXY(begin);
            int x1 = org.x;
            org = UIErrorListener.this.textArea.offsetToXY(end);
            int x2 = org.x;
            y = y + fm.getAscent() + fm.getDescent();
            gfx.setColor(Color.RED);
            ErrorHighlighterPainter.paintWaveLine((Graphics)gfx, (int)x1, (int)x2, (int)y);
        }

        public Rectangle getErrorRectangle() {
            FontMetrics fm = UIErrorListener.this.textArea.getPainter().getFontMetrics();
            Point org = UIErrorListener.this.textArea.offsetToXY(this.beginError);
            SwingUtilities.convertPointToScreen(org, (Component)UIErrorListener.this.textArea);
            int x1 = org.x;
            int y1 = org.y;
            org = UIErrorListener.this.textArea.offsetToXY(this.endError);
            org.y = org.y + fm.getAscent() + fm.getDescent();
            SwingUtilities.convertPointToScreen(org, (Component)UIErrorListener.this.textArea);
            int x2 = org.x;
            int y2 = org.y;
            return new Rectangle(x1, y1, x2 - x1, y2 - y1);
        }
    }
}

