/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.libjitsi;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.utils.logging.Logger;

public class LibJitsiImpl
extends LibJitsi {
    private static final Logger LOGGER = Logger.getLogger(LibJitsiImpl.class);
    private final Map<String, ServiceLock> services = new HashMap<String, ServiceLock>();

    public LibJitsiImpl() {
        String key = "org.jitsi.service.audionotifier.AudioNotifierService";
        String value = System.getProperty(key);
        if (value == null || value.length() == 0) {
            System.setProperty(key, "org.jitsi.impl.neomedia.notify.AudioNotifierServiceImpl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T getService(Class<T> serviceClass) {
        ServiceLock lock;
        String className = serviceClass.getName();
        Map<String, ServiceLock> map = this.services;
        synchronized (map) {
            lock = this.services.get(className);
            if (lock == null) {
                lock = new ServiceLock();
                this.services.put(className, lock);
            }
        }
        return lock.getService(className, serviceClass);
    }

    private static class ServiceLock {
        private final ReentrantLock _lock = new ReentrantLock();
        private Object _service;

        private ServiceLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T getService(String className, Class<T> clazz) {
            Object t;
            boolean initializeService = !this._lock.isHeldByCurrentThread();
            this._lock.lock();
            try {
                t = this._service;
                if (t == null && initializeService) {
                    this._service = t = ServiceLock.initializeService(className, clazz);
                }
            }
            finally {
                this._lock.unlock();
            }
            return (T)t;
        }

        private static <T> T initializeService(String className, Class<T> clazz) {
            T service;
            Throwable exception;
            String implClassName;
            block9: {
                implClassName = System.getProperty(className);
                boolean suppressClassNotFoundException = false;
                if (implClassName == null || implClassName.length() == 0) {
                    implClassName = className.replace(".service.", ".impl.").concat("Impl");
                    suppressClassNotFoundException = true;
                }
                Class<?> implClass = null;
                exception = null;
                try {
                    implClass = Class.forName(implClassName);
                }
                catch (ClassNotFoundException cnfe) {
                    if (!suppressClassNotFoundException) {
                        exception = cnfe;
                    }
                }
                catch (LinkageError eiie) {
                    exception = eiie;
                }
                service = null;
                if (implClass != null && clazz.isAssignableFrom(implClass)) {
                    try {
                        Object t = implClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        service = (T)t;
                    }
                    catch (Exception e) {
                        exception = e;
                        if (!(e instanceof InterruptedException)) break block9;
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (exception != null && LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Failed to initialize service implementation " + implClassName + "."), exception);
            }
            return service;
        }
    }
}

