/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.logging.Logger;

public class AbsSendTimeEngine
extends SinglePacketTransformerAdapter
implements TransformEngine {
    private static final int b = 1000000000;
    private static final int EXT_LENGTH = 3;
    private static final Logger logger = Logger.getLogger(AbsSendTimeEngine.class);
    private int extensionID = -1;

    public AbsSendTimeEngine() {
        super(RTPPacketPredicate.INSTANCE);
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        if (this.extensionID != -1) {
            RawPacket.HeaderExtension ext = pkt.getHeaderExtension((byte)this.extensionID);
            if (ext == null) {
                ext = pkt.addExtension((byte)this.extensionID, 3);
            }
            this.setTimestamp(ext.getBuffer(), ext.getOffset() + 1);
        }
        return pkt;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    private void setTimestamp(byte[] buf, int off) {
        long ns = System.nanoTime();
        int fraction = (int)(ns % 1000000000L * 262144L / 1000000000L);
        int seconds = (int)(ns / 1000000000L % 64L);
        int timestamp = (seconds << 18 | fraction) & 0xFFFFFF;
        buf[off] = (byte)(timestamp >> 16);
        buf[off + 1] = (byte)(timestamp >> 8);
        buf[off + 2] = (byte)timestamp;
    }

    public void setExtensionID(int id) {
        this.extensionID = id;
    }

    public static long getAbsSendTime(RawPacket pkt, byte extensionID) {
        long absSendTime = -1L;
        RawPacket.HeaderExtension header = pkt.getHeaderExtension(extensionID);
        if (header != null) {
            int offSet = header.getOffset() + 1;
            if (header.getExtLength() == 3) {
                absSendTime = RTPUtils.readUint24AsInt(header.getBuffer(), offSet);
            }
        }
        return absSendTime;
    }
}

