/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.webrtc.EglBase;
import org.webrtc.Logging;
import org.webrtc.ThreadUtils;

public class EglThread {
    private final ReleaseMonitor releaseMonitor;
    private final HandlerWithExceptionCallbacks handler;
    private final EglBase.EglConnection eglConnection;

    public static EglThread create(@Nullable ReleaseMonitor releaseMonitor, @Nullable EglBase.Context sharedContext, int[] configAttributes) {
        HandlerThread renderThread = new HandlerThread("EglThread");
        renderThread.start();
        HandlerWithExceptionCallbacks handler = new HandlerWithExceptionCallbacks(renderThread.getLooper());
        EglBase.EglConnection eglConnection = ThreadUtils.invokeAtFrontUninterruptibly((Handler)handler, () -> {
            if (sharedContext == null) {
                return EglBase.EglConnection.createEgl10(configAttributes);
            }
            return EglBase.EglConnection.create(sharedContext, configAttributes);
        });
        return new EglThread(releaseMonitor != null ? releaseMonitor : eglThread -> true, handler, eglConnection);
    }

    private EglThread(ReleaseMonitor releaseMonitor, HandlerWithExceptionCallbacks handler, EglBase.EglConnection eglConnection) {
        this.releaseMonitor = releaseMonitor;
        this.handler = handler;
        this.eglConnection = eglConnection;
    }

    public void release() {
        if (!this.releaseMonitor.onRelease(this)) {
            return;
        }
        this.handler.post(this.eglConnection::release);
        this.handler.getLooper().quitSafely();
    }

    public EglBase createEglBaseWithSharedConnection() {
        return EglBase.create(this.eglConnection);
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void addExceptionCallback(Runnable callback) {
        this.handler.addExceptionCallback(callback);
    }

    public void removeExceptionCallback(Runnable callback) {
        this.handler.removeExceptionCallback(callback);
    }

    private static class HandlerWithExceptionCallbacks
    extends Handler {
        private final Object callbackLock = new Object();
        @GuardedBy(value="callbackLock")
        private final List<Runnable> exceptionCallbacks = new ArrayList<Runnable>();

        public HandlerWithExceptionCallbacks(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchMessage(Message msg) {
            try {
                super.dispatchMessage(msg);
            }
            catch (Exception e) {
                Logging.e("EglThread", "Exception on EglThread", e);
                Object object = this.callbackLock;
                synchronized (object) {
                    for (Runnable callback : this.exceptionCallbacks) {
                        callback.run();
                    }
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addExceptionCallback(Runnable callback) {
            Object object = this.callbackLock;
            synchronized (object) {
                this.exceptionCallbacks.add(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeExceptionCallback(Runnable callback) {
            Object object = this.callbackLock;
            synchronized (object) {
                this.exceptionCallbacks.remove(callback);
            }
        }
    }

    public static interface ReleaseMonitor {
        public boolean onRelease(EglThread var1);
    }
}

