/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.fastel.constant.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jiuwo.fastel.contract.enums.ExpressionEnum;
import org.jiuwo.fastel.impl.OptimizeJsExpressionImpl;

public class MapConstant {
    private static String[] mathArgs = new String[]{"abs", "acos", "asin", "atan", "ceil", "asin", "cos", "exp", "floor", "log", "round", "sin", "sqrt", "tan", "random", "min", "max", "pow", "atan2"};
    private static volatile Map<Object, Object> jsNodeList = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<Object, Object> getInstance() {
        if (jsNodeList != null) return jsNodeList;
        Class<Map> clazz = Map.class;
        synchronized (Map.class) {
            if (jsNodeList != null) return jsNodeList;
            jsNodeList = MapConstant.jsNodeList();
            // ** MonitorExit[var0] (shouldn't be in output)
            return jsNodeList;
        }
    }

    private static Map<String, Object> mathList() {
        HashMap<String, Object> map = new HashMap<String, Object>(8 + mathArgs.length);
        double ln10 = Math.log(10.0);
        double ln2 = Math.log(2.0);
        map.put("E", Math.E);
        map.put("PI", Math.PI);
        map.put("LN10", ln10);
        map.put("LN2", ln2);
        map.put("LOG2E", 1.0 / ln2);
        map.put("LOG10E", 1.0 / ln10);
        map.put("SQRT1_2", Math.sqrt(0.5));
        map.put("SQRT2", Math.sqrt(2.0));
        for (int i = 0; i < mathArgs.length; ++i) {
            map.put(mathArgs[i], new OptimizeJsExpressionImpl(ExpressionEnum.JsToken.getJsTokenByKey(mathArgs[i])));
        }
        return map;
    }

    private static Map<String, Object> jsonList() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("parse", new OptimizeJsExpressionImpl(ExpressionEnum.JsToken.JSON_PARSE));
        map.put("stringify", new OptimizeJsExpressionImpl(ExpressionEnum.JsToken.JSON_STRINGIFY));
        return map;
    }

    private static Map<Object, Object> jsNodeList() {
        HashMap<Object, Object> map = new HashMap<Object, Object>(12);
        map.put("Math", MapConstant.mathList());
        map.put("JSON", Collections.unmodifiableMap(MapConstant.jsonList()));
        map.put("isFinite", new OptimizeJsExpressionImpl(ExpressionEnum.JsToken.IS_FINITE));
        map.put("isNaN", new OptimizeJsExpressionImpl(ExpressionEnum.JsToken.IS_NAN));
        map.put("parseInt", new OptimizeJsExpressionImpl(ExpressionEnum.JsToken.PARSE_INT));
        map.put("parseFloat", new OptimizeJsExpressionImpl(ExpressionEnum.JsToken.PARSE_FLOAT));
        map.put("encodeURI", new OptimizeJsExpressionImpl(ExpressionEnum.JsToken.ENCODE_URI));
        map.put("decodeURI", new OptimizeJsExpressionImpl(ExpressionEnum.JsToken.DECODE_URI));
        map.put("encodeURIComponent", new OptimizeJsExpressionImpl(ExpressionEnum.JsToken.ENCODE_URI_COMPONENT));
        map.put("decodeURIComponent", new OptimizeJsExpressionImpl(ExpressionEnum.JsToken.DECODE_URI_COMPONENT));
        map.put("Infinity", Double.POSITIVE_INFINITY);
        map.put("NaN", Double.NaN);
        return map;
    }
}

