/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.fastel.contract.enums;

import java.util.Arrays;
import org.jiuwo.fastel.constant.SysConstant;

public interface ExpressionEnum {

    public static enum JsToken {
        MATH_ABS("abs", null),
        MATH_ACOS("acos", null),
        MATH_ASIN("asin", null),
        MATH_ATAN("atan", null),
        MATH_CEIL("ceil", null),
        MATH_COS("cos", null),
        MATH_EXP("exp", null),
        MATH_FLOOR("floor", null),
        MATH_LOG("log", null),
        MATH_ROUND("round", null),
        MATH_SIN("sin", null),
        MATH_SQRT("sqrt", null),
        MATH_TAN("tan", null),
        MATH_RANDOM("random", null),
        MATH_MIN("min", null),
        MATH_MAX("max", null),
        MATH_POW("pow", null),
        MATH_ATAN_2("atan2", null),
        MATH_E("E", Math.E),
        MATH_PI("PI", Math.PI),
        MATH_LN10("LN10", SysConstant.LN10),
        MATH_LN2("LN2", SysConstant.LN2),
        MATH_LOG2E("LOG2E", 1.0 / SysConstant.LN2),
        MATH_LOG10E("LOG10E", 1.0 / SysConstant.LN10),
        MATH_SQRT1_2("SQRT1_2", SysConstant.SQRT1_2),
        MATH_SQRT2("SQRT2", SysConstant.SQRT2),
        MATH("Math", null),
        JSON_PARSE("parse", null),
        JSON_STRINGIFY("stringify", null),
        JSON("JSON", null),
        IS_FINITE("isFinite", null),
        IS_NAN("isNaN", null),
        PARSE_INT("parseInt", null),
        PARSE_FLOAT("parseFloat", null),
        ENCODE_URI("encodeURI", 272),
        DECODE_URI("decodeURI", 16),
        ENCODE_URI_COMPONENT("encodeURIComponent", 256),
        DECODE_URI_COMPONENT("decodeURIComponent", 0),
        INFINITY("Infinity", null),
        NAN("NaN", null),
        DEFAULT("default", null);

        private String key;
        private Object value;

        private JsToken(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public static JsToken getJsTokenByValue(Object value) {
            return Arrays.stream(JsToken.values()).filter(p -> p.getValue().equals(value)).findFirst().orElse(null);
        }

        public static JsToken getJsTokenByKey(String key) {
            return Arrays.stream(JsToken.values()).filter(p -> p.getKey().equals(key)).findFirst().orElse(null);
        }

        public static Object getValue(String key) {
            return Arrays.stream(JsToken.values()).filter(p -> !p.getKey().equals("null") && p.getKey().equals(key)).map(JsToken::getValue).findFirst().orElse(null);
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static enum Token {
        VALUE_CONSTANTS("value", -1),
        VALUE_VAR("var", -2),
        VALUE_LIST("[]", -3),
        VALUE_MAP("{}", -4),
        VALUE_LAMBDA("null", -5),
        DEFAULT("null", -9),
        OP_GET(".", 384),
        OP_INVOKE("()", 385),
        OP_NOT("!", 112),
        OP_BIT_NOT("~", 113),
        OP_POS("+", 114),
        OP_NEG("-", 115),
        OP_MUL("*", 352),
        OP_DIV("/", 353),
        OP_MOD("%", 354),
        OP_ADD("+", 336),
        OP_SUB("-", 337),
        OP_LSH("<<", 320),
        OP_RSH(">>", 321),
        OP_URSH(">>>", 322),
        OP_LT("<", 4400),
        OP_GT(">", 4401),
        OP_LTEQ("<=", 4402),
        OP_GTEQ(">=", 4403),
        OP_IN(" in ", 69936),
        OP_EQ("==", 304),
        OP_NE("!=", 305),
        OP_EQ_STRICT("===", 306),
        OP_NE_STRICT("!==", 318),
        OP_BIT_AND("&", 16672),
        OP_BIT_XOR("^", 12576),
        OP_BIT_OR("|", 8480),
        OP_AND("&&", 4384),
        OP_OR("||", 288),
        OP_QUESTION("?", 272),
        OP_QUESTION_SELECT(":", 273),
        OP_JOIN(",", 256),
        OP_PUT(":", 257),
        BRACKET_BEGIN("(", -65534),
        BRACKET_END(")", -65535),
        OP_GET_STATIC("null", 128),
        OP_INVOKE_WITH_STATIC_PARAM("null", 129);

        private String key;
        private int value;

        private Token(String key, int value) {
            this.key = key;
            this.value = value;
        }

        public static Token getTokenByValue(int value) {
            return Arrays.stream(Token.values()).filter(p -> p.getValue() == value).findFirst().orElse(null);
        }

        public static Token getTokenByKey(String key) {
            return Arrays.stream(Token.values()).filter(p -> p.getKey().equals(key)).findFirst().orElse(null);
        }

        public static boolean existsTokenByKey(String key) {
            return Token.getTokenByKey(key) != null;
        }

        public static boolean existsTokenByValue(int value) {
            return Token.getTokenByValue(value) != null;
        }

        public static int getValue(String key) {
            return Arrays.stream(Token.values()).filter(p -> !p.getKey().equals("null") && p.getKey().equals(key)).map(Token::getValue).findFirst().orElse(0);
        }

        public static String getKey(int value) {
            return Arrays.stream(Token.values()).filter(p -> !p.getKey().equals("null") && p.getValue() == value).map(Token::getKey).findFirst().orElse(null);
        }

        public String getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }
    }
}

