/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.fastel.contract.enums;

import java.util.Arrays;

public interface ParserEnum {

    public static enum ParseStatus {
        BEGIN,
        EXPRESSION,
        OPERATOR;

    }

    public static enum CharEscape {
        CHAR_B(Character.valueOf('\b'), Character.valueOf('b')),
        CHAR_F(Character.valueOf('\f'), Character.valueOf('f')),
        CHAR_N(Character.valueOf('\n'), Character.valueOf('n')),
        CHAR_R(Character.valueOf('\r'), Character.valueOf('r')),
        CHAR_T(Character.valueOf('\t'), Character.valueOf('t')),
        CHAR_V(Character.valueOf('\u000b'), Character.valueOf('v')),
        CHAR_EMPTY(Character.valueOf(' '), Character.valueOf(' ')),
        CHAR_TWO_BACKS_SLASH(Character.valueOf('\\'), Character.valueOf('\\')),
        CHAR_SLASH(Character.valueOf('/'), Character.valueOf('/')),
        CHAR_QUOTATION(Character.valueOf('\''), Character.valueOf('\'')),
        CHAR_TWO_QUOTATION(Character.valueOf('\"'), Character.valueOf('\"')),
        CHAR_U(Character.valueOf('u'), Character.valueOf('u')),
        CHAR_X(Character.valueOf('x'), Character.valueOf('x'));

        private Character escape;
        private Character value;

        private CharEscape(Character escape, Character value) {
            this.escape = escape;
            this.value = value;
        }

        public static Character getEscape(Character value) {
            return Arrays.stream(CharEscape.values()).filter(p -> p.getValue().equals(value)).map(CharEscape::getEscape).findFirst().orElse(null);
        }

        public static Character getValue(Character escape) {
            return Arrays.stream(CharEscape.values()).filter(p -> p.getEscape().equals(escape)).map(CharEscape::getValue).findFirst().orElse(null);
        }

        public static CharEscape getCharEscape(Character escape) {
            return Arrays.stream(CharEscape.values()).filter(p -> p.getEscape().equals(escape)).findFirst().orElse(null);
        }

        public Character getEscape() {
            return this.escape;
        }

        public Character getValue() {
            return this.value;
        }
    }
}

