/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.fastel.impl;

import org.jiuwo.fastel.contract.enums.ExpressionEnum;
import org.jiuwo.fastel.exception.FastElException;

public class ExpressionNode {
    private ExpressionEnum.Token token;
    private ExpressionNode left;
    private ExpressionNode right;
    private Object param;

    public ExpressionNode(ExpressionEnum.Token token, Object param) {
        this.token = token;
        this.param = param;
    }

    public ExpressionNode(String name) {
        this.token = ExpressionEnum.Token.getTokenByKey(name);
        if (this.token == null) {
            throw new FastElException("\u672a\u77e5\u64cd\u4f5c\u7b26\uff1a" + name);
        }
    }

    public static int getArgCount(ExpressionEnum.Token token) {
        if (token.getValue() < 0) {
            return 0;
        }
        int c = (token.getValue() & 0x300) >> 8;
        return c + 1;
    }

    public static boolean isPrefix(ExpressionEnum.Token token) {
        return ExpressionNode.getArgCount(token) == 1;
    }

    public ExpressionEnum.Token getToken() {
        return this.token;
    }

    public ExpressionNode getLeft() {
        return this.left;
    }

    public void setLeft(ExpressionNode left) {
        this.left = left;
    }

    public ExpressionNode getRight() {
        return this.right;
    }

    public void setRight(ExpressionNode right) {
        this.right = right;
    }

    public Object getParam() {
        return this.param;
    }

    public void setParam(Object param) {
        this.param = param;
    }
}

