/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.fastel.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jiuwo.fastel.constant.map.MapParserStringConsumerConstant;
import org.jiuwo.fastel.contract.CharConsumerParam;
import org.jiuwo.fastel.contract.ParserParam;
import org.jiuwo.fastel.contract.enums.ExpressionEnum;
import org.jiuwo.fastel.contract.enums.ParserEnum;
import org.jiuwo.fastel.exception.FastElException;
import org.jiuwo.fastel.impl.ExpressionNode;
import org.jiuwo.fastel.parser.AbstractParser;
import org.jiuwo.fastel.parser.CharConsumer;
import org.jiuwo.fastel.util.CharUtil;
import org.jiuwo.fastel.util.ExecutableUtil;
import org.jiuwo.fastel.util.NumberUtil;
import org.jiuwo.fastel.util.StringUtil;
import org.jiuwo.fastel.util.TreeUtil;

public class ExpressionParser
extends AbstractParser {
    private static final ExpressionNode NODE_TRUE = new ExpressionNode(ExpressionEnum.Token.VALUE_CONSTANTS, Boolean.TRUE);
    private static final ExpressionNode NODE_FALSE = new ExpressionNode(ExpressionEnum.Token.VALUE_CONSTANTS, Boolean.FALSE);
    private static final ExpressionNode NODE_NULL = new ExpressionNode(ExpressionEnum.Token.VALUE_CONSTANTS, null);
    protected ArrayList<ExpressionNode> expressionNodeArrayList = new ArrayList();
    private ParserEnum.ParseStatus status = ParserEnum.ParseStatus.BEGIN;
    private ExpressionEnum.Token previousType = null;
    private Map<String, ExpressionEnum.Token> aliasMap = Collections.emptyMap();
    private int depth;

    public ExpressionParser(String elValue) {
        super(elValue);
    }

    public ExpressionNode parseEL() {
        while (this.currentIndex < this.elSize) {
            this.skipSpace();
            if (this.currentIndex >= this.elSize) break;
            char c = Character.toLowerCase(this.elValue.charAt(this.currentIndex));
            if (c == '\"' || c == '\'') {
                String text = this.findString();
                this.addKeyOrObject(text, false);
                continue;
            }
            if (c >= '0' && c <= '9') {
                Number number = this.findNumber();
                this.addKeyOrObject(number, false);
                continue;
            }
            if (Character.isJavaIdentifierStart(c)) {
                String id = this.findId();
                this.addId(id);
                continue;
            }
            String op = this.findOperator();
            this.addOperator(op);
        }
        return this.getExpressionNode();
    }

    private ExpressionNode getExpressionNode() {
        if (this.depth != 0) {
            this.buildFail("\u8868\u8fbe\u5f0f\u62ec\u5f27\u4e0d\u5339\u914d", null);
        }
        TreeUtil.prepareSelect(this.expressionNodeArrayList);
        LinkedList<ExpressionNode> stack = new LinkedList<ExpressionNode>();
        try {
            TreeUtil.toTree(TreeUtil.right(this.expressionNodeArrayList), stack);
        }
        catch (Exception e) {
            this.buildFail("\u9006\u6ce2\u5170\u5f0f\u6811\u578b\u5316\u5f02\u5e38", e);
        }
        if (stack.size() != 1) {
            this.buildFail("\u8868\u8fbe\u5f0f\u8bed\u6cd5\u9519\u8bef", null);
        }
        return stack.getFirst();
    }

    private void addKeyOrObject(Object object, boolean isVar) {
        if (this.isEqualsChar(58) && ExecutableUtil.isMapMethod(this.expressionNodeArrayList)) {
            this.addNode(new ExpressionNode(ExpressionEnum.Token.OP_PUT, object));
            ++this.currentIndex;
        } else if (isVar) {
            this.addNode(new ExpressionNode(ExpressionEnum.Token.VALUE_VAR, object));
        } else {
            this.addNode(new ExpressionNode(ExpressionEnum.Token.VALUE_CONSTANTS, object));
        }
    }

    private void addNode(ExpressionNode expressionNode) {
        ExpressionEnum.Token token = expressionNode.getToken();
        if (token.equals((Object)ExpressionEnum.Token.BRACKET_BEGIN) || token.getValue() < 0) {
            this.replacePrevious();
        }
        if (token == ExpressionEnum.Token.VALUE_VAR) {
            Object id = expressionNode.getParam();
            ExpressionEnum.Token op = this.aliasMap.get(id);
            if (op == null && "in".equals(id)) {
                op = ExpressionEnum.Token.OP_IN;
            }
            if (op != null && this.isArgCountAndParseStatus(op)) {
                expressionNode = new ExpressionNode(op, null);
            }
        }
        switch (expressionNode.getToken()) {
            case BRACKET_BEGIN: {
                ++this.depth;
                this.status = ParserEnum.ParseStatus.BEGIN;
                break;
            }
            case BRACKET_END: {
                --this.depth;
                if (this.depth >= 0) break;
                this.buildFail("\u62ec\u5f27\u5f02\u5e38", null);
                break;
            }
            case VALUE_CONSTANTS: 
            case VALUE_VAR: 
            case VALUE_LIST: 
            case VALUE_MAP: {
                this.status = ParserEnum.ParseStatus.EXPRESSION;
                break;
            }
            default: {
                this.status = ParserEnum.ParseStatus.OPERATOR;
            }
        }
        this.previousType = token;
        this.expressionNodeArrayList.add(expressionNode);
    }

    private boolean isArgCountAndParseStatus(ExpressionEnum.Token op) {
        int argCount = ExpressionNode.getArgCount(op);
        return argCount == 2 && this.status.equals((Object)ParserEnum.ParseStatus.EXPRESSION) || argCount == 1 && !this.status.equals((Object)ParserEnum.ParseStatus.EXPRESSION);
    }

    protected String findString() {
        char quoteChar = this.elValue.charAt(this.currentIndex++);
        StringBuilder stringBuilder = new StringBuilder();
        block5: while (this.currentIndex < this.elSize) {
            char c = this.elValue.charAt(this.currentIndex++);
            switch (c) {
                case '\\': {
                    this.findStringBackslash(stringBuilder, c);
                    continue block5;
                }
                case '\"': 
                case '\'': {
                    if (c == quoteChar) {
                        return stringBuilder.toString();
                    }
                    stringBuilder.append(c);
                    continue block5;
                }
                case '\n': 
                case '\r': {
                    throw this.buildError("JSON \u6807\u51c6\u5b57\u7b26\u4e32\u4e0d\u80fd\u6362\u884c");
                }
            }
            stringBuilder.append(c);
        }
        throw this.buildError("\u672a\u7ed3\u675f\u5b57\u7b26\u4e32");
    }

    private void findStringBackslash(StringBuilder stringBuilder, char c) {
        char cNext = this.elValue.charAt(this.currentIndex++);
        CharConsumer charConsumer = new CharConsumer();
        CharConsumerParam consumerParam = new CharConsumerParam(this.elValue, stringBuilder, c, cNext, this.currentIndex);
        BiConsumer<CharConsumer, CharConsumerParam> consumer = MapParserStringConsumerConstant.getInstance().get(Character.valueOf(cNext));
        if (consumer == null) {
            charConsumer.appendDefault(consumerParam);
        } else {
            consumer.accept(charConsumer, consumerParam);
            this.currentIndex = consumerParam.getCurrentIndex();
        }
    }

    protected FastElException buildError(String msg) {
        return new FastElException(String.format("\u8bed\u6cd5\u9519\u8bef:%s%n%s@%s", msg, this.elValue, this.currentIndex));
    }

    protected boolean isEqualsChar(int value) {
        return value > 0 && this.currentIndex < this.elSize && value == this.elValue.charAt(this.currentIndex);
    }

    private void replacePrevious() {
        ExpressionNode lt;
        ExpressionEnum.Token op;
        int last = this.expressionNodeArrayList.size() - 1;
        if (this.previousType == ExpressionEnum.Token.VALUE_VAR && last >= 0 && (op = this.aliasMap.get((lt = this.expressionNodeArrayList.get(last)).getParam())) != null) {
            this.expressionNodeArrayList.set(last, new ExpressionNode(op, null));
            this.status = ParserEnum.ParseStatus.OPERATOR;
            this.previousType = op;
        }
    }

    private void addId(String id) {
        switch (id) {
            case "true": {
                this.addNode(NODE_TRUE);
                break;
            }
            case "false": {
                this.addNode(NODE_FALSE);
                break;
            }
            case "null": {
                this.addNode(NODE_NULL);
                break;
            }
            default: {
                this.skipSpace();
                if (this.previousType == ExpressionEnum.Token.OP_GET) {
                    this.addNode(new ExpressionNode(ExpressionEnum.Token.VALUE_CONSTANTS, id));
                    break;
                }
                this.addKeyOrObject(id, true);
            }
        }
    }

    protected Number findNumber() {
        char c;
        int begin = this.currentIndex;
        boolean nag = false;
        if ((c = this.elValue.charAt(this.currentIndex++)) == '+') {
            c = this.elValue.charAt(this.currentIndex++);
        } else if (c == '-') {
            nag = true;
            c = this.elValue.charAt(this.currentIndex++);
        }
        if (c == '0') {
            ParserParam parserParam = new ParserParam(this.elValue, this.currentIndex);
            Number result = NumberUtil.parseZero(nag, parserParam);
            this.currentIndex = parserParam.getCurrentIndex();
            return result;
        }
        long numberValue = c - 48;
        while (this.currentIndex < this.elSize) {
            if ((c = this.elValue.charAt(this.currentIndex++)) >= '0' && c <= '9') {
                numberValue = numberValue * 10L + (long)(c - 48);
                continue;
            }
            if (c == '.' || c == 'E') {
                --this.currentIndex;
                ParserParam parserParam = new ParserParam(this.elValue, this.currentIndex);
                Number result = NumberUtil.parseFloat(begin, parserParam);
                this.currentIndex = parserParam.getCurrentIndex();
                return result;
            }
            --this.currentIndex;
            break;
        }
        return nag ? -numberValue : numberValue;
    }

    protected String findId() {
        int idIndex = this.currentIndex;
        if (Character.isJavaIdentifierPart(this.elValue.charAt(idIndex++))) {
            while (idIndex < this.elSize && Character.isJavaIdentifierPart(this.elValue.charAt(idIndex))) {
                ++idIndex;
            }
            this.currentIndex = idIndex;
            return this.elValue.substring(this.currentIndex, this.currentIndex);
        }
        throw this.buildError("\u65e0\u6548id");
    }

    private String findOperator() {
        int end = this.currentIndex + 1;
        char c = CharUtil.sbc2Dbc(this.elValue.charAt(this.currentIndex));
        char next = this.elValue.length() > end ? CharUtil.sbc2Dbc(this.elValue.charAt(end)) : (char)'\u0000';
        switch (c) {
            case '%': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '?': 
            case '[': 
            case ']': 
            case '^': 
            case '{': 
            case '}': 
            case '~': {
                break;
            }
            case '=': {
                end = this.findOperatorEqual(end, next);
                break;
            }
            case '!': {
                end = this.findOperatorExclamationPoint(end, next);
                break;
            }
            case '<': 
            case '>': {
                end = this.findOperatorGtLt(end, c, next);
                break;
            }
            case '&': 
            case '|': {
                if (c != next) break;
                ++end;
                break;
            }
            default: {
                return null;
            }
        }
        this.currentIndex = end;
        return StringUtil.sbc2Dbc(this.elValue.substring(this.currentIndex, this.currentIndex));
    }

    private int findOperatorGtLt(int end, char c, char next) {
        if (next == '=') {
            ++end;
        } else if (next == c && this.elValue.length() > ++end && CharUtil.sbc2Dbc(this.elValue.charAt(end)) == c) {
            ++end;
        }
        return end;
    }

    private int findOperatorEqual(int end, char next) {
        if (next != '=') {
            this.buildFail("\u4e0d\u652f\u6301\u8d4b\u503c\u64cd\u4f5c:", null);
        }
        return ++end;
    }

    private int findOperatorExclamationPoint(int end, char next) {
        if (next == '=' && this.elValue.length() > ++end && CharUtil.sbc2Dbc(this.elValue.charAt(end)) == '=') {
            ++end;
            this.buildFail("\u4e0d\u652f\u6301=== \u548c!==\u64cd\u4f5c\u7b26\uff0c\u8bf7\u4f7f\u7528==,!=", null);
        }
        return end;
    }

    private void addOperator(String op) {
        if (op == null) {
            this.buildFail("\u672a\u77e5\u64cd\u4f5c\u7b26:null", null);
        }
        if (op.length() == 1) {
            switch (op.charAt(0)) {
                case '(': {
                    this.addOperatorParenthesisLeft();
                    break;
                }
                case '[': {
                    this.addOperatorBracketLeft();
                    break;
                }
                case '{': {
                    this.addMap();
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    this.addNode(new ExpressionNode(ExpressionEnum.Token.BRACKET_END, null));
                    break;
                }
                case '+': {
                    this.addNode(new ExpressionNode(this.status == ParserEnum.ParseStatus.EXPRESSION ? ExpressionEnum.Token.OP_ADD : ExpressionEnum.Token.OP_POS, null));
                    break;
                }
                case '-': {
                    this.addNode(new ExpressionNode(this.status == ParserEnum.ParseStatus.EXPRESSION ? ExpressionEnum.Token.OP_SUB : ExpressionEnum.Token.OP_NEG, null));
                    break;
                }
                case ':': {
                    this.addNode(new ExpressionNode(ExpressionEnum.Token.OP_QUESTION_SELECT, null));
                    break;
                }
                case ',': {
                    this.addOperatorComma();
                    break;
                }
                case '/': {
                    this.addOperatorSlash(op);
                    break;
                }
                default: {
                    this.addNode(new ExpressionNode(op));
                    break;
                }
            }
        } else {
            this.addNode(new ExpressionNode(op));
        }
    }

    private void addOperatorSlash(String op) {
        int end;
        char next = this.elValue.charAt(this.currentIndex);
        if (next == '/' || next == '*') {
            --this.currentIndex;
            this.skipComment();
            return;
        }
        if (this.status != ParserEnum.ParseStatus.EXPRESSION && (end = this.findRegExp(this.elValue, this.currentIndex)) > 0) {
            String regexp = this.elValue.substring(this.currentIndex - 1, end);
            HashMap<String, String> value = new HashMap<String, String>(2);
            value.put("class", "RegExp");
            value.put("literal", regexp);
            this.addNode(new ExpressionNode(ExpressionEnum.Token.VALUE_CONSTANTS, value));
            this.currentIndex = end;
            return;
        }
        this.addNode(new ExpressionNode(op));
    }

    private void addOperatorComma() {
        if (ExecutableUtil.isMapMethod(this.expressionNodeArrayList)) {
            this.status = ParserEnum.ParseStatus.OPERATOR;
        } else {
            this.addNode(new ExpressionNode(ExpressionEnum.Token.OP_JOIN, null));
        }
    }

    private void addOperatorBracketLeft() {
        if (this.status == ParserEnum.ParseStatus.EXPRESSION) {
            this.addNode(new ExpressionNode(ExpressionEnum.Token.OP_GET, null));
            this.addNode(new ExpressionNode(ExpressionEnum.Token.BRACKET_BEGIN, null));
        } else {
            this.addList();
        }
    }

    private void addOperatorParenthesisLeft() {
        this.replacePrevious();
        if (this.status == ParserEnum.ParseStatus.EXPRESSION) {
            this.addNode(new ExpressionNode(ExpressionEnum.Token.OP_INVOKE, null));
            if (this.isEqualsChar(41)) {
                this.addNode(new ExpressionNode(ExpressionEnum.Token.VALUE_CONSTANTS, Collections.EMPTY_LIST));
                ++this.currentIndex;
            } else {
                this.addList();
            }
        } else {
            this.addNode(new ExpressionNode(ExpressionEnum.Token.BRACKET_BEGIN, null));
        }
    }

    private void addList() {
        this.addNode(new ExpressionNode(ExpressionEnum.Token.BRACKET_BEGIN, null));
        this.addNode(new ExpressionNode(ExpressionEnum.Token.VALUE_LIST, null));
        if (!this.isEqualsChar(93)) {
            this.addNode(new ExpressionNode(ExpressionEnum.Token.OP_JOIN, null));
        }
    }

    private void addMap() {
        this.addNode(new ExpressionNode(ExpressionEnum.Token.BRACKET_BEGIN, null));
        this.addNode(new ExpressionNode(ExpressionEnum.Token.VALUE_MAP, null));
    }

    int findRegExp(String text, int start) {
        boolean depth = false;
        int end = text.length();
        block9: while (start < end) {
            char c = text.charAt(start++);
            switch (c) {
                case '[': {
                    depth = true;
                    continue block9;
                }
                case ']': {
                    depth = false;
                    continue block9;
                }
                case '\\': {
                    ++start;
                    continue block9;
                }
                case '/': {
                    if (depth) continue block9;
                    block10: while (start < end) {
                        c = text.charAt(start++);
                        switch (c) {
                            case 'g': 
                            case 'i': 
                            case 'm': {
                                continue block10;
                            }
                        }
                        return start - 1;
                    }
                    continue block9;
                }
            }
        }
        return -1;
    }

    private void buildFail(String msg, Throwable throwable) {
        String message = String.format("%s%n@%s%n%s%n----%n%s", msg, this.currentIndex, this.elValue.substring(this.currentIndex), this.elValue);
        if (throwable == null) {
            throw new FastElException(message);
        }
        throw new FastElException(message, throwable);
    }

    private void skipSpace() {
        while (this.currentIndex < this.elSize && Character.isWhitespace(this.elValue.charAt(this.currentIndex))) {
            ++this.currentIndex;
        }
    }

    protected void skipComment() {
        while (true) {
            char next;
            this.skipSpace();
            if (this.currentIndex >= this.elSize || this.elValue.charAt(this.currentIndex) != '/') break;
            ++this.currentIndex;
            if ((next = this.elValue.charAt(this.currentIndex++)) == '/') {
                this.skipCommentNextSlash();
                continue;
            }
            if (next != '*') continue;
            this.skipCommentNextStar();
        }
    }

    private void skipCommentNextStar() {
        int cend;
        block2: {
            cend = this.currentIndex + 1;
            while ((cend = this.elValue.indexOf(47, cend)) > 0) {
                if (this.elValue.charAt(cend - 1) != '*') {
                    ++cend;
                    continue;
                }
                break block2;
            }
            throw this.buildError("\u672a\u7ed3\u675f\u6ce8\u91ca");
        }
        this.currentIndex = cend + 1;
    }

    private void skipCommentNextSlash() {
        int end2;
        int end1 = this.elValue.indexOf(10, this.currentIndex);
        int cend = Math.min(end1, end2 = this.elValue.indexOf(13, this.currentIndex));
        if (cend < 0) {
            cend = Math.max(end1, end2);
        }
        this.currentIndex = cend > 0 ? cend : this.elSize;
    }
}

