/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.fastel.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jiuwo.fastel.Executable;
import org.jiuwo.fastel.contract.enums.ExpressionEnum;
import org.jiuwo.fastel.impl.ExpressionNode;
import org.jiuwo.fastel.util.MethodExecutable;

public class ExecutableUtil {
    private static Map<String, Executable> cachedExecutableMap = new ConcurrentHashMap<String, Executable>();
    private static Map<Class<? extends Object>, Map<String, Executable>> classMethodMap = new ConcurrentHashMap<Class<? extends Object>, Map<String, Executable>>();

    public static Executable getExecutable(Class<? extends Object> clazz, String name, int length) {
        String key = clazz.getName() + '.' + length + name;
        Executable result = cachedExecutableMap.get(key);
        if (result == null && !cachedExecutableMap.containsKey(key)) {
            ArrayList<Method> methods = new ArrayList<Method>();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(name) || length >= 0 && method.getParameterTypes().length != length) continue;
                methods.add(method);
            }
            if (methods.size() > 0) {
                result = ExecutableUtil.createProxy(methods.toArray(new Method[methods.size()]));
                cachedExecutableMap.put(key, result);
            }
        }
        return result;
    }

    public static Executable createProxy(Method ... methods) {
        for (Method method : methods) {
            try {
                method.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MethodExecutable inv = new MethodExecutable();
        inv.methods = methods;
        return inv;
    }

    public static Executable getExecutable(Object base, String name, Object[] args) {
        Map<String, Executable> mm = ExecutableUtil.requireMethodMap(base.getClass());
        Executable executable = mm.get(name);
        if (executable == null && name instanceof String && (executable = ExecutableUtil.getExecutable(base.getClass(), name, args.length)) == null && base instanceof Class) {
            executable = ExecutableUtil.getExecutable((Class)base, name, args.length);
        }
        return executable;
    }

    private static Map<String, Executable> requireMethodMap(Class<? extends Object> clazz) {
        Map<String, Executable> methodMap = classMethodMap.get(clazz);
        if (methodMap == null) {
            Class<?>[] interfaces;
            methodMap = new HashMap<String, Executable>();
            for (Class<?> clazz2 : interfaces = clazz.getInterfaces()) {
                Map<String, Executable> m2 = ExecutableUtil.requireMethodMap(clazz2);
                methodMap.putAll(m2);
            }
            Class<? extends Object> clazz2 = clazz.getSuperclass();
            if (clazz2 != clazz) {
                if (clazz2 == Object.class && clazz.isArray() && clazz != Object[].class) {
                    clazz2 = Object[].class;
                }
                if (clazz2 != null) {
                    Map<String, Executable> m2 = ExecutableUtil.requireMethodMap(clazz2);
                    methodMap.putAll(m2);
                }
            }
        }
        return methodMap;
    }

    public static boolean isMapMethod(ArrayList<ExpressionNode> expressionNodeArrayList) {
        int depth = 0;
        for (int i = expressionNodeArrayList.size() - 1; i >= 0; --i) {
            ExpressionNode expressionNode = expressionNodeArrayList.get(i);
            ExpressionEnum.Token token = expressionNode.getToken();
            if (depth == 0) {
                if (token.equals((Object)ExpressionEnum.Token.OP_PUT) || token.equals((Object)ExpressionEnum.Token.VALUE_MAP)) {
                    return true;
                }
                if (token.equals((Object)ExpressionEnum.Token.OP_JOIN)) {
                    return false;
                }
            }
            if (token.equals((Object)ExpressionEnum.Token.BRACKET_BEGIN)) {
                --depth;
                continue;
            }
            if (!token.equals((Object)ExpressionEnum.Token.BRACKET_END)) continue;
            ++depth;
        }
        return false;
    }
}

