/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.fastel.util;

import org.jiuwo.fastel.contract.ParserParam;
import org.jiuwo.fastel.contract.enums.ExpressionEnum;

public class NumberUtil {
    private static final Class<?>[] NUMBER_CLASS = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class};

    public static final int getNumberType(Number a, Number b) {
        Class<?> aClass = a.getClass();
        Class<?> bClass = b.getClass();
        int i = NUMBER_CLASS.length;
        while (i-- > 0) {
            Class<?> c = NUMBER_CLASS[i];
            if (c != aClass && c != bClass) continue;
            return i;
        }
        return NUMBER_CLASS.length - 1;
    }

    public static boolean compare(Number a, Number b, ExpressionEnum.Token token) {
        boolean result;
        double da = a.doubleValue();
        double db = b.doubleValue();
        if (Double.isNaN(da) || Double.isNaN(db)) {
            return token.equals((Object)ExpressionEnum.Token.OP_NE) || token.equals((Object)ExpressionEnum.Token.OP_NE_STRICT);
        }
        long i = Double.compare(da, db);
        switch (token) {
            case OP_GT: {
                result = i > 0L;
                break;
            }
            case OP_GTEQ: {
                result = i >= 0L;
                break;
            }
            case OP_LT: {
                result = i < 0L;
                break;
            }
            case VALUE_MAP: 
            case OP_LTEQ: {
                result = i <= 0L;
                break;
            }
            case OP_EQ: 
            case OP_EQ_STRICT: {
                result = i == 0L;
                break;
            }
            case OP_NE: 
            case OP_NE_STRICT: {
                result = i != 0L;
                break;
            }
            default: {
                throw new IllegalStateException("\u65e0\u6548\u6bd4\u8f83\u7c7b\u578b:" + (Object)((Object)token));
            }
        }
        return result;
    }

    public static Number plus(Number a, Number b) {
        switch (NumberUtil.getNumberType(a, b)) {
            case 0: 
            case 1: 
            case 2: {
                return a.intValue() + b.intValue();
            }
            case 3: {
                return a.longValue() + b.longValue();
            }
            case 4: {
                return Float.valueOf(a.floatValue() + b.floatValue());
            }
        }
        return a.doubleValue() + b.doubleValue();
    }

    public static Number subtract(Number a, Number b) {
        switch (NumberUtil.getNumberType(a, b)) {
            case 0: 
            case 1: 
            case 2: {
                return a.intValue() - b.intValue();
            }
            case 3: {
                return a.longValue() - b.longValue();
            }
            case 4: {
                return Float.valueOf(a.floatValue() - b.floatValue());
            }
        }
        return a.doubleValue() - b.doubleValue();
    }

    public static Number multiply(Number a, Number b) {
        switch (NumberUtil.getNumberType(a, b)) {
            case 0: 
            case 1: 
            case 2: {
                return a.intValue() * b.intValue();
            }
            case 3: {
                return a.longValue() * b.longValue();
            }
            case 4: {
                return Float.valueOf(a.floatValue() * b.floatValue());
            }
        }
        return a.doubleValue() * b.doubleValue();
    }

    public static Number divide(Number a, Number b) {
        switch (NumberUtil.getNumberType(a, b)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return a.doubleValue() / b.doubleValue();
            }
            case 4: {
                return Float.valueOf(a.floatValue() / b.floatValue());
            }
        }
        return a.doubleValue() / b.doubleValue();
    }

    public static Number modulus(Number a, Number b) {
        switch (NumberUtil.getNumberType(a, b)) {
            case 0: 
            case 1: 
            case 2: {
                return a.intValue() % b.intValue();
            }
            case 3: {
                return a.longValue() % b.longValue();
            }
            case 4: {
                return Float.valueOf(a.floatValue() % b.floatValue());
            }
        }
        return a.doubleValue() % b.doubleValue();
    }

    public static Number parseZero(boolean neg, ParserParam parserParam) {
        if (parserParam.getCurrentIndex() < parserParam.getElSize()) {
            char c = parserParam.getElValue().charAt(parserParam.plusOne());
            if (c == 'x' || c == 'X') {
                long value = NumberUtil.parseHex(parserParam);
                if (neg) {
                    value = -value;
                }
                return value;
            }
            if (c > '0' && c <= '7') {
                parserParam.subtractOne();
                int value = NumberUtil.parseOctal(parserParam);
                if (neg) {
                    value = -value;
                }
                return value;
            }
            if (c == '.') {
                parserParam.subtractOne();
                return NumberUtil.parseFloat(parserParam.getCurrentIndex() - 1, parserParam);
            }
            parserParam.subtractOne();
            return 0;
        }
        return 0;
    }

    public static Number parseFloat(int begin, ParserParam parserParam) {
        boolean isFloatingPoint = false;
        char next = parserParam.getElValue().charAt(parserParam.getCurrentIndex());
        if (next == '.') {
            int p = parserParam.plusOne();
            NumberUtil.seekDecimal(parserParam);
            if (parserParam.getCurrentIndex() == p) {
                parserParam.subtractOne();
                String ns = parserParam.getElValue().substring(begin, parserParam.getCurrentIndex());
                return Long.parseLong(ns);
            }
            isFloatingPoint = true;
            next = parserParam.getCurrentIndex() < parserParam.getElSize() ? parserParam.getElValue().charAt(parserParam.getCurrentIndex()) : (char)'\u0000';
        }
        if (next == 'E' || next == 'e') {
            parserParam.plusOne();
            isFloatingPoint = true;
            NumberUtil.seekNegative(parserParam);
            NumberUtil.seekDecimal(parserParam);
        }
        String ns = parserParam.getElValue().substring(begin, parserParam.getCurrentIndex());
        if (isFloatingPoint) {
            return Double.parseDouble(ns);
        }
        return Long.parseLong(ns);
    }

    private static long parseHex(ParserParam parserParam) {
        long longValue = 0L;
        while (parserParam.getCurrentIndex() < parserParam.getElSize()) {
            char c = parserParam.getElValue().charAt(parserParam.plusOne());
            if (c >= '0' && c <= '9') {
                longValue = (longValue << 4) + (long)(c - 48);
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                longValue = (longValue << 4) + (long)(c - 65 + 10);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                longValue = (longValue << 4) + (long)(c - 97 + 10);
                continue;
            }
            parserParam.subtractOne();
            break;
        }
        return longValue;
    }

    private static int parseOctal(ParserParam parserParam) {
        int lvalue = 0;
        while (parserParam.getCurrentIndex() < parserParam.getElSize()) {
            char c = parserParam.getElValue().charAt(parserParam.plusOne());
            if (c >= '0' && c < '8') {
                lvalue = (lvalue << 3) + (c - 48);
                continue;
            }
            parserParam.subtractOne();
            break;
        }
        return lvalue;
    }

    private static void seekDecimal(ParserParam parserParam) {
        while (parserParam.getCurrentIndex() < parserParam.getElSize()) {
            char c = parserParam.getElValue().charAt(parserParam.plusOne());
            if (c >= '0' && c <= '9') continue;
            parserParam.subtractOne();
            break;
        }
    }

    private static void seekNegative(ParserParam parserParam) {
        char c = parserParam.getElValue().charAt(parserParam.plusOne());
        if (c != '-' && c != '+') {
            parserParam.subtractOne();
        }
    }
}

