/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.fastel.util;

import java.util.Date;
import org.jiuwo.fastel.util.ReflectUtil;

public class ParseUtil {
    private static Number parseToNumber(String text, int radix) {
        try {
            return Integer.parseInt(text, radix);
        }
        catch (Exception e) {
            return Long.parseLong(text, radix);
        }
    }

    public static boolean parseToBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Number) {
            float f = ((Number)value).floatValue();
            return f != 0.0f && !Float.isNaN(f);
        }
        if (value instanceof String) {
            return ((String)value).length() > 0;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    public static Number parseToNumber(Object value) {
        if ((value = ParseUtil.parseToPrimitive(value, String.class)) == null) {
            return 0;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        String text = (String)value;
        try {
            if (text.indexOf(46) >= 0) {
                return Float.valueOf(Float.parseFloat(text));
            }
            if (text.length() > 1) {
                char c1 = text.charAt(0);
                char c2 = text.charAt(1);
                if (c1 == '+' || c1 == '-') {
                    c1 = c2;
                    if (text.length() > 2) {
                        c2 = text.charAt(2);
                    }
                }
                if (c1 == '0') {
                    if (c2 == 'x' || c2 == 'X') {
                        return ParseUtil.parseToNumber(text.substring(2), 16);
                    }
                    return ParseUtil.parseToNumber(text, 10);
                }
                if (text.indexOf(69) > 0 || text.indexOf(101) > 0) {
                    return Float.valueOf(Float.parseFloat(text));
                }
            }
            return ParseUtil.parseToNumber(text, 10);
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
    }

    public static Object parseToPrimitive(Object value, Class<?> expectedType) {
        boolean toString;
        if (expectedType == Number.class) {
            toString = false;
        } else if (expectedType == String.class) {
            toString = true;
        } else if (expectedType == null) {
            toString = !(value instanceof Date);
        } else {
            throw new IllegalArgumentException("expectedType \u53ea\u80fd\u662f Number\u6216\u8005String");
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            return value;
        }
        if (value instanceof String) {
            return value;
        }
        if (toString) {
            return String.valueOf(value);
        }
        if (value instanceof Date) {
            return new Long(((Date)value).getTime());
        }
        return String.valueOf(value);
    }

    public static Object parseToValue(Object value, Class<?> type) {
        if (type == String.class) {
            return value == null ? null : value.toString();
        }
        if (type == Character.class) {
            if (value == null) {
                return Character.valueOf('\u0000');
            }
            if ((value = ParseUtil.parseToPrimitive(value, String.class)) instanceof Number) {
                return Character.valueOf((char)((Number)value).intValue());
            }
            String text = (String)value;
            if (text.length() > 0) {
                return Character.valueOf(text.charAt(0));
            }
            return 0;
        }
        if (Number.class.isAssignableFrom(type = ReflectUtil.toWrapper(type))) {
            Number n = ParseUtil.parseToNumber(value);
            return ReflectUtil.toValue(n, type);
        }
        if (type == Boolean.class) {
            return ParseUtil.parseToBoolean(ParseUtil.parseToPrimitive(value, type));
        }
        return value;
    }

    public static String parseToString(Object value) {
        if ((value = ParseUtil.parseToPrimitive(value, String.class)) instanceof Number) {
            return ParseUtil.parseToString((Number)value, 10);
        }
        return String.valueOf(value);
    }

    static String parseToString(Number thiz, int radix) {
        if (radix <= 0 || radix > 36) {
            radix = 10;
        }
        if (thiz instanceof Double || thiz instanceof Float) {
            return ParseUtil.floatToString(thiz.doubleValue(), radix);
        }
        return Long.toString(thiz.longValue(), radix);
    }

    private static String floatToString(double d, int base) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return d > 0.0 ? "Infinity" : "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        if (base == 10) {
            String result = Double.toString(d);
            if (result.endsWith(".0")) {
                result = result.substring(0, result.length() - 2);
            }
            return result;
        }
        return Long.toString((long)d, base);
    }
}

