/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.fastel.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jiuwo.fastel.exception.FastElException;

public class ReflectUtil {
    private static final Map<Class<?>, Map<String, Method>> READER_MAP = (Map)ReflectUtil.newMap();
    private static final Map<Class<?>, Map<String, Method>> WRITER_MAP = (Map)ReflectUtil.newMap();
    private static final Map<Class<?>, Map<String, Type[]>> TYPE_MAP = (Map)ReflectUtil.newMap();
    private static final Map<Class<?>, Map<String, Field>> FIELD_MAP = (Map)ReflectUtil.newMap();
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_MAP = (Map)ReflectUtil.newMap();
    private static final Map<Class<? extends Enum<?>>, Enum<?>[]> ENUM_MAP = (Map)ReflectUtil.newMap();
    private static Object initLock = new Object();

    private static <T> T newMap() {
        return (T)new HashMap();
    }

    public static Map<String, Method> getGetterMap(Class<?> clazz) {
        Map<String, Method> propertyMap = READER_MAP.get(clazz);
        if (propertyMap == null) {
            ReflectUtil.initProperties(clazz);
            propertyMap = READER_MAP.get(clazz);
        }
        return propertyMap;
    }

    public static Map<String, Method> getSetterMap(Class<?> clazz) {
        Map<String, Method> propertyMap = WRITER_MAP.get(clazz);
        if (propertyMap == null) {
            ReflectUtil.initProperties(clazz);
            propertyMap = WRITER_MAP.get(clazz);
        }
        return propertyMap;
    }

    private static Map<String, Type[]> getTypeMap(Class<?> clazz) {
        Map<String, Type[]> tMap = TYPE_MAP.get(clazz);
        if (tMap == null) {
            ReflectUtil.initProperties(clazz);
            tMap = TYPE_MAP.get(clazz);
        }
        return tMap;
    }

    public static Map<String, Field> getFieldMap(Class<?> clazz) {
        Map<String, Field> fMap = FIELD_MAP.get(clazz);
        if (fMap == null) {
            ReflectUtil.initProperties(clazz);
            fMap = FIELD_MAP.get(clazz);
        }
        return fMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initProperties(Class<?> clazz) {
        Object object = initLock;
        synchronized (object) {
            try {
                Constructor<?> cons = clazz.getDeclaredConstructor(new Class[0]);
                if (!cons.isAccessible()) {
                    cons.setAccessible(true);
                }
                CONSTRUCTOR_MAP.put(clazz, cons);
            }
            catch (Exception cons) {
                // empty catch block
            }
            HashMap<String, Method> getterMap = new HashMap<String, Method>();
            HashMap<String, Method> setterMap = new HashMap<String, Method>();
            HashMap<String, Type[]> propertyMap = new HashMap<String, Type[]>();
            HashMap<String, Field> fieldMap = new HashMap<String, Field>();
            try {
                Field[] fields;
                Method[] methods;
                if (!clazz.equals(Object.class)) {
                    getterMap.putAll(ReflectUtil.getGetterMap(clazz.getSuperclass()));
                    setterMap.putAll(ReflectUtil.getSetterMap(clazz.getSuperclass()));
                    propertyMap.putAll(ReflectUtil.getTypeMap(clazz.getSuperclass()));
                    fieldMap.putAll(ReflectUtil.getFieldMap(clazz.getSuperclass()));
                }
                for (Method m : methods = clazz.getDeclaredMethods()) {
                    if ((m.getModifiers() & 1) <= 0) continue;
                    Class<?> type = m.getReturnType();
                    Class<?>[] params = m.getParameterTypes();
                    String name = m.getName();
                    if (type == Void.TYPE) {
                        if (params.length != 1 || !name.startsWith("set")) continue;
                        type = params[0];
                        ReflectUtil.initMethod(setterMap, propertyMap, m, name.substring(3));
                        continue;
                    }
                    if (params.length != 0) continue;
                    if (name.startsWith("get") && !"getClass".equals(name)) {
                        ReflectUtil.initMethod(getterMap, propertyMap, m, name.substring(3));
                        continue;
                    }
                    if (type != Boolean.TYPE || !name.startsWith("is")) continue;
                    ReflectUtil.initMethod(getterMap, propertyMap, m, name.substring(2));
                }
                boolean nogs = propertyMap.isEmpty();
                boolean isMember = clazz.isMemberClass();
                for (Field f : fields = clazz.getDeclaredFields()) {
                    f.setAccessible(true);
                    String name = f.getName();
                    if (nogs && (isMember || 0 < (f.getModifiers() & 1))) {
                        propertyMap.put(name, new Type[]{f.getGenericType(), clazz});
                    }
                    fieldMap.put(name, f);
                }
            }
            catch (Exception exception) {
            }
            finally {
                READER_MAP.put(clazz, Collections.unmodifiableMap(getterMap));
                WRITER_MAP.put(clazz, Collections.unmodifiableMap(setterMap));
                TYPE_MAP.put(clazz, Collections.unmodifiableMap(propertyMap));
                FIELD_MAP.put(clazz, Collections.unmodifiableMap(fieldMap));
            }
        }
    }

    private static void initMethod(Map<String, Method> propertyMap, Map<String, Type[]> typeMap, Method m, String name) {
        char c;
        if (name.length() > 0 && Character.isUpperCase(c = name.charAt(0))) {
            Type[] ot;
            name = Character.toLowerCase(c) + name.substring(1);
            m.setAccessible(true);
            propertyMap.put(name, m);
            Class<?> type = m.getGenericReturnType();
            if (type == Void.TYPE) {
                type = m.getParameterTypes()[0];
            }
            if ((ot = typeMap.get(name)) == null || ot[0] != type) {
                // empty if block
            }
            typeMap.put(name, new Type[]{type, m.getDeclaringClass()});
        }
    }

    private static int toIndex(Object key) {
        return key instanceof Number ? ((Number)key).intValue() : Integer.parseInt(String.valueOf(key));
    }

    public static Class<? extends Object> getValueType(Type type) {
        Type result = null;
        Class clazz = null;
        clazz = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        if (Collection.class.isAssignableFrom(clazz)) {
            result = ReflectUtil.getParameterizedType(type, Collection.class, 0);
        } else if (Map.class.isAssignableFrom(clazz)) {
            result = ReflectUtil.getParameterizedType(type, Map.class, 1);
        }
        if (result != null) {
            return ReflectUtil.baseClass(result);
        }
        return Object.class;
    }

    public static Type getParameterizedType(Type ownerType, Class<?> declaredClass, Type declaredType) {
        if (declaredType instanceof TypeVariable) {
            String name = ((TypeVariable)declaredType).getName();
            TypeVariable<Class<?>>[] typeVariables = declaredClass.getTypeParameters();
            if (typeVariables != null) {
                for (int i = 0; i < typeVariables.length; ++i) {
                    if (!name.equals(typeVariables[i].getName())) continue;
                    return ReflectUtil.getParameterizedType(ownerType, declaredClass, i);
                }
            }
            return declaredType;
        }
        if (declaredType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)declaredType;
            Type[] types = parameterizedType.getActualTypeArguments();
            boolean changed = false;
            for (int i = 0; i < types.length; ++i) {
                Type argumentType = types[i];
                Type trueType = ReflectUtil.getParameterizedType(ownerType, declaredClass, argumentType);
                if (argumentType == trueType) continue;
                types[i] = trueType;
                changed = true;
            }
            if (changed) {
                return ReflectUtil.changedParameterizedType(parameterizedType, types);
            }
        }
        return declaredType;
    }

    private static Type changedParameterizedType(final ParameterizedType parameterizedType, final Type[] changedTypes) {
        return new ParameterizedType(){

            @Override
            public Type getRawType() {
                return parameterizedType.getRawType();
            }

            @Override
            public Type getOwnerType() {
                return parameterizedType.getOwnerType();
            }

            @Override
            public Type[] getActualTypeArguments() {
                return changedTypes;
            }
        };
    }

    public static Type getParameterizedType(Type ownerType, Class<?> declaredClass, int paramIndex) {
        Class clazz = null;
        ParameterizedType pt = null;
        Type[] ats = null;
        TypeVariable<Class<T>>[] tps = null;
        if (ownerType instanceof ParameterizedType) {
            pt = (ParameterizedType)ownerType;
            clazz = (Class)pt.getRawType();
            ats = pt.getActualTypeArguments();
            tps = clazz.getTypeParameters();
        } else {
            clazz = (Class)ownerType;
        }
        if (declaredClass == clazz) {
            if (pt != null) {
                return pt.getActualTypeArguments()[paramIndex];
            }
            return Object.class;
        }
        Class<?>[] ifs = clazz.getInterfaces();
        for (int i = 0; i < ifs.length; ++i) {
            Class<?> ifc = ifs[i];
            if (!declaredClass.isAssignableFrom(ifc)) continue;
            return ReflectUtil.getTureType(ReflectUtil.getParameterizedType(clazz.getGenericInterfaces()[i], declaredClass, paramIndex), tps, ats);
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && declaredClass.isAssignableFrom(superClass)) {
            return ReflectUtil.getTureType(ReflectUtil.getParameterizedType(clazz.getGenericSuperclass(), declaredClass, paramIndex), tps, ats);
        }
        throw new IllegalArgumentException("\u67e5\u627e\u771f\u5b9e\u7c7b\u578b\u5931\u8d25:" + ownerType);
    }

    private static Type getTureType(Type type, TypeVariable<?>[] typeVariables, Type[] actualTypes) {
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            String name = tv.getName();
            if (actualTypes != null) {
                for (int i = 0; i < typeVariables.length; ++i) {
                    if (!name.equals(typeVariables[i].getName())) continue;
                    return actualTypes[i];
                }
            }
            return tv;
        }
        return type;
    }

    public static Class<? extends Object> baseClass(Type result) {
        if (result instanceof Class) {
            return (Class)result;
        }
        if (result instanceof ParameterizedType) {
            return ReflectUtil.baseClass(((ParameterizedType)result).getRawType());
        }
        if (result instanceof WildcardType) {
            return ReflectUtil.baseClass(((WildcardType)result).getUpperBounds()[0]);
        }
        return null;
    }

    public static Class<?> getPropertyClass(Type type, Object key) {
        return ReflectUtil.baseClass(ReflectUtil.getPropertyType(type, key));
    }

    public static Type getPropertyType(Type type, Object key) {
        Class<? extends Object> clazz = ReflectUtil.baseClass(type);
        if (clazz != null) {
            if (Collection.class.isAssignableFrom(clazz)) {
                return ReflectUtil.getValueType(type);
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return ReflectUtil.getValueType(type);
            }
            if (clazz.isArray()) {
                if ("length".equals(key)) {
                    return Integer.TYPE;
                }
                if (Number.class.isInstance(key)) {
                    return clazz.getComponentType();
                }
            } else {
                Type[] pd = ReflectUtil.getTypeMap(clazz).get(String.valueOf(key));
                if (pd != null) {
                    return ReflectUtil.getParameterizedType(type, (Class)pd[1], pd[0]);
                }
            }
        }
        return null;
    }

    public static Object getValue(Object context, Object key) {
        Class<?> clazz = context.getClass();
        if (context != null) {
            try {
                if (context instanceof Map) {
                    return ((Map)context).get(key);
                }
                if (key instanceof String) {
                    Method method = ReflectUtil.getGetterMap(clazz).get(key);
                    if (method == null) {
                        Field field = context instanceof Class ? ReflectUtil.getFieldMap((Class)context).get(key) : ReflectUtil.getFieldMap(clazz).get(key);
                        if (field != null) {
                            return field.get(context);
                        }
                    } else {
                        return method.invoke(context, new Object[0]);
                    }
                    if ("length".equals(key)) {
                        if (clazz.isArray()) {
                            return Array.getLength(context);
                        }
                        if (context instanceof Collection) {
                            return ((Collection)context).size();
                        }
                        if (context instanceof String) {
                            return ((String)context).length();
                        }
                    }
                    if (context instanceof Map) {
                        return ((Map)context).get(key);
                    }
                    if (clazz.isArray()) {
                        return Array.getLength(context);
                    }
                    return Array.get(context, ReflectUtil.toIndex(key));
                }
                if (context instanceof List) {
                    return ((List)context).get(ReflectUtil.toIndex(key));
                }
            }
            catch (Exception e) {
                throw new FastElException(e);
            }
        }
        return null;
    }

    public static void setValue(Object base, Object key, Object value) {
        if (base != null) {
            try {
                Class<?> clazz = base.getClass();
                if (clazz.isArray()) {
                    Array.set(base, ReflectUtil.toIndex(key), value);
                } else if (base instanceof List) {
                    ((List)base).set(ReflectUtil.toIndex(key), value);
                }
                if (base instanceof Map) {
                    ((Map)base).put(key, value);
                }
                String name = String.valueOf(key);
                Method method = ReflectUtil.getSetterMap(clazz).get(name);
                if (method != null) {
                    if (value != null) {
                        Class<?> type = method.getParameterTypes()[0];
                        value = ReflectUtil.toWrapper(value, type);
                    }
                    method.invoke(base, value);
                } else {
                    Field field = FIELD_MAP.get(clazz).get(name);
                    if (value != null) {
                        Class<?> type = field.getType();
                        value = ReflectUtil.toWrapper(value, type);
                    }
                    field.set(base, value);
                }
            }
            catch (Exception e) {
                throw new FastElException(e);
            }
        }
    }

    private static Object toWrapper(Object value, Class<?> type) {
        if (!type.isInstance(value) && Number.class.isAssignableFrom(type = ReflectUtil.toWrapper(type))) {
            value = ReflectUtil.toValue((Number)value, type);
        }
        return value;
    }

    public static Number toValue(Number value, Class<? extends Object> type) {
        if (type == Long.class) {
            return value.longValue();
        }
        if (type == Integer.class) {
            return value.intValue();
        }
        if (type == Short.class) {
            return value.shortValue();
        }
        if (type == Byte.class) {
            return value.byteValue();
        }
        if (type == Double.class) {
            return value.doubleValue();
        }
        if (type == Float.class) {
            return Float.valueOf(value.floatValue());
        }
        Class<? extends Object> clazz = ReflectUtil.toWrapper(type);
        if (clazz == type) {
            return null;
        }
        return ReflectUtil.toValue(value, clazz);
    }

    public static final Class<? extends Object> toWrapper(Class<? extends Object> type) {
        if (type.isPrimitive()) {
            if (Byte.TYPE == type) {
                return Byte.class;
            }
            if (Short.TYPE == type) {
                return Short.class;
            }
            if (Integer.TYPE == type) {
                return Integer.class;
            }
            if (Long.TYPE == type) {
                return Long.class;
            }
            if (Float.TYPE == type) {
                return Float.class;
            }
            if (Double.TYPE == type) {
                return Double.class;
            }
            if (Character.TYPE == type) {
                return Character.class;
            }
            if (Boolean.TYPE == type) {
                return Boolean.class;
            }
        }
        return type;
    }
}

