/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.fastel.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jiuwo.fastel.contract.enums.ExpressionEnum;
import org.jiuwo.fastel.impl.ExpressionNode;

public class TreeUtil {
    public static void prepareSelect(ArrayList<ExpressionNode> expressionNodeArrayList) {
        int nodeArraySize = expressionNodeArrayList.size();
        while (nodeArraySize-- > 0) {
            ExpressionEnum.Token token1 = expressionNodeArrayList.get(nodeArraySize).getToken();
            if (token1 == ExpressionEnum.Token.OP_QUESTION) {
                int pos = TreeUtil.getSelectRange(nodeArraySize, -1, -1, expressionNodeArrayList);
                expressionNodeArrayList.add(pos + 1, new ExpressionNode(ExpressionEnum.Token.BRACKET_BEGIN, null));
                ++nodeArraySize;
                continue;
            }
            if (token1 != ExpressionEnum.Token.OP_QUESTION_SELECT) continue;
            int end = expressionNodeArrayList.size();
            int pos = TreeUtil.getSelectRange(nodeArraySize, 1, end, expressionNodeArrayList);
            expressionNodeArrayList.add(pos, new ExpressionNode(ExpressionEnum.Token.BRACKET_END, null));
        }
    }

    public static void toTree(List<ExpressionNode> nodes, LinkedList<ExpressionNode> stack) {
        block3: for (ExpressionNode item : nodes) {
            ExpressionEnum.Token token = item.getToken();
            switch (token) {
                case VALUE_CONSTANTS: 
                case VALUE_VAR: 
                case VALUE_LIST: 
                case VALUE_MAP: {
                    stack.addFirst(item);
                    continue block3;
                }
            }
            if ((token.getValue() & 0x300) > 0) {
                ExpressionNode right = stack.removeFirst();
                ExpressionNode left = stack.removeFirst();
                item.setLeft(left);
                item.setRight(right);
                stack.addFirst(item);
                continue;
            }
            ExpressionNode arg1 = stack.removeFirst();
            item.setLeft(arg1);
            stack.addFirst(item);
        }
    }

    public static List<ExpressionNode> right(List<ExpressionNode> nodes) {
        LinkedList<List<ExpressionNode>> rightStack = new LinkedList<List<ExpressionNode>>();
        rightStack.addFirst(new ArrayList());
        LinkedList<ExpressionNode> buffer = new LinkedList<ExpressionNode>();
        for (ExpressionNode item : nodes) {
            if (item.getToken().getValue() > 0 || item.getToken().getValue() <= ExpressionEnum.Token.BRACKET_BEGIN.getValue()) {
                ExpressionNode operator;
                if (buffer.isEmpty()) {
                    buffer.addFirst(item);
                    continue;
                }
                if (item.getToken().equals((Object)ExpressionEnum.Token.BRACKET_BEGIN)) {
                    buffer.addFirst(item);
                    continue;
                }
                if (item.getToken().equals((Object)ExpressionEnum.Token.BRACKET_END)) {
                    while (!(operator = (ExpressionNode)buffer.removeFirst()).getToken().equals((Object)ExpressionEnum.Token.BRACKET_BEGIN)) {
                        TreeUtil.addRightNode(rightStack, operator);
                    }
                    continue;
                }
                while (!buffer.isEmpty() && TreeUtil.rightEnd(item, (ExpressionNode)buffer.getFirst())) {
                    operator = (ExpressionNode)buffer.removeFirst();
                    TreeUtil.addRightNode(rightStack, operator);
                }
                buffer.addFirst(item);
                continue;
            }
            TreeUtil.addRightNode(rightStack, item);
        }
        while (!buffer.isEmpty()) {
            ExpressionNode operator = (ExpressionNode)buffer.removeFirst();
            TreeUtil.addRightNode(rightStack, operator);
        }
        return (List)rightStack.getFirst();
    }

    public static void addRightNode(LinkedList<List<ExpressionNode>> rightStack, ExpressionNode node) {
        List<ExpressionNode> list = rightStack.getFirst();
        list.add(node);
    }

    public static boolean rightEnd(ExpressionNode node, ExpressionNode left) {
        int priority;
        ExpressionEnum.Token leftToken = left.getToken();
        ExpressionEnum.Token token = node.getToken();
        int leftPriority = TreeUtil.getPriority(leftToken);
        if (leftPriority == (priority = TreeUtil.getPriority(token)) && ExpressionNode.isPrefix(token)) {
            return false;
        }
        return priority <= leftPriority;
    }

    public static int getSelectRange(int p2, int inc, int end, ArrayList<ExpressionNode> expressionNodeArrayList) {
        int dep = 0;
        while ((p2 += inc) != end) {
            ExpressionEnum.Token token2 = expressionNodeArrayList.get(p2).getToken();
            if (token2.getValue() <= 0) continue;
            if (token2 == ExpressionEnum.Token.BRACKET_BEGIN) {
                dep += inc;
            } else if (token2 == ExpressionEnum.Token.BRACKET_END) {
                dep -= inc;
            } else if (dep == 0 && TreeUtil.getPriority(token2) <= TreeUtil.getPriority(ExpressionEnum.Token.OP_QUESTION)) {
                return p2;
            }
            if (dep >= 0) continue;
            return p2;
        }
        return inc > 0 ? end : -1;
    }

    private static int getPriority(ExpressionEnum.Token token) {
        switch (token) {
            case BRACKET_BEGIN: 
            case BRACKET_END: {
                return Integer.MIN_VALUE;
            }
        }
        return (token.getValue() & 0xF0) << 4 | (token.getValue() & 0xF00) >> 8;
    }
}

